package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：EgcAfOrderServState
 * 描述：售后服务单状态
 */
public enum EgcAfOrderServState implements DictionaryEnum {

    SUBMIT_APPLICATION("SERV_STATE", "100", "已申请待供方确认", "售后服务单状态"),
    APPROVAL_PASS("SERV_STATE", "200", "售后中", "售后服务单状态"),
    REMARK_COMPLETED("SERV_STATE", "201", "供方标记售后完成", "售后服务单状态"),
    APPROVAL_NOT_PASS("SERV_STATE", "300", "售后拒绝", "售后服务单状态"),
    CANCEL("SERV_STATE", "400", "已取消", "售后服务单状态"),
    COMPLETED("SERV_STATE", "401", "买方确认售后完成", "售后服务单状态");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    EgcAfOrderServState(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
