package com.tydic.dyc.pro.base.core.flow.repository.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 描述：流程任务实例DTO
 * @author yuhao
 * @date 2025-04-17 17:47
 **/
@Data
public class DycProPublicTaskInstDTO implements Serializable {
    private static final long serialVersionUID = 6644164232519697457L;
    /**
     * 数据id
     */
    private Long dataId;
    /**
     * 所属中心:
     AGR：协议
     UOC：订单
     UMC：会员
     FSC：结算
     UCC：商品

     */
    private String centerCode;
    /**
     * 任务实例id
     */
    private String taskInstId;
    /**
     * 流程实例id
     */
    private String procInstId;
    /**
     * 流程定义key
     */
    private String procDefKey;
    /**
     * 流程类型:
     业务流：BUSINESS;
     审批流：APPROVE
     */
    private String procType;
    /**
     * 流程名称
     */
    private String procName;
    /**
     * 业务单据id
     */
    private Long objId;
    /**
     * 业务单据类型:
     订单相关单据：10打头，后面加2位数字编码，如10XX；
     商品相关单据：20打头，后面加2位数字编码，如20XX；
     协议相关单据：30打头，后面加2位数字编码，如30XX；
     会员相关单据：40打头，后面加2位数字编码，如40XX；
     结算相关单据：50打头，后面加2位数字编码，如50XX；

     */
    private String objType;
    /**
     * 业务类型
     */
    private String busiType;
    /**
     * 任务标识
     0 ：正常任务；
     1：前加签任务
     2：后加签任务
     3：转签任务
     */
    private Integer taskSignTag;
    /**
     * 环节编码
     */
    private String stepCode;
    /**
     * 环节名称
     */
    private String stepName;
    /**
     * 任务创建时间
     */
    private Date createTime;
    /**
     * 任务更新时间
     */
    private Date updateTime;
    /**
     * 任务归属人id
     */
    private Long taskUserId;
    /**
     * 任务待办人名称
     */
    private String taskUserName;
    /**
     * 任务待办人机构id
     */
    private Long taskUserOrgId;
    /**
     * 任务待办人机构名称
     */
    private String taskUserOrgName;
    /**
     * 任务待办人公司id
     */
    private Long taskUserCompanyId;
    /**
     * 任务待办人公司名称
     */
    private String taskUserCompanyName;
    /**
     * 任务待办人机构树
     */
    private String taskUserOrgPath;
    /**
     * 完结标志:
     0：未完结
     1：已完结
     2：已取消
     */
    private Integer finishTag;
    /**
     * 完成时间
     */
    private Date finishTime;
    /**
     * 任务处理人ID
     */
    private Long dealUserId;
    /**
     * 任务处理人名称
     */
    private String dealUserName;
    /**
     * 任务处理人机构id
     */
    private Long dealUserOrgId;
    /**
     * 任务处理人机构名称
     */
    private String dealUserOrgName;
    /**
     * 任务处理人公司id
     */
    private Long dealUserCompanyId;
    /**
     * 任务处理人公司名称
     */
    private String dealUserCompanyName;
    /**
     * 任务处理人机构树
     */
    private String dealUserOrgPath;
    /**
     * 处理结果:
     通过：PASS
     驳回：REJECT
     转交：TRANSFER
     */
    private String dealResult;
    /**
     * 处理备注
     */
    private String dealRemark;
    /**
     * 删除标志：0:未删除；1已删除
     */
    private Integer delFlag;

}
