/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.base.core.contentreview.impl;

import com.aliyun.imageaudit20191230.Client;
import com.aliyun.imageaudit20191230.models.ScanImageAdvanceRequest;
import com.aliyun.imageaudit20191230.models.ScanImageRequest;
import com.aliyun.imageaudit20191230.models.ScanImageResponse;
import com.aliyun.imageaudit20191230.models.ScanImageResponseBody;
import com.aliyun.teautil.models.RuntimeOptions;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.pro.base.core.contentreview.api.DycProContentReviewAliyunImageScanService;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanFaceBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanFrameBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanLogoDataBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanProgramCodeDataBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanReqBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanResultItemBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanRspBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanSfaceDataBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanSubResultBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanTaskBO;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAliyunImageScanLableEnum;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycProContentReviewAliyunImageScanServiceImpl
implements DycProContentReviewAliyunImageScanService {
    private static final Logger log = LoggerFactory.getLogger(DycProContentReviewAliyunImageScanServiceImpl.class);
    @Autowired
    private Client aliyunClient;
    @Autowired
    private FileClient fileClient;

    @Override
    public DycProContentReviewImageScanRspBO imageScan(DycProContentReviewImageScanReqBO reqBO) {
        ScanImageResponse scanImageResponse;
        this.imageScanParamVerify(reqBO);
        RuntimeOptions runtime = new RuntimeOptions();
        HashMap<String, String> originalUrlMap = new HashMap<String, String>();
        for (DycProContentReviewImageScanTaskBO taskBO : reqBO.getTask()) {
            taskBO.setDataId(UUID.randomUUID().toString());
            originalUrlMap.put(taskBO.getDataId(), taskBO.getImageURL());
        }
        try {
            Date start = new Date();
            if (reqBO.getTask().get(0).getImageURL().contains("oss")) {
                ScanImageRequest scanImageRequest = this.getScanImageRequest(reqBO);
                scanImageResponse = this.aliyunClient.scanImageWithOptions(scanImageRequest, runtime);
            } else {
                ScanImageAdvanceRequest scanImageAdvanceRequest = this.getImageAdvanceRequest(reqBO);
                scanImageResponse = this.aliyunClient.scanImageAdvance(scanImageAdvanceRequest, runtime);
            }
            Date end = new Date();
            log.info("\u56fe\u7247\u68c0\u6d4b\u603b\u8017\u65f6\uff1a" + (end.getTime() - start.getTime()) + "ms");
        }
        catch (Exception e) {
            log.error("\u963f\u91cc\u4e91API\u8c03\u7528\u56fe\u7247\u76d1\u6d4b\u5931\u8d25\uff1a" + e.getMessage());
            throw new ZTBusinessException("\u963f\u91cc\u4e91API\u8c03\u7528\u56fe\u7247\u76d1\u6d4b\u5931\u8d25" + e.getMessage());
        }
        if (scanImageResponse == null || scanImageResponse.getBody() == null || scanImageResponse.statusCode != 200) {
            return null;
        }
        ScanImageResponseBody responseBody = scanImageResponse.getBody();
        DycProContentReviewImageScanRspBO resultBO = new DycProContentReviewImageScanRspBO();
        resultBO.setRequestId(responseBody.getRequestId());
        ArrayList<DycProContentReviewImageScanResultItemBO> resultItems = new ArrayList<DycProContentReviewImageScanResultItemBO>();
        if (responseBody.getData().getResults() != null) {
            for (ScanImageResponseBody.ScanImageResponseBodyDataResults result : responseBody.getData().getResults()) {
                ArrayList<DycProContentReviewImageScanResultItemBO> resultItemList = new ArrayList<DycProContentReviewImageScanResultItemBO>();
                ArrayList<String> contextList = new ArrayList<String>();
                DycProContentReviewImageScanResultItemBO resultItem = new DycProContentReviewImageScanResultItemBO();
                String originalUrl = null;
                originalUrl = result.getDataId() != null && originalUrlMap.containsKey(result.getDataId()) ? (String)originalUrlMap.get(result.getDataId()) : result.getImageURL();
                resultItem.setImageURL(originalUrl);
                ArrayList<DycProContentReviewImageScanSubResultBO> subResults = new ArrayList<DycProContentReviewImageScanSubResultBO>();
                if (result.getSubResults() != null) {
                    for (ScanImageResponseBody.ScanImageResponseBodyDataResultsSubResults subResult : result.getSubResults()) {
                        List programCodeDataList;
                        DycProContentReviewImageScanSubResultBO subResultBO = new DycProContentReviewImageScanSubResultBO();
                        subResultBO.setRate(subResult.getRate());
                        subResultBO.setSuggestion(subResult.getSuggestion());
                        subResultBO.setLabel(subResult.getLabel());
                        subResultBO.setScene(subResult.getScene());
                        String labelKey = subResult.getScene() + "_" + subResult.getLabel();
                        String labelStr = "";
                        try {
                            DmcAliyunImageScanLableEnum labelEnum = DmcAliyunImageScanLableEnum.valueOf(labelKey);
                            labelStr = labelEnum.getValue();
                        }
                        catch (IllegalArgumentException e) {
                            labelStr = subResult.getLabel();
                        }
                        subResultBO.setLabelStr(labelStr);
                        if (subResult.getHintWordsInfoList() != null) {
                            List hintWordsInfoLists = subResult.getHintWordsInfoList().stream().map(ScanImageResponseBody.ScanImageResponseBodyDataResultsSubResultsHintWordsInfoList::getContext).collect(Collectors.toList());
                            contextList.addAll(hintWordsInfoLists);
                        }
                        if (subResult.getSfaceDataList() != null) {
                            ArrayList facess = new ArrayList();
                            List sfaceDataList = subResult.getSfaceDataList().stream().map(sface -> {
                                DycProContentReviewImageScanSfaceDataBO sfaceBO = new DycProContentReviewImageScanSfaceDataBO();
                                sfaceBO.setHeight(sface.getHeight());
                                sfaceBO.setWidth(sface.getWidth());
                                sfaceBO.setX(sface.getX());
                                sfaceBO.setY(sface.getY());
                                if (sface.getFaces() != null) {
                                    List<DycProContentReviewImageScanFaceBO> faces = sface.getFaces().stream().map(face -> {
                                        DycProContentReviewImageScanFaceBO faceBO = new DycProContentReviewImageScanFaceBO();
                                        faceBO.setId(face.getId());
                                        faceBO.setName(face.getName());
                                        faceBO.setRate(face.getRate());
                                        facess.add(face.getName());
                                        return faceBO;
                                    }).collect(Collectors.toList());
                                    sfaceBO.setFaces(faces);
                                }
                                return sfaceBO;
                            }).collect(Collectors.toList());
                            contextList.add("\u68c0\u6d4b\u5230\u4eba\u8138\uff1a" + facess);
                        }
                        if (subResult.getProgramCodeDataList() != null) {
                            programCodeDataList = subResult.getProgramCodeDataList().stream().map(programCode -> {
                                DycProContentReviewImageScanProgramCodeDataBO programCodeBO = new DycProContentReviewImageScanProgramCodeDataBO();
                                programCodeBO.setHeight(programCode.getHeight());
                                programCodeBO.setWidth(programCode.getWidth());
                                programCodeBO.setX(programCode.getX());
                                programCodeBO.setY(programCode.getY());
                                return programCodeBO;
                            }).collect(Collectors.toList());
                            contextList.add("\u68c0\u6d4b\u5230\u4e8c\u7ef4\u7801");
                        }
                        if (subResult.getFrames() != null) {
                            programCodeDataList = subResult.getFrames().stream().map(frame -> {
                                DycProContentReviewImageScanFrameBO frameBO = new DycProContentReviewImageScanFrameBO();
                                frameBO.setRate(frame.getRate());
                                frameBO.setUrl(frame.getURL());
                                return frameBO;
                            }).collect(Collectors.toList());
                        }
                        if (subResult.getLogoDataList() != null) {
                            ArrayList logos = new ArrayList();
                            List logoDataList = subResult.getLogoDataList().stream().map(logo -> {
                                DycProContentReviewImageScanLogoDataBO logoBO = new DycProContentReviewImageScanLogoDataBO();
                                logoBO.setName(logo.getName());
                                logoBO.setType(logo.getType());
                                logoBO.setX(logo.getX());
                                logoBO.setY(logo.getY());
                                logoBO.setWidth(logo.getWidth());
                                logoBO.setHeight(logo.getHeight());
                                logos.add(logo.getName());
                                return logoBO;
                            }).collect(Collectors.toList());
                            contextList.add("\u68c0\u6d4b\u5230Logo\uff1a" + logos);
                        }
                        subResults.add(subResultBO);
                    }
                    resultItem.setContext(contextList);
                    resultItem.setResultItems(subResults);
                    resultItemList.add(resultItem);
                }
                resultItems.addAll(resultItemList);
            }
        }
        resultBO.setData(resultItems);
        return resultBO;
    }

    private void imageScanParamVerify(DycProContentReviewImageScanReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getTask())) {
            throw new ZTBusinessException("\u68c0\u6d4b\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getScene())) {
            throw new ZTBusinessException("\u68c0\u6d4b\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private ScanImageRequest getScanImageRequest(DycProContentReviewImageScanReqBO reqBO) {
        ScanImageRequest scanImageRequestRequest = new ScanImageRequest();
        scanImageRequestRequest.setScene(reqBO.getScene());
        if (reqBO.getTask() != null && !reqBO.getTask().isEmpty()) {
            ArrayList<ScanImageRequest.ScanImageRequestTask> taskList = new ArrayList<ScanImageRequest.ScanImageRequestTask>();
            for (DycProContentReviewImageScanTaskBO taskBO : reqBO.getTask()) {
                ScanImageRequest.ScanImageRequestTask task = new ScanImageRequest.ScanImageRequestTask().setImageURL(taskBO.getImageURL()).setDataId(taskBO.getDataId());
                if (taskBO.getImageTimeMillisecond() != null) {
                    task.setImageTimeMillisecond(taskBO.getImageTimeMillisecond());
                }
                if (taskBO.getInterval() != null) {
                    task.setInterval(taskBO.getInterval());
                }
                if (taskBO.getMaxFrames() != null) {
                    task.setMaxFrames(taskBO.getMaxFrames());
                }
                taskList.add(task);
            }
            scanImageRequestRequest.setTask(taskList);
        }
        return scanImageRequestRequest;
    }

    private ScanImageAdvanceRequest getImageAdvanceRequest(DycProContentReviewImageScanReqBO reqBO) {
        ScanImageAdvanceRequest scanImageAdvanceRequest = new ScanImageAdvanceRequest();
        scanImageAdvanceRequest.setScene(reqBO.getScene());
        if (reqBO.getTask() != null && !reqBO.getTask().isEmpty()) {
            ArrayList<ScanImageAdvanceRequest.ScanImageAdvanceRequestTask> taskList = new ArrayList<ScanImageAdvanceRequest.ScanImageAdvanceRequestTask>();
            for (DycProContentReviewImageScanTaskBO taskBO : reqBO.getTask()) {
                InputStream inputStream1 = null;
                try {
                    if (this.isInternalUrl(taskBO.getImageURL())) {
                        String filePath = taskBO.getImageURL();
                        if (filePath.startsWith("/")) {
                            filePath = filePath.substring(1);
                        }
                        inputStream1 = this.fileClient.downLoadToInputStream(filePath);
                    } else {
                        URL url = new URL(taskBO.getImageURL());
                        inputStream1 = url.openConnection().getInputStream();
                    }
                }
                catch (Exception e) {
                    if (inputStream1 != null) {
                        try {
                            inputStream1.close();
                        }
                        catch (Exception closeException) {
                            log.warn("\u5173\u95ed\u8f93\u5165\u6d41\u5931\u8d25", (Throwable)closeException);
                        }
                    }
                    throw new ZTBusinessException("url\u94fe\u63a5\u4e0d\u53ef\u7528");
                }
                ScanImageAdvanceRequest.ScanImageAdvanceRequestTask task = new ScanImageAdvanceRequest.ScanImageAdvanceRequestTask().setImageURLObject(inputStream1).setDataId(taskBO.getDataId());
                if (taskBO.getImageTimeMillisecond() != null) {
                    task.setImageTimeMillisecond(taskBO.getImageTimeMillisecond());
                }
                if (taskBO.getInterval() != null) {
                    task.setInterval(taskBO.getInterval());
                }
                if (taskBO.getMaxFrames() != null) {
                    task.setMaxFrames(taskBO.getMaxFrames());
                }
                taskList.add(task);
            }
            scanImageAdvanceRequest.setTask(taskList);
        }
        return scanImageAdvanceRequest;
    }

    private boolean isInternalUrl(String urlString) {
        return !urlString.contains("http");
    }
}

