package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：DycProEsIndexMappingSaleOrderBO
 * 描述：销售单索引映射
 */
@Data
public class DycProEsIndexMappingSaleOrderBO implements Serializable {

    private static final long serialVersionUID = -2277392920345676679L;

    /**
     * 销售单id
     */
    private Long saleOrderId;
    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 销售单编码
     */
    private String saleOrderNo;
    /**
     * 外部销售单编码
     */
    private String saleOrderNoExt;
    /**
     * 销售金额
     */
    private BigDecimal totalSaleFee;
    /**
     * 采购金额
     */
    private BigDecimal totalPurchaseFee;
    /**
     * 订单来源，1自营单品，2电商导入，3协议生成
     */
    private Integer orderSource;
    /**
     * 订单状态
     */
    private String saleOrderState;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建工号
     */
    private String createOperId;
    /**
     * 创建人名称
     */
    private String createOperName;
    /**
     * 评价状态
     */
    private Integer evaluateState;
    /**
     * 订单阶段， 0进行中，1交易成功，2交易关闭
     */
    private Integer orderStage;
    /**
     * 平台协议编号
     */
    private String plaAgreementCode;
    /**
     * 协议名称
     */
    private String agreementName;
    /**
     * 业务任务id
     */
    private String busiTaskInstId;
    /**
     * 业务流程实例id
     */
    private String busiProcInstId;
    /**
     * 结算模式 2:撮合 1:贸易
     */
    private Integer modelSettle;
    /**
     * 撤单原因
     */
    private String cancelReason;
    /**
     * 取消原因标识，0用户主动取消，1审批时限自动取消，2审批驳回取消
     */
    private Integer cancelReasonFlag;
    /**
     * 取消申请单id
     */
    private Long cancelApplyId;
    /**
     * 发货单信息
     */
    private List<DycProEsIndexMappingSaleShipOrderBO> shipOrderList;
    /**
     * 验收单信息
     */
    private List<DycProEsIndexMappingSaleInspOrderBO> inspOrderList;
    /**
     * 售后单信息
     */
    private List<DycProEsIndexMappingSaleAfOrderBO> afOrderList;
    /**
     * 异常变更单信息
     */
    private List<DycProEsIndexMappingSaleChngOrderBO> chngOrderList;
    /**
     * 销售单三方信息
     */
    private DycProEsIndexMappingSaleStakeholderBO saleStakeholder;
    /**
     * 订单收货信息
     */
    private DycProEsIndexMappingOrderLogisticsRelationBO deliveryAddress;
    /**
     * 销售单明细
     */
    private List<DycProEsIndexMappingSaleOrderItemBO> saleItemList;
    /**
     * 审批流程key
     */
    private String auditProcessKey;
    /**
     * 预算id
     */
    private Long budgetId;
    /**
     * 预算名称
     */
    private String budgetName;
    /**
     * 采购需求编号
     */
    private String purchaseNeedNo;
}
