package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 标题：DycProEsIndexMappingAfOrderItemBO
 * 描述：售后单明细索引映射
 */
@Data
public class DycProEsIndexMappingAfOrderItemBO implements Serializable {

    private static final long serialVersionUID = -6459509516706550720L;

    /**
     * 服务明细id
     */
    private Long afOrderItemId;

    /**
     * 验收明细id
     */
    private Long inspItemId;

    /**
     * 发货明细id
     */
    private Long shipItemId;

    /**
     * 销售单明细id
     */
    private Long saleOrderItemId;

    /**
     * 单品id
     */
    private Long skuId;

    /**
     * 计量单位
     */
    private String unitName;

    /**
     * 计量单位位数
     */
    private String unitDigit;

    /**
     * 采购数量
     */
    private BigDecimal purchaseCount;

    /**
     * 售后服务量
     */
    private BigDecimal returnCount;

    /**
     * 销售退款金额
     */
    private BigDecimal retSaleFee;

    /**
     * 采购退款金额
     */
    private BigDecimal retPurchaseFee;

    /**
     * 问题描述
     */
    private String questionDesc;

    /**
     * 单品编码
     */
    private String skuCode;

    /**
     * 单品名称
     */
    private String skuName;

    /**
     * 税率
     */
    private BigDecimal tax;

    /**
     * 销售金额
     */
    private BigDecimal salePrice;

    /**
     * 采购金额
     */
    private BigDecimal purchasePrice;

    /**
     * sku单品主图url
     */
    private String skuMainPicUrl;

    /**
     * sku物料编码
     */
    private String skuMaterialCode;

    /**
     * sku外部单品id
     */
    private String skuExtSkuId;

    /**
     * sku物料名称
     */
    private String skuMaterialName;

    /**
     * sku物料类型名称
     */
    private String skuMaterialTypeName;

}
