package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @author luoyou
 * @description 商品审批状态
 * @date 2025/04/24
 **/

public enum DmcCommSkuInfoApprovalStatus implements DictionaryEnum {

    // 待上架
    TOBE_ON_SHELVE_REJECT("DMC_COMM_SKU_INFO_APPROVAL_STATUS", "12", "上架审批驳回", "商品审批状态"),
    TOBE_ON_SHELVE_TODO("DMC_COMM_SKU_INFO_APPROVAL_STATUS", "11", "上架审批中", "商品审批状态"),

    // 已上架
    ON_SHELVE_REJECT("DMC_COMM_SKU_INFO_APPROVAL_STATUS", "22", "下架审批驳回", "商品审批状态"),
    ON_SHELVE_TODO("DMC_COMM_SKU_INFO_APPROVAL_STATUS", "21", "下架审批中", "商品审批状态"),

    // 编辑
    EDIT_REJECT("DMC_COMM_SKU_INFO_APPROVAL_STATUS", "26", "编辑审批驳回", "商品审批状态"),
    EDIT_TODO("DMC_COMM_SKU_INFO_APPROVAL_STATUS", "25", "编辑审批中", "商品审批状态"),
    ;
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommSkuInfoApprovalStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
