package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author yuhao
 * @Date 2025/6/12 15:19
 * @Description:spu es index 映射对象
 **/
@Data
public class DycProExIndexMappingSpuBO implements Serializable {
    private static final long serialVersionUID = 5014943199715535464L;
    /**
     * spu id
     */
    private Long spuId;
    /**
     * spu编码
     */
    private String spuCode;
    /**
     * SPU名称
     */
    private String spuName;

    /**
     * spu来源 spu来源:  2:电商sku 3:协议sku
     */
    private Integer spuSource;

    /**
     * spu状态 spu状态 0：草稿 1：非草稿
     */
    private Integer spuStatus;
    /**
     * 属性模版id
     */
    private Long propertyTemplateId;
    /**
     * 外部spu id
     */
    private String extSpuId;
    /**
     * 品牌id
     */
    private Long brandId;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 所属协议明细id
     */
    private Long agrItemId;
    /**
     * 所属协议id
     */
    private Long agrId;
    /**
     * 协议编号
     */
    private String agrCode;
    /**
     * 协议名称
     */
    private String agrName;
    /**
     * 企业协议编号
     */
    private String enAgrCode;
    /**
     * 税率
     */
    private BigDecimal rate;
    /**
     * 供应商id
     */
    private Long supplierId;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 创建人id
     */
    private String createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 创建人机构id
     */
    private Long createOrgId;
    /**
     * 创建人机构名称
     */
    private String createOrgName;
    /**
     * 创建人机构路径
     */
    private String createOrgPath;
    /**
     * 创建人公司id
     */
    private Long createCompanyId;
    /**
     * 创建人公司名称
     */
    private String createCompanyName;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新人id
     */
    private Long updateUserId;
    /**
     * 更新人名称
     */
    private String updateUserName;
    /**
     * 更新人机构id
     */
    private Long updateOrgId;
    /**
     * 更新人机构名称
     */
    private String updateOrgName;
    /**
     * 更新人机构路径
     */
    private String updateOrgPath;
    /**
     * 更新人公司id
     */
    private Long updateCompanyId;
    /**
     * 更新人公司名称
     */
    private String updateCompanyName;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 删除标识 1已删除 0未删除
     */
    private Integer delFlag;
}
