package com.tydic.dyc.pro.base.core.contentreview.impl;

import com.aliyun.imageaudit20191230.Client;
import com.aliyun.imageaudit20191230.models.ScanImageAdvanceRequest;
import com.aliyun.imageaudit20191230.models.ScanImageRequest;
import com.aliyun.imageaudit20191230.models.ScanImageResponse;
import com.aliyun.imageaudit20191230.models.ScanImageResponseBody;
import com.aliyun.imageaudit20191230.models.ScanImageResponseBody.ScanImageResponseBodyDataResultsSubResultsHintWordsInfoList;
import com.aliyun.teautil.models.RuntimeOptions;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.pro.base.core.contentreview.api.DycProContentReviewAliyunImageScanService;
import com.tydic.dyc.pro.base.core.contentreview.bo.*;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAliyunImageScanLableEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.io.InputStream;
import java.net.URL;
import java.util.*;
import java.util.stream.Collectors;
/**
 * @Author HeDengHui
 * @Date 2025/5/30 12.51
 * @Description:图片审核接口实现
 **/
@Service
@Slf4j
public class DycProContentReviewAliyunImageScanServiceImpl implements DycProContentReviewAliyunImageScanService {
    @Autowired
    private Client aliyunClient;
    @Autowired
    private FileClient fileClient;
    @Override
    public DycProContentReviewImageScanRspBO imageScan(DycProContentReviewImageScanReqBO reqBO) {
        // 参数校验
        this.imageScanParamVerify(reqBO);
        // 图片内容审核返回对象
        ScanImageResponse scanImageResponse;
        RuntimeOptions runtime = new RuntimeOptions();
        // 保存原始URL到Map中
        Map<String, String> originalUrlMap = new HashMap<>();
        for (DycProContentReviewImageScanTaskBO taskBO : reqBO.getTask()) {
            taskBO.setDataId(UUID.randomUUID().toString());
            originalUrlMap.put(taskBO.getDataId(), taskBO.getImageURL());
        }
        try {
            Date start = new Date();
            // 判断是oss还是外网本地访问
            if (reqBO.getTask().get(0).getImageURL().contains("oss")) {
                // OSS路径，使用标准请求
                ScanImageRequest scanImageRequest = this.getScanImageRequest(reqBO);
                scanImageResponse = this.aliyunClient.scanImageWithOptions(scanImageRequest, runtime);
            } else {
                // 外网/本地路径，使用高级请求
                ScanImageAdvanceRequest scanImageAdvanceRequest = this.getImageAdvanceRequest(reqBO);
                scanImageResponse = this.aliyunClient.scanImageAdvance(scanImageAdvanceRequest, runtime);
            }
            Date end = new Date();
            log.info("图片检测总耗时：" + (end.getTime() - start.getTime()) + "ms");
        } catch (Exception e) {
            log.error("阿里云API调用图片监测失败：" + e.getMessage());
            throw new ZTBusinessException("阿里云API调用图片监测失败" + e.getMessage());
        }
        // 处理返回对象ResponseBO
        if (scanImageResponse == null || scanImageResponse.getBody() == null || scanImageResponse.statusCode != 200) {
            return null;
        }

        ScanImageResponseBody responseBody = scanImageResponse.getBody();
        // 创建结果BO对象
        DycProContentReviewImageScanRspBO resultBO = new DycProContentReviewImageScanRspBO();
        resultBO.setRequestId(responseBody.getRequestId());
        // 处理Data部分
        List<DycProContentReviewImageScanResultItemBO> resultItems = new ArrayList<>();
        if (responseBody.getData().getResults() != null) {
            for (ScanImageResponseBody.ScanImageResponseBodyDataResults result : responseBody.getData().getResults()) {
                List<DycProContentReviewImageScanResultItemBO> resultItemList = new ArrayList<>();
                List<String> contextList = new ArrayList<>();
                DycProContentReviewImageScanResultItemBO resultItem = new DycProContentReviewImageScanResultItemBO();
                // 设置图像地址获取原始URL
                String originalUrl = null;
                if (result.getDataId() != null && originalUrlMap.containsKey(result.getDataId())) {
                    originalUrl = originalUrlMap.get(result.getDataId());
                } else {
                    // 如果找不到原始URL，就使用阿里云返回的URL
                    originalUrl = result.getImageURL();
                }
                resultItem.setImageURL(originalUrl);
                List<DycProContentReviewImageScanSubResultBO> subResults = new ArrayList<>();
                if (result.getSubResults() != null) {
                    for (ScanImageResponseBody.ScanImageResponseBodyDataResultsSubResults subResult : result.getSubResults()) {
                        DycProContentReviewImageScanSubResultBO subResultBO = new DycProContentReviewImageScanSubResultBO();
                        subResultBO.setRate(subResult.getRate());
                        subResultBO.setSuggestion(subResult.getSuggestion());
                        subResultBO.setLabel(subResult.getLabel());
                        subResultBO.setScene(subResult.getScene());
                        // 枚举处理
                        String labelKey = subResult.getScene() + "_" + subResult.getLabel();
                        String labelStr = "";
                        try {
                            DmcAliyunImageScanLableEnum labelEnum = DmcAliyunImageScanLableEnum.valueOf(labelKey);
                            labelStr = labelEnum.getValue();
                        } catch (IllegalArgumentException e) {
                            // 防止非法不存在的错误
                            labelStr = subResult.getLabel();
                        }

                        subResultBO.setLabelStr(labelStr);
                        // 处理OCR数据列表
//                        if (subResult.getOCRDataList() != null) {
//                            contextList.addAll(subResult.getOCRDataList());
//                        }
                        // 处理广告关键词信息
                        if (subResult.getHintWordsInfoList() != null) {
                            List<String> hintWordsInfoLists = subResult.getHintWordsInfoList().stream()
                                    .map(ScanImageResponseBodyDataResultsSubResultsHintWordsInfoList::getContext)
                                    .collect(Collectors.toList());
                            contextList.addAll(hintWordsInfoLists);
                        }
                        // 处理人脸数据
                        if (subResult.getSfaceDataList() != null) {
                            List<String> facess = new ArrayList<>();
                            List<DycProContentReviewImageScanSfaceDataBO> sfaceDataList = subResult.getSfaceDataList().stream()
                                    .map(sface -> {
                                        DycProContentReviewImageScanSfaceDataBO sfaceBO = new DycProContentReviewImageScanSfaceDataBO();
                                        sfaceBO.setHeight(sface.getHeight());
                                        sfaceBO.setWidth(sface.getWidth());
                                        sfaceBO.setX(sface.getX());
                                        sfaceBO.setY(sface.getY());
                                        // 处理人脸信息
                                        if (sface.getFaces() != null) {
                                            List<DycProContentReviewImageScanFaceBO> faces = sface.getFaces().stream()
                                                    .map(face -> {
                                                        DycProContentReviewImageScanFaceBO faceBO = new DycProContentReviewImageScanFaceBO();
                                                        faceBO.setId(face.getId());
                                                        faceBO.setName(face.getName());
                                                        faceBO.setRate(face.getRate());
                                                        facess.add(face.getName());
                                                        return faceBO;
                                                    })
                                                    .collect(Collectors.toList());
                                            sfaceBO.setFaces(faces);
                                        }
                                        return sfaceBO;
                                    })
                                    .collect(Collectors.toList());
                            contextList.add("检测到人脸：" + facess);
//                            resultItem.setSfaceDataList(sfaceDataList);
                        }
                        // 处理小程序码数据
                        if (subResult.getProgramCodeDataList() != null) {
                            List<DycProContentReviewImageScanProgramCodeDataBO> programCodeDataList = subResult.getProgramCodeDataList().stream()
                                    .map(programCode -> {
                                        DycProContentReviewImageScanProgramCodeDataBO programCodeBO = new DycProContentReviewImageScanProgramCodeDataBO();
                                        programCodeBO.setHeight(programCode.getHeight());
                                        programCodeBO.setWidth(programCode.getWidth());
                                        programCodeBO.setX(programCode.getX());
                                        programCodeBO.setY(programCode.getY());
                                        return programCodeBO;
                                    })
                                    .collect(Collectors.toList());
                            contextList.add("检测到二维码");
//                            resultItem.setProgramCodeDataList(programCodeDataList);
                        }
                        // 处理帧数据
                        if (subResult.getFrames() != null) {
                            List<DycProContentReviewImageScanFrameBO> frames = subResult.getFrames().stream()
                                    .map(frame -> {
                                        DycProContentReviewImageScanFrameBO frameBO = new DycProContentReviewImageScanFrameBO();

                                        frameBO.setRate(frame.getRate());
                                        frameBO.setUrl(frame.getURL());
                                        return frameBO;
                                    })
                                    .collect(Collectors.toList());
//                            resultItem.setFrames(frames);
                        }
                        // 处理Logo数据
                        if (subResult.getLogoDataList() != null) {
                            List<String> logos = new ArrayList<>();
                            List<DycProContentReviewImageScanLogoDataBO> logoDataList = subResult.getLogoDataList().stream()
                                    .map(logo -> {
                                        DycProContentReviewImageScanLogoDataBO logoBO = new DycProContentReviewImageScanLogoDataBO();
                                        logoBO.setName(logo.getName());
                                        logoBO.setType(logo.getType());
                                        logoBO.setX(logo.getX());
                                        logoBO.setY(logo.getY());
                                        logoBO.setWidth(logo.getWidth());
                                        logoBO.setHeight(logo.getHeight());
                                        logos.add(logo.getName());
                                        return logoBO;
                                    })
                                    .collect(Collectors.toList());
                            contextList.add("检测到Logo：" + logos);
//                            resultItem.setLogoDataList(logoDataList);
                        }
                        subResults.add(subResultBO);

                    }
                    resultItem.setContext(contextList);
                    resultItem.setResultItems(subResults);
                    resultItemList.add(resultItem);
                }

                resultItems.addAll(resultItemList);
            }
        }
        resultBO.setData(resultItems);


        return resultBO;
    }

    private void imageScanParamVerify(DycProContentReviewImageScanReqBO reqBO){
        if (reqBO == null) {
            throw new ZTBusinessException("请求对象不能为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getTask())){
            throw new ZTBusinessException("检测任务不能为空");
        }
        if(CollectionUtils.isEmpty(reqBO.getScene())){
            throw new ZTBusinessException("检测场景不能为空");
        }
    }

    /**
     * 将ContentReviewImageScanRequestBO转换为ScanImageRequest
     *
     * @param reqBO 内容审核请求BO对象
     * @return 阿里云图片内容审核请求对象
     */
    private ScanImageRequest getScanImageRequest(DycProContentReviewImageScanReqBO reqBO) {
        // 创建ScanImageRequest对象
        ScanImageRequest scanImageRequestRequest = new ScanImageRequest();
        // 设置检测场景
        scanImageRequestRequest.setScene(reqBO.getScene());
        // 转换任务列表
        if (reqBO.getTask() != null && !reqBO.getTask().isEmpty()) {
            List<ScanImageRequest.ScanImageRequestTask> taskList = new ArrayList<>();
            for (DycProContentReviewImageScanTaskBO taskBO : reqBO.getTask()) {
                ScanImageRequest.ScanImageRequestTask task = new ScanImageRequest.ScanImageRequestTask()
                        .setImageURL(taskBO.getImageURL())
                        .setDataId(taskBO.getDataId());
                // 设置可选参数
                if (taskBO.getImageTimeMillisecond() != null) {
                    task.setImageTimeMillisecond(taskBO.getImageTimeMillisecond());
                }
                if (taskBO.getInterval() != null) {
                    task.setInterval(taskBO.getInterval());
                }
                if (taskBO.getMaxFrames() != null) {
                    task.setMaxFrames(taskBO.getMaxFrames());
                }
                taskList.add(task);
            }
            scanImageRequestRequest.setTask(taskList);
        }
        return scanImageRequestRequest;
    }

    /**
     * 外网本地访问请求数据
     *
     * @param reqBO
     * @return
     */
    private  ScanImageAdvanceRequest getImageAdvanceRequest(DycProContentReviewImageScanReqBO reqBO) {
        // 创建ScanImageRequest对象
        ScanImageAdvanceRequest scanImageAdvanceRequest = new ScanImageAdvanceRequest();
        // 设置检测场景
        scanImageAdvanceRequest.setScene(reqBO.getScene());
        // 转换任务列表
        if (reqBO.getTask() != null && !reqBO.getTask().isEmpty()) {
            List<ScanImageAdvanceRequest.ScanImageAdvanceRequestTask> taskList = new ArrayList<>();

            for (DycProContentReviewImageScanTaskBO taskBO : reqBO.getTask()) {
                // 防止资源泄漏
                InputStream inputStream1 = null;
                try {
                    // 判断是本地文件还是任意可访问的url
                    if(isInternalUrl(taskBO.getImageURL()))
                    {
                        // 使用本地文件
                        String filePath = taskBO.getImageURL();
                        // 去掉开头的/
                        if (filePath.startsWith("/")) {
                            filePath = filePath.substring(1);
                        }
                        inputStream1 = fileClient.downLoadToInputStream(filePath);
                    }
                    else{
                        // 可访问的URL文件
                        URL url = new URL(taskBO.getImageURL());
                        inputStream1 = url.openConnection().getInputStream();
                    }

                } catch (Exception e) {
                    // 确保在异常情况下也要关闭资源
                    if (inputStream1 != null) {
                        try {
                            inputStream1.close();
                        } catch (Exception closeException) {
                            log.warn("关闭输入流失败", closeException);
                        }
                    }
                    throw new ZTBusinessException("url链接不可用");
                }
                ScanImageAdvanceRequest.ScanImageAdvanceRequestTask task = new ScanImageAdvanceRequest.ScanImageAdvanceRequestTask()
                        .setImageURLObject(inputStream1)
                        .setDataId(taskBO.getDataId());
                // 可选参数设置
                if (taskBO.getImageTimeMillisecond() != null) {
                    task.setImageTimeMillisecond(taskBO.getImageTimeMillisecond());
                }

                if (taskBO.getInterval() != null) {
                    task.setInterval(taskBO.getInterval());
                }

                if (taskBO.getMaxFrames() != null) {
                    task.setMaxFrames(taskBO.getMaxFrames());
                }

                taskList.add(task);
            }

            scanImageAdvanceRequest.setTask(taskList);
        }

        return scanImageAdvanceRequest;
    }
    private boolean isInternalUrl(String urlString) {
        // 相对路径或不包含协议的路径
        if (!urlString.contains("http")) {
            return true;
        }
        return false;
    }
}
