package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * sku es可见适用范围前缀 枚举
 *
 * @author lihulin
 */

public enum DmcCommSkuEsScopeType implements DictionaryEnum {
    ALL("DMC_COMM_SKU_ES_SCOPE_TYPE", "ALL_*", "全量", "sku es适用范围前缀"),
    COMPANY_PATH("DMC_COMM_SKU_ES_SCOPE_TYPE", "COMPANY_PATH_", "公司树路径", "sku es适用范围前缀"),
    COMPANY_ID("DMC_COMM_SKU_ES_SCOPE_TYPE", "COMPANY_ID_", "公司id", "sku es适用范围前缀");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommSkuEsScopeType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
