package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：DmcSscConsultQuoteStatus
 * 描述：协商单报价单状态
 */
public enum DmcSscConsultQuoteStatus implements DictionaryEnum {

    QUOTE ("DMC_SSC_CONSULT_QUOTE_STATUS", "1", "已报价", "协商单报价单状态"),
    REVOKE ("DMC_SSC_CONSULT_QUOTE_STATUS", "2", "已撤回", "协商单报价单状态");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcSscConsultQuoteStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
