package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：DmcSscSupplyApplyInfoStatus
 * 描述：竞价单状态
 */
public enum DmcSscConsultStatusJJ implements DictionaryEnum {

    DRAFT ("DMC_SSC_CONSULT_STATUS_JJ", "0", "草稿", "竞价单状态"),
    UNDER_APPROVAL ("DMC_SSC_CONSULT_STATUS_JJ", "1", "审批中", "竞价单状态"),
    APPROVAL_REJECTED("DMC_SSC_CONSULT_STATUS_JJ", "2", "审批驳回", "竞价单状态"),
    TO_BE_PUBLISHED("DMC_SSC_CONSULT_STATUS_JJ", "3", "待发布", "竞价单状态"),
    NOT_STARTED("DMC_SSC_CONSULT_STATUS_JJ", "4", "未开始", "竞价单状态"),
    QUOTING("DMC_SSC_CONSULT_STATUS_JJ", "5", "竞价中", "竞价单状态"),
    AWAITING_RESULT_CONFIRMATION("DMC_SSC_CONSULT_STATUS_JJ", "6", "结果待确认", "竞价单状态"),
    QUOTATION_APPROVAL_PROCESSING("DMC_SSC_CONSULT_STATUS_JJ", "7", "竞价结果审批中", "竞价单状态"),
    QUOTATION_APPROVAL_REJECTED("DMC_SSC_CONSULT_STATUS_JJ", "9", "竞价结果审批驳回", "竞价单状态"),
    RESULT_PENDING_PUBLICATION("DMC_SSC_CONSULT_STATUS_JJ", "10", "结果待发布", "竞价单状态"),
    COMPLETED("DMC_SSC_CONSULT_STATUS_JJ", "11", "已完成", "竞价单状态"),
    QUOTATION_TERMINATED("DMC_SSC_CONSULT_STATUS_JJ", "12", "竞价终止", "竞价单状态"),
    FAIL("DMC_SSC_CONSULT_STATUS_JJ", "13", "寻源失败", "竞价单状态"),
    QUOTATION_DEADLINE("DMC_SSC_CONSULT_STATUS_JJ", "8", "报价截止", "竞价单状态"),
    BE_SELECTED("DMC_SSC_CONSULT_STATUS_JJ", "100", "已中标", "竞价单状态"),
    NOT_BE_SELECTED("DMC_SSC_CONSULT_STATUS_JJ", "101", "未中标", "竞价单状态");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcSscConsultStatusJJ(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
