package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：EgcAfOrderAfsReason
 * 描述：售后原因
 */
public enum EgcAfOrderAfsReason implements DictionaryEnum {

    AFS_REASON_2506("AFS_REASON", "2506", "大小/尺寸与商品描述不符合", "售后原因"),
    AFS_REASON_2507("AFS_REASON", "2507", "颜色/图案/款式与商品描述不符", "售后原因"),
    AFS_REASON_2508("AFS_REASON", "2508", "生产日期/保质期与商品描述不符", "售后原因"),
    AFS_REASON_2509("AFS_REASON", "2509", "材质面料与商品描述不符", "售后原因"),
    AFS_REASON_2510("AFS_REASON", "2510", "做工粗糙/有瑕疵", "售后原因"),
    AFS_REASON_2511("AFS_REASON", "2511", "少件/漏发", "售后原因"),
    AFS_REASON_2512("AFS_REASON", "2512", "已近/临近保质期", "售后原因"),
    AFS_REASON_2513("AFS_REASON", "2513", "商品质量问题", "售后原因"),
    AFS_REASON_2514("AFS_REASON", "2514", "包装/商品破损/污渍/变形", "售后原因"),
    AFS_REASON_2515("AFS_REASON", "2515", "假冒品牌", "售后原因"),
    AFS_REASON_2516("AFS_REASON", "2516", "卖家发错货", "售后原因"),
    AFS_REASON_2517("AFS_REASON", "2517", "未按约定时间发货", "售后原因");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    EgcAfOrderAfsReason(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
