package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 供应商考核评分数据状态 枚举
 */
public enum GjSupRatingScoreDataStatus implements DictionaryEnum {
    /** 待评分 */
    PENDING("RATING_SCORE_DATA_STATUS", "1", "待评分", "供应商考核评分数据状态"),
    /** 已评分 */
    ALREADY("RATING_SCORE_DATA_STATUS", "2", "已评分", "供应商考核评分数据状态");

    /** 编码 */
    private final String dictionaryCode;
    /** 编码 */
    private final String code;
    /** 编码值 */
    private final String value;
    /** 名称 */
    private final String dictionaryName;

    GjSupRatingScoreDataStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}


