package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题：DycProEsIndexMappingSaleShipOrderBO
 * 描述：销售单索引发货单信息
 */
@Data
public class DycProEsIndexMappingSaleAfOrderBO implements Serializable {

    private static final long serialVersionUID = -4906412368224353537L;
    /**
     * 售后服务单id
     */
    private Long afOrderId;
    /**
     * 售后服务单编码
     */
    private String afServCode;
    /**
     * 外部售后服务单号
     */
    private String extAfId;
    /**
     * 服务类型 退货(10)、换货(20)、维修(30)
     */
    private Integer servType;
    /**
     * 取货服务类型 4： 上门取件 40：客户发货 7： 客户送货
     */
    private Integer pickwareType;
    /**
     * 服务单状态 100提交申请 200 审核中 201审核不通过 300收货完成 400退款成功 401退款失败 500 已完成 600 取消
     */
    private Integer servState;
    /**
     * 创建时间
     */
    private Date createTime;

}
