package com.tydic.dyc.pro.base.core.dictionary.enums;
/**
 * @description 订单阶段枚举值
 * @author Luokan
 * @date 2025/04/16
 **/
public enum EgcSaleOrderOrderStage implements DictionaryEnum{
    /**
     * 进行中
     */
    DEAL("ORDER_STAGE","0","进行中", "订单阶段"),
    /**
     * 交易成功
     */
    FINISH("ORDER_STAGE","1","交易成功", "订单阶段"),
    /**
     * 交易关闭
     */
    CLOSE("ORDER_STAGE","2","交易关闭", "订单阶段");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    EgcSaleOrderOrderStage(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }
    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
