package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 供应商考核周期 枚举
 */
public enum GjSupRatingRulePeriodValue implements DictionaryEnum {
    /** 月度 */
    MONTH("RATING_RULE_PERIOD_VALUE", "1", "月度", "供应商考核周期"),
    /** 季度 */
    QUARTER("RATING_RULE_PERIOD_VALUE", "2", "季度", "供应商考核周期"),
    /** 年度 */
    YEAR("RATING_RULE_PERIOD_VALUE", "3", "年度", "供应商考核周期");

    /** 编码 */
    private final String dictionaryCode;
    /** 编码 */
    private final String code;
    /** 编码值 */
    private final String value;
    /** 名称 */
    private final String dictionaryName;

    GjSupRatingRulePeriodValue(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}


