package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 供应商考核规则状态 枚举
 */
public enum GjSupRatingRuleStatus implements DictionaryEnum {
    /** 停用 */
    DISABLE("RATING_RULE_STATUS", "0", "已停用", "供应商考核规则状态"),
    /** 启用 */
    ENABLE("RATING_RULE_STATUS", "1", "已启用", "供应商考核规则状态");

    /** 编码 */
    private final String dictionaryCode;
    /** 编码 */
    private final String code;
    /** 编码值 */
    private final String value;
    /** 名称 */
    private final String dictionaryName;

    GjSupRatingRuleStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}


