package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 标题：DycProEsIndexMappingShipOrderItemBO
 * 描述：发货单明细索引映射
 */
@Data
public class DycProEsIndexMappingShipOrderItemBO implements Serializable {

    private static final long serialVersionUID = 35833645325216067L;
    /**
     * 发货明细id
     */
    private Long shipOrderItemId;
    /**
     * 销售明细id
     */
    private Long saleOrderItemId;
    /**
     * 单品ID
     */
    private String skuId;
    /**
     * 单品编码
     */
    private String skuCode;
    /**
     * sku外部单品id
     */
    private String skuExtSkuId;
    /**
     * 单品名称
     */
    private String skuName;
    /**
     * 销售金额
     */
    private BigDecimal salePrice;

    /**
     * 采购金额
     */
    private BigDecimal purchasePrice;
    /**
     * 采购数量
     */
    private BigDecimal purchaseCount;
    /**
     * 发货数量
     */
    private BigDecimal sendCount;
    /**
     * 退货数量
     */
    private BigDecimal returnCount;
    /**
     * 售后在途数量
     */
    private BigDecimal afterServingCount;
    /**
     * sku物料编码
     */
    private String skuMaterialCode;

    /**
     * sku物料名称
     */
    private String skuMaterialName;
    /**
     * sku物料类型名称
     */
    private String skuMaterialTypeName;
    /**
     * 计量单位
     */
    private String unitName;
    /**
     * 税率
     */
    private BigDecimal tax;
    /**
     * 计量单位位数
     */
    private String unitDigit;
    /**
     * sku单品主图url
     */
    private String skuMainPicUrl;
}
