package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author yuhao
 * @Date 2025/5/26 11:00
 * @Description:sku es index 映射对象
 **/
@Data
public class DycProEsIndexMappingSkuBO implements Serializable {
    private static final long serialVersionUID = -7124454027259804715L;
    /**
     * sku id
     */
    private Long skuId;
    /**
     * spu id
     */
    private Long spuId;
    /**
     * sku编码
     */
    private String skuCode;
    /**
     * 主图地址
     */
    private String mainImageUrl;
    /**
     * sku来源:
     * 2:电商sku
     * 3:协议sku
     */
    private Integer skuSource;
    /**
     * sku名称
     */
    private String skuName;
    /**
     * sku状态
     * 0：草稿
     * 1：待上架
     * 2：已上架
     * 3：已冻结
     * 4：已失效
     * 5：合规校验失败
     */
    private Integer skuStatus;
    /**
     * 外部spu id
     */
    private String extSpuId;
    /**
     * 外部sku id
     */
    private String extSkuId;
    /**
     * 69码
     */
    private String eanCode;
    /**
     * 审核状态
     */
    private Integer approvalStatus;
    /**
     * 检测状态:
     * 1:待检测
     * 2:检测中
     * 3:检测通过
     * 4:检测不通过
     */
    private Integer examineStatus;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 所属协议id
     */
    private Long agrId;
    /**
     * 所属协议明细id
     */
    private Long agrItemId;
    /**
     * 交易模式：1：贸易模式 2：搓合模式
     */
    private Integer tradeMode;
    /**
     * 协议编号
     */
    private String agrCode;
    /**
     * 协议名称
     */
    private String agrName;
    /**
     * 企业协议编号
     */
    private String enAgrCode;
    /**
     * 供货周期（协议明细上的）
     */
    private Integer supplyCycle;
    /**
     * 销售计量单位id
     */
    private Long saleMeasureId;
    /**
     * 销售计量单位名称
     */
    private String saleMeasureName;
    /**
     * 最小起订量
     */
    private BigDecimal minQuantity;
    /**
     * 税率
     */
    private BigDecimal rate;
    /**
     * 型号
     */
    private String model;
    /**
     * 规格
     */
    private String spec;
    /**
     * 供应商id
     */
    private Long supplierId;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 创建人id
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 创建人账号
     */
    private String createUserAccount;
    /**
     * 创建人机构id
     */
    private Long createOrgId;
    /**
     * 创建人机构名称
     */
    private String createOrgName;
    /**
     * 创建人机构路径
     */
    private String createOrgPath;
    /**
     * 创建人公司id
     */
    private Long createCompanyId;
    /**
     * 创建人公司名称
     */
    private String createCompanyName;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 市场价
     */
    private BigDecimal marketPrice;
    /**
     * 供货价
     */
    private BigDecimal supplierPrice;
    /**
     * 最新上架时间
     */
    private Date onShelveTime;
    /**
     * 上架方式:
     * 1：手动上架；
     * 2：自动上架-立即上架，
     * 3：自动上架-定时上架
     */
    private Integer onShelveWay;
    /**
     * 最新下架时间
     */
    private Date downShelveTime;
    /**
     * 下架方式：
     * 1：手动下架
     * 2：自动下架
     */
    private Integer downShelveWay;
    /**
     * 下架原因说明
     */
    private String downShelveReason;
    /**
     * 加价方式 1 按加价系数 2 按固定值
     */
    private Integer priceRiseType;
    /**
     * 加价系数
     */
    private String priceRiseRate;
    /**
     * 指导价
     */
    private BigDecimal guidedPrice;
    /**
     * 社会电商参考价
     */
    private BigDecimal thirdReferPrice;
    /**
     * 阶梯价规则
     */
    private String ladderPriceRule;
    /**
     * 变动时间(调价时间)
     */
    private Date chngTime;
    /**
     * 后台管理类目 全称
     */
    private String manageCatalogPath;
    /**
     * 后台管理类目 全称
     */
    private String manageCatalogPathName;
    /**
     * 价格规则id
     */
    private Long priceRuleId;
    /**
     * 销售价
     */
    private BigDecimal salePrice;
    /**
     * 折扣率
     */
    private BigDecimal discountRate;
    /**
     * 下单数量
     */
    private BigDecimal orderAmount;
    /**
     * 标准商品id
     */
    private Long upcId;

    /**
     * 物料ID
     */
    private Long materialId;

    /**
     * 物料编码
     */
    private String materialCode;

    /**
     * 物料名称
     */
    private String materialName;
    /**
     * 可见适用范围
     * ALL_*
     * COMPANY_PATH_
     * COMPANY_ID_
     */
    private List<String> viewScopeList;
    /**
     * 所属标准商品信息
     */
    //private DycProEsindexMappingUpcBO upcInfo;
    /**
     * 销售价信息
     */
    private List<DycProEsIndexMappingSkuSalePriceBO> salePriceList;
    /**
     * 对应后台管理目录信息
     */
    private List<DycProEsIndexMappingSkuManageCatalogBO> manageCatalogList;
    /**
     * 所属商品池信息
     */
    private List<DycProEsIndexMappingSkuPoolBO> poolList;
    /**
     * 商品禁售记录
     */
    private List<DycProEsIndexMappingBansRuleBO> bansRuleList;
    /**
     * 商品频道
     */
    private List<DycProEsIndexMappingSkuChannelBO> channelList;

    /**
     * 京东自营商品编码
     */
    private String jdSku;

    /**
     * 协商单编号
     **/
    private String consultNo;
    /**
     * 协商单类型
     * 1 询价、2 竞价、3 议价
     **/
    private Integer consultType;
    /**
     * 报价明细编码
     **/
    private String quoteItemCode;
}
