package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 协议变更申请类型 枚举
 *
 * @author ZHOUYUYAN
 */

public enum DmcAgrChngApplyChngType implements DictionaryEnum {
    PAUSE("DMC_AGR_CHNG_APPLY_CHNG_TYPE", "1", "暂停", "协议变更类型"),
    ENABLE("DMC_AGR_CHNG_APPLY_CHNG_TYPE", "2", "启用", "协议变更类型"),
    TERMINATE("DMC_AGR_CHNG_APPLY_CHNG_TYPE", "3", "终止", "协议变更类型"),
    ADJUST_PRICE("DMC_AGR_CHNG_APPLY_CHNG_TYPE", "4", "调价", "协议变更类型"),
    EXTEND("DMC_AGR_CHNG_APPLY_CHNG_TYPE", "5", "延期", "协议变更类型"),
    SUPPLEMENT("DMC_AGR_CHNG_APPLY_CHNG_TYPE", "6", "补充", "协议变更类型"),
    OTHER("DMC_AGR_CHNG_APPLY_CHNG_TYPE", "7", "其他变更", "协议变更类型");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrChngApplyChngType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
