package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 标题：DycProBaseCallEsbUtilUpdateSendSkuWaybillInfoForJdBO
 * 描述：售后发运信息填写运单信息参数（京东）
 */
@Data
public class DycProBaseCallEsbUtilUpdateSendSkuWaybillInfoForJdBO implements Serializable {

    private static final long serialVersionUID = 3683618351799586055L;

    /**
     * 发货公司
     */
    private String expressCompany;

    /**
     * 货运单号，字段长度不超过50
     */
    private String expressCode;

    /**
     * 发货日期，格式为yyyy-MM-dd HH:mm:ss
     */
    private String deliverDate;

    /**
     * 运费
     */
    private BigDecimal freightMoney;

    /**
     * 商品编号
     */
    private Long wareId;

    /**
     * 商品类型。10主商品，20赠品
     */
    private Integer wareType;

    /**
     * 商品数量
     */
    private Integer wareNum;

}
