package com.tydic.dyc.pro.base.utils.esb;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.math.RoundingMode;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;

/**
 * @Author yuhao
 * @Date 2025/5/20 11:01
 * @Description:调用能力平台工具
 **/
@Slf4j
public class DycProBaseCallEsbUtil {

    /**
     * 获取电商商品价格信息（京东）
     */
    public static DycProBaseCallEsbUtilGetSkuPriceForJdRspBO getSkuPriceForJd(DycProBaseCallEsbUtilGetSkuPriceForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuPriceForJdRspBO rspBO = new DycProBaseCallEsbUtilGetSkuPriceForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品价格信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            if (resultJsonObj.getJSONArray("result") != null) {
                List<DycProBaseCallEsbUtilGetSkuPriceForJdResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetSkuPriceForJdResultBO.class);
                rspBO.setResult(result);
            }
        }
        return rspBO;
    }
    /**
     * 获取电商商品图片信息（京东）
     */
    public static DycProBaseCallEsbUtilGetSkuImageForJdRspBO getSkuImageForJd(DycProBaseCallEsbUtilGetSkuImageForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuImageForJdRspBO rspBO = new DycProBaseCallEsbUtilGetSkuImageForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品图片信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            List<DycProBaseCallEsbUtilGetSkuImageForJdResultBO> result = resultJsonObj.getJSONObject("result").getJSONArray(reqBO.getSku()).toJavaList(DycProBaseCallEsbUtilGetSkuImageForJdResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }
    /**
     * 获取电商商品详细信息（京东）
     */
    public static DycProBaseCallEsbUtilGetSkuDetailForJdRspBO getSkuDetailForJd(DycProBaseCallEsbUtilGetSkuDetailForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuDetailForJdRspBO rspBO = new DycProBaseCallEsbUtilGetSkuDetailForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品详细信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            DycProBaseCallEsbUtilGetSkuDetailForJdResultBO result = resultJsonObj.getObject("result", DycProBaseCallEsbUtilGetSkuDetailForJdResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }
    /**
     * 获取商品上下架状态(京东)
     */
    public static DycProBaseCallEsbUtilGetSkuStateForJdRspBO getSkuStateForJd(DycProBaseCallEsbUtilGetSkuStateForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuStateForJdRspBO rspBO = new DycProBaseCallEsbUtilGetSkuStateForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品详细信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            if (resultJsonObj.getJSONArray("result") != null) {
                List<DycProBaseCallEsbUtilGetSkuStateForJdResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetSkuStateForJdResultBO.class);
                rspBO.setResult(result);
            }
        }
        return rspBO;
    }
    /**
     * 通过区域名称获取地址库编码(京东)
     */
    public static DycProBaseCallEsbUtilGetJdAdressRspBO getJdAdress(DycProBaseCallEsbUtilGetJdAdressReqBO reqBO){
        DycProBaseCallEsbUtilGetJdAdressRspBO rspBO = new DycProBaseCallEsbUtilGetJdAdressRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品详细信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            JSONObject object = resultJsonObj.getJSONObject("result");
            DycProBaseCallEsbUtilGetJdAdressResultBO result = JSON.parseObject(JSON.toJSONString(object), DycProBaseCallEsbUtilGetJdAdressResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }
    /**
     * 获取电商商品区域购买限制信息（京东）
     */
    public static DycProBaseCallEsbUtilGetCheckAreaLimitForJdRspBO getCheckAreaLimitForJd(DycProBaseCallEsbUtilGetCheckAreaLimitForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetCheckAreaLimitForJdRspBO rspBO = new DycProBaseCallEsbUtilGetCheckAreaLimitForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品区域购买限制信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            if (resultJsonObj.getJSONArray("result") != null) {
                List<DycProBaseCallEsbUtilGetCheckAreaLimitForJdResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetCheckAreaLimitForJdResultBO.class);
                rspBO.setResult(result);
            }
        }
        return rspBO;
    }
    /**
     * 获取电商商品可售信息（京东）
     */
    public static DycProBaseCallEsbUtilGetCheckForJdRspBO getCheckForJd(DycProBaseCallEsbUtilGetCheckForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetCheckForJdRspBO rspBO = new DycProBaseCallEsbUtilGetCheckForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            if (resultJsonObj.getJSONArray("result") != null) {
                List<DycProBaseCallEsbUtilGetCheckForJdResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetCheckForJdResultBO.class);
                rspBO.setResult(result);
            }
        }
        return rspBO;
    }
    /**
     * 获取电商商品预计送达时间信息（京东Iop）
     */
    public static DycProBaseCallEsbUtilGetPromiseTipsForJdIopRspBO getPromiseTipsForJdIop(DycProBaseCallEsbUtilGetPromiseTipsForJdIopReqBO reqBO){
        DycProBaseCallEsbUtilGetPromiseTipsForJdIopRspBO rspBO = new DycProBaseCallEsbUtilGetPromiseTipsForJdIopRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            rspBO.setResult(resultJsonObj.getString("result"));
        }
        return rspBO;
    }
    /**
     * 获取电商商品预计送达时间信息（京东Vop）
     */
    public static DycProBaseCallEsbUtilGetPromiseTipsForJdVopRspBO getPromiseTipsForJdVop(DycProBaseCallEsbUtilGetPromiseTipsForJdVopReqBO reqBO){
        DycProBaseCallEsbUtilGetPromiseTipsForJdVopRspBO rspBO = new DycProBaseCallEsbUtilGetPromiseTipsForJdVopRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            rspBO.setResult(resultJsonObj.getString("result"));
        }
        return rspBO;
    }
    /**
     * 获取电商商品库存信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetStockForJdRspBO getStockForJd(DycProBaseCallEsbUtilGetStockForJdReqBO reqBO){
        DycProBaseCallEsbUtilGetStockForJdRspBO rspBO = new DycProBaseCallEsbUtilGetStockForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        reqBO.getSkuNums().forEach(dycProBaseCallEsbUtilGetStockSkuNumBO -> {
            dycProBaseCallEsbUtilGetStockSkuNumBO.setNum(dycProBaseCallEsbUtilGetStockSkuNumBO.getNum().setScale(0, RoundingMode.DOWN));
        });
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            if (resultJsonObj.getJSONArray("result") != null) {
                List<DycProBaseCallEsbUtilGetStockForJdResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetStockForJdResultBO.class);
                rspBO.setResult(result);
            }
        }
        return rspBO;
    }
    /**
     * 获取商品上下架状态(非京东)
     */
    public static DycProBaseCallEsbUtilGetSkuStateRspBO getSkuState(DycProBaseCallEsbUtilGetSkuStateReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuStateRspBO rspBO = new DycProBaseCallEsbUtilGetSkuStateRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品详细信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            if (resultJsonObj.getJSONArray("result") != null) {
                List<DycProBaseCallEsbUtilGetSkuStateResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetSkuStateResultBO.class);
                rspBO.setResult(result);
            }
        }
        return rspBO;
    }
    /**
     * 获取电商商品详细信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetSkuDetailRspBO getSkuDetail(DycProBaseCallEsbUtilGetSkuDetailReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuDetailRspBO rspBO = new DycProBaseCallEsbUtilGetSkuDetailRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品详细信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            DycProBaseCallEsbUtilGetSkuDetailResultBO result = resultJsonObj.getObject("result", DycProBaseCallEsbUtilGetSkuDetailResultBO.class);
            rspBO.setResult(result);
        }
        return rspBO;
    }
    /**
     * 获取电商商品图片信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetSkuImageRspBO getSkuImage(DycProBaseCallEsbUtilGetSkuImageReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuImageRspBO rspBO = new DycProBaseCallEsbUtilGetSkuImageRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品图片信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            if (resultJsonObj.getJSONArray("result") != null) {
                List<DycProBaseCallEsbUtilGetSkuImageResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetSkuImageResultBO.class);
                rspBO.setResult(result);
            }
        }
        return rspBO;
    }
    /**
     * 获取电商商品价格信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetSkuPriceRspBO getSkuPrice(DycProBaseCallEsbUtilGetSkuPriceReqBO reqBO){
        DycProBaseCallEsbUtilGetSkuPriceRspBO rspBO = new DycProBaseCallEsbUtilGetSkuPriceRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品价格信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            if (resultJsonObj.getJSONArray("result") != null) {
                List<DycProBaseCallEsbUtilGetSkuPriceResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetSkuPriceResultBO.class);
                rspBO.setResult(result);
            }
        }
        return rspBO;
    }
    /**
     * 获取电商商品区域购买限制信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetCheckAreaLimitRspBO getCheckAreaLimit(DycProBaseCallEsbUtilGetCheckAreaLimitReqBO reqBO){
        DycProBaseCallEsbUtilGetCheckAreaLimitRspBO rspBO = new DycProBaseCallEsbUtilGetCheckAreaLimitRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品区域购买限制信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            if (resultJsonObj.getJSONArray("result") != null) {
                List<DycProBaseCallEsbUtilGetCheckAreaLimitResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetCheckAreaLimitResultBO.class);
                rspBO.setResult(result);
            }
        }
        return rspBO;
    }
    /**
     * 获取电商商品可售信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetCheckRspBO getCheck(DycProBaseCallEsbUtilGetCheckReqBO reqBO){
        DycProBaseCallEsbUtilGetCheckRspBO rspBO = new DycProBaseCallEsbUtilGetCheckRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            if (resultJsonObj.getJSONArray("result") != null) {
                List<DycProBaseCallEsbUtilGetCheckResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetCheckResultBO.class);
                rspBO.setResult(result);
            }
        }
        return rspBO;
    }
    /**
     * 获取电商商品库存信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetStockRspBO getStock(DycProBaseCallEsbUtilGetStockReqBO reqBO){
        DycProBaseCallEsbUtilGetStockRspBO rspBO = new DycProBaseCallEsbUtilGetStockRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            if (resultJsonObj.getJSONArray("result") != null) {
                List<DycProBaseCallEsbUtilGetStockResultBO> result = resultJsonObj.getJSONArray("result").toJavaList(DycProBaseCallEsbUtilGetStockResultBO.class);
                rspBO.setResult(result);
            }
        }
        return rspBO;
    }
    /**
     * 获取电商商品预计送达时间信息（非京东）
     */
    public static DycProBaseCallEsbUtilGetPromiseTipsRspBO getPromiseTips(DycProBaseCallEsbUtilGetPromiseTipsReqBO reqBO){
        DycProBaseCallEsbUtilGetPromiseTipsRspBO rspBO = new DycProBaseCallEsbUtilGetPromiseTipsRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("获取电商商品可售信息,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            JSONObject result = resultJsonObj.getJSONObject("result");
            rspBO.setResult(result.getString("tips"));
            rspBO.setEta(result.getString("eta"));
        }
        return rspBO;
    }
    /**
     * 电商预定单下单
     */
    public static DycProBaseCallEsbUtilOrderEsPreOrderSubmitRspBO submitOrder(DycProBaseCallEsbUtilOrderEsPreOrderSubmitReqBO reqBO) {
        DycProBaseCallEsbUtilOrderEsPreOrderSubmitRspBO rspBO = new DycProBaseCallEsbUtilOrderEsPreOrderSubmitRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setOrgId(null);
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("电商预定单下单,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            JSONObject result = resultJsonObj.getJSONObject("result");
            if (result != null) {
                rspBO.setResult(result.toJavaObject(DycProBaseCallEsbUtilOrderEsPreOrderSubmitRspResultBO.class));
            }
        }
        return rspBO;
    }
    /**
     * 查询外部订单信息
     */
    public static DycProBaseCallEsbUtilOrderQrySubOrderRspBO qrySubOrder(DycProBaseCallEsbUtilOrderQrySubOrderReqBO reqBO) {
        DycProBaseCallEsbUtilOrderQrySubOrderRspBO rspBO = new DycProBaseCallEsbUtilOrderQrySubOrderRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setOrgId(null);
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("查询外部订单信息,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            JSONObject result = resultJsonObj.getJSONObject("result");
            if (result != null) {
                rspBO.setResult(result.toJavaObject(DycProBaseCallEsbUtilOrderQrySubOrderResultBO.class));
            }
        }
        return rspBO;
    }
    /**
     * 京东地址校验
     */
    public static DycProBaseJdAddressCheckRspBO checkJdAddressInfo(DycProBaseJdAddressCheckReqBO reqBO) {
        DycProBaseJdAddressCheckRspBO rspBO = new DycProBaseJdAddressCheckRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_FAIL);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("查询京东地址校验,没有收到能力平台的响应");
        }else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            JSONObject result = resultJsonObj.getJSONObject("result");
            if (result != null) {
                rspBO.setSuccess(result.getBoolean("success"));
            }
        }
        return rspBO;
    }
    /**
     * 京东地址查询
     */
    public static DycProBaseJdAddressQryRspBO qryJdAddressInfo(DycProBaseJdAddressQryReqBO reqBO) {
        DycProBaseJdAddressQryRspBO rspBO = new DycProBaseJdAddressQryRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_FAIL);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("查询京东地址查询,没有收到能力平台的响应");
        }else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            JSONObject result = resultJsonObj.getJSONObject("result");
            if (result != null) {
                rspBO.setAddressInfoBO(result.toJavaObject(DycProBaseJdAddressInfoBO.class));
            }
        }
        return rspBO;
    }
    /**
     * 取消订单
     */
    public static DycProBaseCallEsbUtilCancelRspBO cancel(DycProBaseCallEsbUtilCancelReqBO reqBO){
        DycProBaseCallEsbUtilCancelRspBO rspBO = new DycProBaseCallEsbUtilCancelRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台取消电商订单,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
        }
        return rspBO;
    }
    /**
     * 电商预订单确认
     */
    public static DycProBaseCallEsbUtilConfirmOrderRspBO confirmOrder(DycProBaseCallEsbUtilConfirmOrderReqBO reqBO){
        DycProBaseCallEsbUtilConfirmOrderRspBO rspBO = new DycProBaseCallEsbUtilConfirmOrderRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台确认电商预订单,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
        }
        return rspBO;
    }
    /**
     * 订单完结
     */
    public static DycProBaseCallEsbUtilOrderCompletionRspBO orderCompletion(DycProBaseCallEsbUtilOrderCompletionReqBO reqBO){
        DycProBaseCallEsbUtilOrderCompletionRspBO rspBO = new DycProBaseCallEsbUtilOrderCompletionRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台完结订单,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
        }
        return rspBO;
    }
    /**
     * 待发货取消订单正式取消
     */
    public static DycProBaseCallEsbUtilCancelSendOrderConfirmRspBO cancelSendOrderConfirm(DycProBaseCallEsbUtilCancelSendOrderConfirmReqBO reqBO){
        DycProBaseCallEsbUtilCancelSendOrderConfirmRspBO rspBO = new DycProBaseCallEsbUtilCancelSendOrderConfirmRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if(StringUtils.isEmpty(resultStr)){
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台确认电商预订单,没有收到能力平台的响应");
        }else{
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
        }
        return rspBO;
    }
    /**
     * 查询外部发货单信息
     */
    public static DycProBaseCallEsbUtilOrderQryPackageRspBO qryPackage(DycProBaseCallEsbUtilOrderQryPackageReqBO reqBO) {
        DycProBaseCallEsbUtilOrderQryPackageRspBO rspBO = new DycProBaseCallEsbUtilOrderQryPackageRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("查询外部发货单信息,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            JSONObject result = resultJsonObj.getJSONObject("result");
            if (result != null) {
                rspBO.setResult(result.toJavaObject(DycProBaseCallEsbUtilOrderQryPackageBO.class));
            }
        }
        return rspBO;
    }

    /**
     * 售后服务类型（非京东）
     */
    public static DycProBaseCallEsbUtilAfterTypeRspBO afterType(DycProBaseCallEsbUtilAfterTypeReqBO reqBO) {
        DycProBaseCallEsbUtilAfterTypeRspBO rspBO = new DycProBaseCallEsbUtilAfterTypeRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台查询售后服务类型（非京东）,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            JSONArray result = resultJsonObj.getJSONArray("result");
            if (null != result) {
                rspBO.setResult(result.toJavaList(DycProBaseCallEsbUtilAfterTypeBO.class));
            }
        }
        return rspBO;
    }

    /**
     * 售后服务类型（京东）
     */
    public static DycProBaseCallEsbUtilAfterTypeForJdRspBO afterTypeForJd(DycProBaseCallEsbUtilAfterTypeForJdReqBO reqBO) {
        DycProBaseCallEsbUtilAfterTypeForJdRspBO rspBO = new DycProBaseCallEsbUtilAfterTypeForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台查询售后服务类型（京东）,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            JSONArray result = resultJsonObj.getJSONArray("result");
            if (null != result) {
                rspBO.setResult(result.toJavaList(DycProBaseCallEsbUtilAfterTypeSupportedInfoForJdBO.class));
            }
        }
        return rspBO;
    }

    /**
     * 售后服务取件方式（非京东）
     */
    public static DycProBaseCallEsbUtilAfterTakeRspBO afterTake(DycProBaseCallEsbUtilAfterTakeReqBO reqBO) {
        DycProBaseCallEsbUtilAfterTakeRspBO rspBO = new DycProBaseCallEsbUtilAfterTakeRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台查询售后服务取件方式（非京东）,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            JSONArray result = resultJsonObj.getJSONArray("result");
            if (null != result) {
                rspBO.setResult(result.toJavaList(DycProBaseCallEsbUtilAfterTakeBO.class));
            }
        }
        return rspBO;
    }

    /**
     * 售后单取消（非京东）
     */
    public static DycProBaseCallEsbUtilCancelServiceOrderRspBO cancelServiceOrder(DycProBaseCallEsbUtilCancelServiceOrderReqBO reqBO) {
        DycProBaseCallEsbUtilCancelServiceOrderRspBO rspBO = new DycProBaseCallEsbUtilCancelServiceOrderRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台售后单取消（非京东）,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
        }
        return rspBO;
    }

    /**
     * 售后单取消（京东）
     */
    public static DycProBaseCallEsbUtilCancelServiceOrderForJdRspBO cancelServiceOrderForJd(DycProBaseCallEsbUtilCancelServiceOrderForJdReqBO reqBO) {
        DycProBaseCallEsbUtilCancelServiceOrderForJdRspBO rspBO = new DycProBaseCallEsbUtilCancelServiceOrderForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台售后单取消（京东）,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
        }
        return rspBO;
    }

    /**
     * 售后发运信息填写（非京东）
     */
    public static DycProBaseCallEsbUtilUpdateSendSkuRspBO updateSendSku(DycProBaseCallEsbUtilUpdateSendSkuReqBO reqBO) {
        DycProBaseCallEsbUtilUpdateSendSkuRspBO rspBO = new DycProBaseCallEsbUtilUpdateSendSkuRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台售后发运信息填写（非京东）,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
        }
        return rspBO;
    }

    /**
     * 售后发运信息填写（京东）
     */
    public static DycProBaseCallEsbUtilUpdateSendSkuForJdRspBO updateSendSkuForJd(DycProBaseCallEsbUtilUpdateSendSkuForJdReqBO reqBO) {
        DycProBaseCallEsbUtilUpdateSendSkuForJdRspBO rspBO = new DycProBaseCallEsbUtilUpdateSendSkuForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台售后发运信息填写（京东）,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
        }
        return rspBO;
    }

    /**
     * 申请售后（非京东）
     */
    public static DycProBaseCallEsbUtilServiceOrderRspBO serviceOrder(DycProBaseCallEsbUtilServiceOrderReqBO reqBO) {
        DycProBaseCallEsbUtilServiceOrderRspBO rspBO = new DycProBaseCallEsbUtilServiceOrderRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台申请售后（非京东）,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            JSONObject result = resultJsonObj.getJSONObject("result");
            if (null != result) {
                rspBO.setResult(result.toJavaObject(DycProBaseCallEsbUtilServiceOrderResultBO.class));
            }
        }
        return rspBO;
    }

    /**
     * 申请售后（京东）
     */
    public static DycProBaseCallEsbUtilServiceOrderForJdRspBO serviceOrderForJd(DycProBaseCallEsbUtilServiceOrderForJdReqBO reqBO) {
        DycProBaseCallEsbUtilServiceOrderForJdRspBO rspBO = new DycProBaseCallEsbUtilServiceOrderForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台申请售后（京东）,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
        }
        return rspBO;
    }

    /**
     * 确认售后完成（京东）
     */
    public static DycProBaseCallEsbUtilConfirmAfsOrderForJdRspBO confirmAfsOrderForJd(DycProBaseCallEsbUtilConfirmAfsOrderForJdReqBO reqBO) {
        DycProBaseCallEsbUtilConfirmAfsOrderForJdRspBO rspBO = new DycProBaseCallEsbUtilConfirmAfsOrderForJdRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台确认售后完成（京东）,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
        }
        return rspBO;
    }

    /**
     * 三方物流信息查询接口
     */
    public static DycProBaseCallEsbUtilQueryDoPaRspBO queryDoPa(DycProBaseCallEsbUtilQueryDoPaReqBO reqBO) {
        DycProBaseCallEsbUtilQueryDoPaRspBO rspBO = new DycProBaseCallEsbUtilQueryDoPaRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台三方物流信息查询接口,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.SUCCESS);
            rspBO.setResultMessage("成功");
            //快递公司编码
            rspBO.setComCode(resultJsonObj.getString("com"));
            //单号
            rspBO.setNumber(resultJsonObj.getString("nu"));
            //是否签收
            rspBO.setIsCheck(resultJsonObj.getString("ischeck"));
            //快递单当前状态
            rspBO.setState(resultJsonObj.getString("state"));
            //物流数据
            Optional.ofNullable(resultJsonObj.getJSONArray("data")).ifPresent(o -> {
                List<DycProBaseCallEsbUtilTraceInfoDataBO> traceInfoDataFuncBOS = o.toJavaList(DycProBaseCallEsbUtilTraceInfoDataBO.class);
                rspBO.setTraceList(traceInfoDataFuncBOS);
            });
        }
        return rspBO;
    }

    /**
     * 电商物流信息查询接口
     */
    public static DycProBaseCallEsbUtilQueryOrderTrackRspBO orderTrack(DycProBaseCallEsbUtilQueryOrderTrackReqBO reqBO) {
        DycProBaseCallEsbUtilQueryOrderTrackRspBO rspBO = new DycProBaseCallEsbUtilQueryOrderTrackRspBO();
        long timeStamp = Instant.now().toEpochMilli();
        reqBO.setTimeStamp(timeStamp);
        reqBO.setSerialNumber(getSerialNumber(timeStamp));
        String url = reqBO.getUrl();
        reqBO.setUrl(null);
        String resultStr = HttpUtil.post(url, JSON.toJSONString(reqBO));
        if (StringUtils.isEmpty(resultStr)) {
            //没有收到能力平台的响应
            rspBO.setSuccess(DycProBaseCallEsbConstant.IsSuccess.IS_SUCCESS);
            rspBO.setResultCode(DycProBaseCallEsbConstant.ResultCode.NO_RESULT_ERROR);
            rspBO.setResultMessage("调用能力平台电商物流信息查询接口,没有收到能力平台的响应");
        } else {
            JSONObject resultJsonObj = JSONObject.parseObject(resultStr);
            rspBO.setSuccess(resultJsonObj.getBoolean("success"));
            rspBO.setResultCode(resultJsonObj.getString("resultCode"));
            rspBO.setResultMessage(resultJsonObj.getString("resultMessage"));
            String jsonStr = JSONObject.toJSONString(resultJsonObj.get("result"));
            if (ObjectUtil.isNotEmpty(jsonStr)) {
                JSONObject object = JSONObject.parseObject(jsonStr);
                String orderTrack = JSONObject.toJSONString(object.get("orderTrack"));
                String orderId = (String) JSONObject.parseObject(jsonStr).get("orderId");
                if (ObjectUtil.isNotEmpty(orderTrack)) {
                    List<DycProBaseCallEsbUtilOrderTraceInfoBO> orderTrackList = JSON.parseArray(orderTrack, DycProBaseCallEsbUtilOrderTraceInfoBO.class);
                    if (ObjectUtil.isNotEmpty(orderTrackList)) {
                        orderTrackList = orderTrackList.stream().sorted(Comparator.comparing(DycProBaseCallEsbUtilOrderTraceInfoBO::getMsgTime)).collect(Collectors.toList());
                        rspBO.setOrderTrackList(orderTrackList);
                    }

                }
                String waybillCode = object.getString("waybillCode");
                if (StringUtils.isNotBlank(waybillCode)) {
                    try {
                        JSONArray array = JSONArray.parseArray(waybillCode);
                        rspBO.setCarrier(array.getJSONObject(0).getString("carrier"));
                        rspBO.setDeliveryOrderId(array.getJSONObject(0).getString("deliveryOrderId"));
                    } catch (Exception e) {
                        try {
                            JSONObject code = JSONObject.parseObject(waybillCode);
                            rspBO.setCarrier(code.getString("carrier"));
                            rspBO.setDeliveryOrderId(code.getString("deliveryOrderId"));
                        } catch (Exception ignored) {
                            log.error("解析异常:{}", ignored.getMessage());
                        }
                    }
                }
                rspBO.setOrderId(orderId);
            }
        }
        return rspBO;
    }


    private static String getSerialNumber(long timeStamp){
        int min = 1000;
        int max = 9999;
        Random random = new Random();
        int resultInt = random.nextInt(max) % (max - min + 1) + min;
        return "DMC_PRO" + timeStamp + resultInt;
    }
}
