package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 标题：DycProBaseCallEsbUtilServiceOrderWareDetailInfoBO
 * 描述：申请售后商品明细（京东）
 */
@Data
public class DycProBaseCallEsbUtilServiceOrderWareDetailInfoForJdBO implements Serializable {

    private static final long serialVersionUID = 4635611786954338452L;

    /**
     * 商品编号
     */
    private Long wareId;

    /**
     * 主商品编号
     */
    private Long mainWareId;

    /**
     * 商品名称
     */
    private String wareName;

    /**
     * 商品申请数量
     */
    private Integer wareNum;

    /**
     * 附件描述
     */
    private String wareDescribe;

    /**
     * 支付金额，即“商品单价*数量”
     */
    private BigDecimal payPrice;

    /**
     * 商品类型，10主商品，20赠品
     */
    private Integer wareType;

}
