/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.filter;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.umc.base.bo.UmcRspBaseBO;
import com.tydic.umc.base.util.UmcRspUtils;
import com.tydic.umc.general.ability.api.UmcLoginAbilityService;
import com.tydic.umc.general.ability.bo.UmcLoginExpTimeAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcLoginExpTimeAbilityRspBO;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import com.tydic.umc.security.base.UmcUserDetails;
import com.tydic.umc.security.filter.ParameterRequestWrapper;
import com.tydic.umc.security.jwt.UmcJwt;
import com.tydic.umc.security.jwt.UmcTokenState;
import com.tydic.umc.security.manager.VisitDomainManager;
import com.tydic.umc.security.service.GetUserInfoByUserIdService;
import com.tydic.umc.security.utils.RegexUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Order(value=0x7FFFFFFD)
@Component
public class UmcTokenAuthenticationFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcTokenAuthenticationFilter.class);
    @Value(value="${static.resources}")
    private String staticResources;
    @Value(value="${login.expTime:7200}")
    private Long expTime;
    private static ThreadLocal<Boolean> allowSessionCreation = new ThreadLocal();
    @Autowired
    private GetUserInfoByUserIdService getUserInfoByTokenService;
    @Autowired
    private UmcLoginAbilityService umcLoginAbilityService;
    @Autowired
    private VisitDomainManager visitDomainManager;

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        String token = request.getHeader("auth-token");
        if (StringUtils.isEmpty((CharSequence)token)) {
            token = UmcTokenAuthenticationFilter.getTokenFromCookies(request);
        }
        if (Objects.isNull(token)) {
            com.alibaba.fastjson.JSONObject dataField = UmcTokenAuthenticationFilter.buildRspDataField("AE401", "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            this.handleAuthFailed(dataField, response, 401);
            return null;
        }
        Map<String, Object> tokenResultMap = this.parseTokenValidateResult(token);
        LOGGER.info("[umcTokenAuth]-tokenResultMap:{}", (Object)JSONUtil.toJsonStr(tokenResultMap));
        UmcTokenState state = UmcTokenState.getTokenState((String)tokenResultMap.get("state"));
        if (Objects.isNull((Object)state) || state.equals((Object)UmcTokenState.INVALID)) {
            com.alibaba.fastjson.JSONObject dataField = UmcTokenAuthenticationFilter.buildRspDataField("AE401", "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            this.handleAuthFailed(dataField, response, 401);
            return null;
        }
        if (state.equals((Object)UmcTokenState.EXPIRED)) {
            com.alibaba.fastjson.JSONObject dataField = UmcTokenAuthenticationFilter.buildRspDataField("AE401", "\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            this.handleAuthFailed(dataField, response, 401);
            return null;
        }
        if (!state.equals((Object)UmcTokenState.VALID)) {
            com.alibaba.fastjson.JSONObject dataField = UmcTokenAuthenticationFilter.buildRspDataField("AE401", "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            this.handleAuthFailed(dataField, response, 401);
            return null;
        }
        JSONObject tokenDataObj = (JSONObject)tokenResultMap.get("data");
        request.setAttribute("data", (Object)tokenDataObj);
        String appCode = tokenDataObj.getAsString("appCode");
        Long userId = (Long)tokenDataObj.get((Object)"userId");
        UmcUserDetails menuAuthResult = this.getUserInfoByTokenService.getUserInfoByUserId(userId, token, appCode, request.getRequestURI());
        LOGGER.info("[umcTokenAuth]-menuAuthResult:{}", (Object)JSONUtil.toJsonStr((Object)menuAuthResult));
        if (UmcRspUtils.isRspFailed((String)menuAuthResult.getRespCode())) {
            int scCode = "AE403".equals(menuAuthResult.getRespCode()) ? 403 : 401;
            com.alibaba.fastjson.JSONObject dataField = UmcTokenAuthenticationFilter.buildRspDataField(menuAuthResult.getRespCode(), menuAuthResult.getRespDesc());
            this.handleAuthFailed(dataField, response, scCode);
            return null;
        }
        UmcRspBaseBO visitDomainAuthResult = this.visitDomainManager.authOriginMatchesUserType(request, userId, token);
        LOGGER.info("[umcTokenAuth]-visitDomainAuthResult:{}", (Object)JSONUtil.toJsonStr((Object)visitDomainAuthResult));
        if (UmcRspUtils.isRspFailed((String)visitDomainAuthResult.getRespCode())) {
            com.alibaba.fastjson.JSONObject dataField = UmcTokenAuthenticationFilter.buildRspDataField(menuAuthResult.getRespCode(), menuAuthResult.getRespDesc());
            this.handleAuthFailed(dataField, response, 401);
            return null;
        }
        UmcLoginExpTimeAbilityReqBO reqBO = new UmcLoginExpTimeAbilityReqBO();
        reqBO.setUserId(userId);
        reqBO.setLoginSource((String)tokenDataObj.get((Object)"loginSource"));
        this.umcLoginAbilityService.updateLoginExpTime(reqBO);
        return new UsernamePasswordAuthenticationToken((Object)menuAuthResult.getUserDetails(), (Object)menuAuthResult.getUserDetails().getPassword(), menuAuthResult.getUserDetails().getAuthorities());
    }

    private Map<String, Object> parseTokenValidateResult(String token) {
        UmcLoginExpTimeAbilityReqBO reqBO = new UmcLoginExpTimeAbilityReqBO();
        reqBO.setToken(token);
        UmcLoginExpTimeAbilityRspBO rspBO = this.umcLoginAbilityService.getLoginExpTime(reqBO);
        Long loginExpTime = 0L;
        LOGGER.debug("\u8c03\u7528\u83b7\u53d6\u5230\u671f\u65f6\u95f4\u670d\u52a1:{}", (Object)JSON.toJSONString((Object)rspBO));
        if ("0000".equals(rspBO.getRespCode())) {
            loginExpTime = rspBO.getExpTime();
            LOGGER.debug("\u83b7\u53d6\u5230\u671f\u65f6\u95f4:{}", (Object)loginExpTime);
        }
        Map<String, Object> resultMap = UmcJwt.validToken(token, loginExpTime);
        return resultMap;
    }

    private void handleAuthFailed(com.alibaba.fastjson.JSONObject dataField, HttpServletResponse response, int scCode) throws IOException {
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        jsonObject.put("data", (Object)dataField);
        jsonObject.put("code", (Object)"1");
        jsonObject.put("message", (Object)"\u5931\u8d25");
        response.setStatus(scCode);
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        String jsonString = JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        out.write(jsonString);
        out.close();
    }

    private static String getTokenFromCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"auth-token".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    private static com.alibaba.fastjson.JSONObject buildRspDataField(String respCode, String respDesc) {
        com.alibaba.fastjson.JSONObject dataField = new com.alibaba.fastjson.JSONObject();
        dataField.put("respCode", (Object)respCode);
        dataField.put("respDesc", (Object)respDesc);
        return dataField;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        ServletRequest requestWrapper = null;
        String url = request.getRequestURI();
        LOGGER.debug("\u5f53\u524d\u8bf7\u6c42\u7684url:{}", (Object)url);
        boolean needToken = true;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.staticResources})) {
            String[] split;
            for (String staticResource : split = this.staticResources.split(";")) {
                if (!RegexUtils.wildcardEquals(staticResource, url)) continue;
                needToken = false;
            }
        }
        if (RegexUtils.wildcardEquals("**/**/users/signup/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/noauth/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/**/noauth/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/**/noauth/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/api/token/get", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/oap/api/**", url)) {
            LOGGER.info("\u5e73\u53f0url**/oap/api/getAccessToken");
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/oap/api/getAccessToken", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/oap/api/**", url)) {
            LOGGER.info("\u5e73\u53f0url**/**/oap/api/**");
            needToken = false;
        }
        allowSessionCreation.set(true);
        if (needToken) {
            Authentication auth = this.attemptAuthentication(request, response);
            if (auth == null) {
                return;
            }
            allowSessionCreation.set(false);
            SecurityContextHolder.getContext().setAuthentication(auth);
            requestWrapper = this.parameterRequest(request.getHeader("auth-token"), request, response);
        }
        if (requestWrapper == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            LOGGER.debug("UmcUserInfoWrapperFilter---1\uff1a");
        } else {
            LOGGER.debug("UmcUserInfoWrapperFilter---2\uff1a");
            chain.doFilter(requestWrapper, (ServletResponse)response);
        }
    }

    private ServletRequest parameterRequest(String token, HttpServletRequest request, HttpServletResponse response) {
        UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
        ParameterRequestWrapper requestWrapper = null;
        if (userInfo != null) {
            if (LOGGER.isDebugEnabled()) {
                // empty if block
            }
            if (userInfo.getUserId() != null && request instanceof HttpServletRequest) {
                LOGGER.debug("UmcUserInfoWrapperFilter---\u81ea\u5b9a\u4e49\u5305\u88c5\u5668\uff1a");
                requestWrapper = new ParameterRequestWrapper(request);
            }
        }
        LOGGER.debug("UmcUserInfoWrapperFilter---requestWrapper\uff1a");
        return requestWrapper;
    }

    public static boolean isAllowSessionCreation() {
        return allowSessionCreation.get();
    }
}

