/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoItemQryBo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoQryBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItem;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItemPageRspBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoListDo;
import com.tydic.dyc.umc.model.todo.sub.UmcTransferRspBo;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.service.todo.UmcDealTransferTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcDealTransferTodoBo;
import com.tydic.dyc.umc.service.todo.bo.UmcDealTransferTodoReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.todo.UmcDealTransferTodoService"})
public class UmcDealTransferTodoServiceImpl
implements UmcDealTransferTodoService {
    private static final Logger log = LoggerFactory.getLogger(UmcDealTransferTodoServiceImpl.class);
    @Autowired
    private IUmcTodoModel iUmcTodoModel;
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;
    @Resource(name="umcTodoSyncProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${umc.todo.sync.topic:UMC_TODO_SYNC_TOPIC}")
    private String todoSyncTopic;
    @Value(value="${umc.todo.sync.tag:*}")
    private String todoSyncTag;
    @Value(value="${umc.transfer.todo.sync.enable:true}")
    private boolean transferTodoSyncEnable;

    @PostMapping(value={"dealTransferTodo"})
    public UmcSendTodoRspBo dealTransferTodo(@RequestBody UmcDealTransferTodoReqBo reqBo) {
        this.val(reqBo);
        UmcSendTodoRspBo umcSendTodoRspBo = UmcRu.success(UmcSendTodoRspBo.class);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUmcDealTransferTodoBoList())) {
            List<String> busiIdList = reqBo.getUmcDealTransferTodoBoList().stream().map(UmcDealTransferTodoBo::getBusiId).collect(Collectors.toList());
            List<String> candidateOperIdList = reqBo.getUmcDealTransferTodoBoList().stream().map(UmcDealTransferTodoBo::getOperUserId).collect(Collectors.toList());
            UmcTodoQryBo umcTodoQryBo = new UmcTodoQryBo();
            umcTodoQryBo.setBusiIdList(busiIdList);
            umcTodoQryBo.setCandidateOperIdList(candidateOperIdList);
            UmcTodoListDo umcTodoListDo = this.iUmcTodoModel.selectTodoList(umcTodoQryBo);
            if (!CollectionUtils.isEmpty((Collection)umcTodoListDo.getRows())) {
                Map userMap = new HashMap();
                UmcUserInfoQryBo umcUserInfoQryBo = new UmcUserInfoQryBo();
                ArrayList<Long> userIds = new ArrayList<Long>();
                for (UmcDealTransferTodoBo umcDealTransferTodoBo : reqBo.getUmcDealTransferTodoBoList()) {
                    userIds.add(Convert.toLong((Object)umcDealTransferTodoBo.getCandidateOperId()));
                    userIds.add(Convert.toLong((Object)umcDealTransferTodoBo.getOperUserId()));
                }
                umcUserInfoQryBo.setUserIdList(userIds);
                List umcUserInfoQryBoList = this.iUmcUserInfoModel.getUserOrgBaseInfoList(umcUserInfoQryBo).getRows();
                if (!CollectionUtils.isEmpty((Collection)umcUserInfoQryBoList)) {
                    userMap = umcUserInfoQryBoList.stream().collect(Collectors.toConcurrentMap(o -> o.getUserId().toString(), o -> o));
                }
                for (UmcDealTransferTodoBo umcDealTransferTodoBo : reqBo.getUmcDealTransferTodoBoList()) {
                    UmcUserInfoQryBo candidateOperBo = (UmcUserInfoQryBo)((Object)userMap.get(umcDealTransferTodoBo.getCandidateOperId()));
                    if (null != candidateOperBo) {
                        umcDealTransferTodoBo.setCandidateOperExtId(candidateOperBo.getExtCustId());
                        umcDealTransferTodoBo.setCandidateOperOrgId(Convert.toStr((Object)candidateOperBo.getOrgId()));
                        umcDealTransferTodoBo.setCandidateOperOrgExtId(candidateOperBo.getExtOrgId());
                        umcDealTransferTodoBo.setCandidateOperOrgName(candidateOperBo.getOrgName());
                    }
                    UmcTransferRspBo umcTransferRspBo = this.dealTransferTodo(umcDealTransferTodoBo);
                }
                if (this.transferTodoSyncEnable) {
                    // empty if block
                }
            }
        }
        return umcSendTodoRspBo;
    }

    private void val(UmcDealTransferTodoReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUmcDealTransferTodoBoList())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcDealTransferTodoBo umcDealTransferTodoBo : reqBo.getUmcDealTransferTodoBoList()) {
            if (StringUtils.isBlank((CharSequence)umcDealTransferTodoBo.getBusiId())) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)umcDealTransferTodoBo.getOperUserId())) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u64cd\u4f5c\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)umcDealTransferTodoBo.getOperUserName())) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)umcDealTransferTodoBo.getCandidateOperId())) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u5019\u9009\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((CharSequence)umcDealTransferTodoBo.getCandidateOperName())) continue;
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5019\u9009\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UmcTransferRspBo dealTransferTodo(UmcDealTransferTodoBo umcDealTransferTodoBo) {
        return this.iUmcTodoModel.updateCandidate(umcDealTransferTodoBo);
    }

    private void sendMq(UmcDealTransferTodoReqBo reqBO, UmcTodoListDo umcTodoListDo, Map<String, UmcUserInfoQryBo> userMap) {
        UmcTodoItemQryBo umcTodoItemQryBo = new UmcTodoItemQryBo();
        umcTodoItemQryBo.setTodoItemCodeList(umcTodoListDo.getUmcTodoDos().stream().map(UmcTodoDo::getTodoItemCode).collect(Collectors.toList()));
        UmcTodoItemPageRspBo umcTodoItemPageRspBo = this.iUmcTodoModel.selectTodoItemList(umcTodoItemQryBo);
        log.debug("umcTodoItemPageRspBo:{}", (Object)JSON.toJSONString((Object)((Object)umcTodoItemPageRspBo)));
        if (!CollectionUtils.isEmpty((Collection)umcTodoItemPageRspBo.getRows())) {
            Map<String, UmcTodoItem> todoItemMap = umcTodoItemPageRspBo.getRows().stream().collect(Collectors.toMap(UmcTodoItem::getTodoItemCode, o -> o, (o1, o2) -> o2));
            Map<String, List<UmcTodoDo>> itemCodeTodoListMap = umcTodoListDo.getRows().stream().collect(Collectors.groupingBy(UmcTodoDo::getTodoItemCode));
            Map<String, UmcDealTransferTodoBo> reqTodoMap = reqBO.getUmcDealTransferTodoBoList().stream().collect(Collectors.toMap(UmcDealTransferTodoBo::getBusiId, o -> o, (o1, o2) -> o2));
            for (UmcTodoItem umcTodoItem : umcTodoItemPageRspBo.getRows()) {
                List<UmcTodoDo> umcTodoDos;
                if (!"1".equals(umcTodoItem.getPushFlag()) || CollectionUtils.isEmpty(umcTodoDos = itemCodeTodoListMap.get(umcTodoItem.getTodoItemCode()))) continue;
                for (UmcTodoDo umcTodoDo : umcTodoDos) {
                }
            }
            reqTodoMap.forEach((busiId, umcDealTransferTodoBo) -> {});
        }
    }
}

