/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.service.enterprise.UmcModifyOrgTagService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcModifyOrgTagReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcModifyOrgTagRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcModifyOrgTagService"})
public class UmcModifyOrgTagServiceImpl
implements UmcModifyOrgTagService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"modifyOrgTag"})
    public UmcModifyOrgTagRspBo modifyOrgTag(@RequestBody UmcModifyOrgTagReqBo reqBo) {
        this.validParam(reqBo);
        UmcModifyOrgTagRspBo rspBo = UmcRu.success(UmcModifyOrgTagRspBo.class);
        UmcOrgInfoQryBo orgTagRelQryBo = new UmcOrgInfoQryBo();
        orgTagRelQryBo.setOrgId(reqBo.getOrgId());
        List<UmcOrgTagRel> orgTagRelSubDoList = this.iUmcEnterpriseInfoModel.getOrgInfo(orgTagRelQryBo).getOrgTagRelList();
        List<Object> orgTagIdList = new ArrayList();
        if (!CollectionUtils.isEmpty(orgTagRelSubDoList)) {
            orgTagIdList = orgTagRelSubDoList.stream().map(UmcOrgTagRel::getTagId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAddOrgTagList())) {
            ArrayList<UmcOrgTagRel> addTagList = new ArrayList<UmcOrgTagRel>(reqBo.getAddOrgTagList().size());
            UmcOrgInfo addReqBo = new UmcOrgInfo();
            for (Long addOrgTagId : reqBo.getAddOrgTagList()) {
                if (orgTagIdList.contains(addOrgTagId.toString())) continue;
                UmcOrgTagRel addOrgTagRel = new UmcOrgTagRel();
                addOrgTagRel.setOrgId(reqBo.getOrgId());
                addOrgTagRel.setTagId(addOrgTagId.toString());
                addOrgTagRel.setTagStatus("1");
                addOrgTagRel.setRelId(IdUtil.nextId());
                addOrgTagRel.setDelFlag("0");
                addOrgTagRel.setCreateOperId(reqBo.getUpdateOperId());
                addOrgTagRel.setCreateOperName(reqBo.getUpdateOperName());
                addOrgTagRel.setCreateTime(reqBo.getUpdateTime());
                addOrgTagRel.setUpdateOperId(reqBo.getUpdateOperId());
                addOrgTagRel.setUpdateOperName(reqBo.getUpdateOperName());
                addOrgTagRel.setUpdateTime(reqBo.getUpdateTime());
                addTagList.add(addOrgTagRel);
            }
            addReqBo.setOrgTagRelList(addTagList);
            this.iUmcEnterpriseInfoModel.createOrgTagIdRel(addReqBo);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getDeleteOrgTagList())) {
            for (Long deleteOrgTagId : reqBo.getDeleteOrgTagList()) {
                if (!orgTagIdList.contains(deleteOrgTagId.toString())) continue;
                UmcOrgTagRel deleteOrgTagRel = new UmcOrgTagRel();
                deleteOrgTagRel.setUpdateOperId(reqBo.getUpdateOperId());
                deleteOrgTagRel.setUpdateOperName(reqBo.getUpdateOperName());
                deleteOrgTagRel.setUpdateTime(reqBo.getUpdateTime());
                deleteOrgTagRel.setDelFlag("1");
                deleteOrgTagRel.setTagId(deleteOrgTagId.toString());
                deleteOrgTagRel.setOrgId(reqBo.getOrgId());
                this.iUmcEnterpriseInfoModel.updateOrgTagIdRel(deleteOrgTagRel);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getStopOrgTagList())) {
            for (Long stopOrgTagId : reqBo.getStopOrgTagList()) {
                if (!orgTagIdList.contains(stopOrgTagId.toString())) continue;
                UmcOrgTagRel stopOrgTagRel = new UmcOrgTagRel();
                stopOrgTagRel.setUpdateOperId(reqBo.getUpdateOperId());
                stopOrgTagRel.setUpdateOperName(reqBo.getUpdateOperName());
                stopOrgTagRel.setUpdateTime(reqBo.getUpdateTime());
                stopOrgTagRel.setTagStatus("0");
                stopOrgTagRel.setTagId(stopOrgTagId.toString());
                stopOrgTagRel.setOrgId(reqBo.getOrgId());
                this.iUmcEnterpriseInfoModel.updateOrgTagIdRel(stopOrgTagRel);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getStartOrgTagList())) {
            for (Long startOrgTagId : reqBo.getStartOrgTagList()) {
                if (!orgTagIdList.contains(startOrgTagId.toString())) continue;
                UmcOrgTagRel startOrgTagRel = new UmcOrgTagRel();
                startOrgTagRel.setUpdateOperId(reqBo.getUpdateOperId());
                startOrgTagRel.setUpdateOperName(reqBo.getUpdateOperName());
                startOrgTagRel.setUpdateTime(reqBo.getUpdateTime());
                startOrgTagRel.setTagStatus("1");
                startOrgTagRel.setTagId(startOrgTagId.toString());
                startOrgTagRel.setOrgId(reqBo.getOrgId());
                this.iUmcEnterpriseInfoModel.updateOrgTagIdRel(startOrgTagRel);
            }
        }
        return rspBo;
    }

    private void validParam(UmcModifyOrgTagReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

