/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryRspBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoRspBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.service.enterprise.UmcQryOrgDropDownTreeService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcDropDownTreeBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcParentOrgInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgDropDownTreeReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgDropDownTreeRspBO;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcQryOrgDropDownTreeService"})
public class UmcQryOrgDropDownTreeServiceImpl
implements UmcQryOrgDropDownTreeService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"qryOrgDropDownTree"})
    public UmcQryOrgDropDownTreeRspBO qryOrgDropDownTree(@RequestBody UmcQryOrgDropDownTreeReqBO reqBO) {
        UmcQryOrgDropDownTreeRspBO rspBO = UmcRu.success(UmcQryOrgDropDownTreeRspBO.class);
        UmcEnterpriseOrgQryBo enterpriseOrgQryBo = UmcRu.js(reqBO, UmcEnterpriseOrgQryBo.class);
        StrUtil.noNullStringAttr(enterpriseOrgQryBo);
        UmcEnterpriseOrgQryRspBo umcEnterpriseOrgQryRspBo = this.iUmcEnterpriseInfoModel.qryOrgDropDownTree(enterpriseOrgQryBo);
        if (CollectionUtils.isEmpty((Collection)umcEnterpriseOrgQryRspBo.getRows())) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        Map<Long, String> orgIdToNameMap = this.packagingOrgIdToNameMap(umcEnterpriseOrgQryRspBo.getRows());
        List rows = umcEnterpriseOrgQryRspBo.getRows().stream().map(row -> {
            UmcDropDownTreeBO treeBO = UmcRu.js(row, UmcDropDownTreeBO.class);
            if (row.getIsParent() > 0) {
                treeBO.setIsParentOrg("1");
            } else {
                treeBO.setIsParentOrg("0");
            }
            this.packagingParentOrgInfoList(treeBO, orgIdToNameMap);
            return treeBO;
        }).collect(Collectors.toList());
        rspBO.setRows(rows);
        return rspBO;
    }

    public void packagingParentOrgInfoList(UmcDropDownTreeBO treeBO, Map<Long, String> orgIdToNameMap) {
        if (!CollectionUtils.isEmpty(orgIdToNameMap)) {
            ArrayList<UmcParentOrgInfoBo> parentOrgInfoBoList = new ArrayList<UmcParentOrgInfoBo>(10);
            String[] arr = treeBO.getOrgTreePath().split("-");
            ArrayList<String> orgIds = new ArrayList<String>(Arrays.asList(arr));
            for (String orgId : orgIds) {
                if (Long.parseLong(orgId) == 1L || !ObjectUtil.isNotEmpty((Object)orgIdToNameMap.get(Long.valueOf(orgId)))) continue;
                UmcParentOrgInfoBo umcParentOrgInfoBo = new UmcParentOrgInfoBo();
                umcParentOrgInfoBo.setOrgId(Long.valueOf(orgId));
                umcParentOrgInfoBo.setOrgName(orgIdToNameMap.get(Long.valueOf(orgId)));
                parentOrgInfoBoList.add(umcParentOrgInfoBo);
            }
            treeBO.setParentOrgInfoBoList(parentOrgInfoBoList);
        }
    }

    public Map<Long, String> packagingOrgIdToNameMap(List<UmcEnterpriseInfoDo> umcEnterpriseInfoDoList) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (UmcEnterpriseInfoDo umcEnterpriseInfoDo : umcEnterpriseInfoDoList) {
            String[] arr;
            for (String s : arr = umcEnterpriseInfoDo.getOrgTreePath().split("-")) {
                if (umcEnterpriseInfoDo.getOrgId().equals(Long.valueOf(s)) || orgIds.contains(Long.valueOf(s))) continue;
                orgIds.add(Long.valueOf(s));
            }
        }
        Map<Long, String> orgIdToNameMap = new HashMap<Long, String>(10);
        if (!CollectionUtils.isEmpty(orgIds)) {
            UmcEnterpriseInfoDo umcEnterpriseInfoDo;
            umcEnterpriseInfoDo = new UmcEnterpriseInfoDo();
            umcEnterpriseInfoDo.setOrgIds(orgIds);
            UmcOrgInfoRspBo umcOrgInfoRspBo = this.iUmcEnterpriseInfoModel.batchQueryOrgInfoListByOrgIds(umcEnterpriseInfoDo);
            if (!CollectionUtils.isEmpty((Collection)umcOrgInfoRspBo.getRows())) {
                orgIdToNameMap = umcOrgInfoRspBo.getRows().stream().filter(umcOrgInfo -> ObjectUtil.isNotEmpty((Object)umcOrgInfo.getOrgName())).collect(Collectors.toMap(UmcOrgInfo::getOrgId, UmcOrgInfo::getOrgName, (key1, key2) -> key2));
            }
        }
        return orgIdToNameMap;
    }
}

