/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.invoiceaddress;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.invoiceaddress.IUmcInvoiceAddressModel;
import com.tydic.dyc.umc.model.invoiceaddress.UmcInvoiceAddressDo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressListRspBo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressQryBo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.invoiceaddress.UmcQryInvoiceAddressListPageService;
import com.tydic.dyc.umc.service.invoiceaddress.bo.UmcInvoiceAddressBo;
import com.tydic.dyc.umc.service.invoiceaddress.bo.UmcQryInvoiceAddressListPageReqBo;
import com.tydic.dyc.umc.service.invoiceaddress.bo.UmcQryInvoiceAddressListPageRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.invoiceaddress.UmcQryInvoiceAddressListPageService"})
public class UmcQryInvoiceAddressListPageServiceImpl
implements UmcQryInvoiceAddressListPageService {
    private static final Logger log = LoggerFactory.getLogger(UmcQryInvoiceAddressListPageServiceImpl.class);
    @Autowired
    private IUmcInvoiceAddressModel iUmcInvoiceAddressModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"qryInvoiceAddressListPage"})
    public UmcQryInvoiceAddressListPageRspBo qryInvoiceAddressListPage(@RequestBody UmcQryInvoiceAddressListPageReqBo reqBo) {
        UmcInvoiceAddressListRspBo invoiceAddressPageList;
        UmcQryInvoiceAddressListPageRspBo rspBo = UmcRu.success(UmcQryInvoiceAddressListPageRspBo.class);
        UmcInvoiceAddressQryBo qryBo = StrUtil.noNullStringAttr(UmcRu.js(reqBo, UmcInvoiceAddressQryBo.class));
        qryBo.setOrgId(reqBo.getOrgIdWeb());
        if (CollectionUtils.isEmpty((Collection)reqBo.getMgOrgIdsIn())) {
            // empty if block
        }
        qryBo.setCompanyOrgId(reqBo.getCompanyOrgIdWeb());
        if (!CollectionUtils.isEmpty((Collection)reqBo.getMgOrgIdsIn())) {
            qryBo.setOrgPathWeb(null);
        }
        qryBo.setOrderBy("a.MAIN_FLAG DESC,a.create_time DESC ");
        qryBo.setCompanyName(null);
        qryBo.setName(reqBo.getContactNameWeb());
        if (null != reqBo.getCompanyOrgIdWeb()) {
            reqBo.setMgOrgIdsIn(null);
            qryBo.setMgOrgIdsIn(null);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBo.getCreateNo())) {
            qryBo.setCreateOperId(Long.parseLong(reqBo.getCreateNo()));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBo.getCreateName())) {
            qryBo.setCreateOperName(reqBo.getCreateName());
        }
        try {
            if (!StringUtils.isEmpty((Object)reqBo.getCreateStartTime())) {
                qryBo.setCreateTimeStart(new Date(reqBo.getCreateStartTime()));
            }
            if (!StringUtils.isEmpty((Object)reqBo.getCreateEndTime())) {
                qryBo.setCreateTimeEnd(new Date(reqBo.getCreateEndTime()));
            }
            if (!StringUtils.isEmpty((Object)reqBo.getOperateStartTime())) {
                qryBo.setUpdateTimeStart(new Date(reqBo.getOperateStartTime()));
            }
            if (!StringUtils.isEmpty((Object)reqBo.getOperateEndTime())) {
                qryBo.setUpdateTimeEnd(new Date(reqBo.getOperateEndTime()));
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38", (Throwable)e);
            throw new BaseBusinessException("200100", "\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBo.getOperateName())) {
            qryBo.setUpdateOperName(reqBo.getOperateName());
        }
        if (ObjectUtil.isEmpty((Object)(invoiceAddressPageList = this.iUmcInvoiceAddressModel.getInvoiceAddressPageList(qryBo)).getRows())) {
            rspBo.setRows(new ArrayList(0));
        }
        if (!CollectionUtils.isEmpty((Collection)invoiceAddressPageList.getRows())) {
            Map<String, String> statusStrMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "INVOICE_ADDRESS_STATUS")).getMap();
            Map<Object, Object> umcOrgInfoMap = new HashMap();
            UmcOrgInfoQryBo umcOrgInfoQryBo = new UmcOrgInfoQryBo();
            umcOrgInfoQryBo.setOrgIds(invoiceAddressPageList.getRows().stream().map(UmcInvoiceAddressDo::getCompanyOrgId).collect(Collectors.toList()));
            List umcOrgInfoList = this.iUmcEnterpriseInfoModel.getOrgInfoList(umcOrgInfoQryBo).getRows();
            if (!CollectionUtils.isEmpty((Collection)umcOrgInfoList)) {
                umcOrgInfoMap = umcOrgInfoList.stream().collect(Collectors.toMap(UmcOrgInfo::getOrgId, UmcOrgInfo::getOrgName));
            }
            ArrayList<UmcInvoiceAddressBo> umcInvoiceAddressBoList = new ArrayList<UmcInvoiceAddressBo>();
            for (UmcInvoiceAddressDo bo : invoiceAddressPageList.getRows()) {
                UmcInvoiceAddressBo rspbo = UmcRu.js(bo, UmcInvoiceAddressBo.class);
                rspbo.setContactNameWeb(bo.getName());
                rspbo.setCreateName(bo.getCreateOperName());
                rspbo.setOperateTime(bo.getUpdateTime());
                rspbo.setOperateName(bo.getUpdateOperName());
                rspbo.setStatus(bo.getAddrStatus());
                rspbo.setStatusStr(statusStrMap.get(rspbo.getStatus()));
                rspbo.setId(bo.getInvoiceAddrId());
                rspbo.setRegion(this.getRegion(rspbo));
                if (null != bo.getOrgId()) {
                    rspbo.setCompanyName((String)umcOrgInfoMap.get(bo.getCompanyOrgId()));
                }
                umcInvoiceAddressBoList.add(rspbo);
            }
            rspBo.setRows(umcInvoiceAddressBoList);
        }
        rspBo.setRecordsTotal(invoiceAddressPageList.getRecordsTotal());
        rspBo.setPageNo(invoiceAddressPageList.getPageNo());
        rspBo.setTotal(invoiceAddressPageList.getTotal());
        rspBo.setRespCode(invoiceAddressPageList.getRespCode());
        rspBo.setRespDesc(invoiceAddressPageList.getRespDesc());
        return rspBo;
    }

    private String getRegion(UmcInvoiceAddressBo rspbo) {
        StringBuilder sb = new StringBuilder();
        if (rspbo.getAreaName() != null) {
            sb.append(rspbo.getAreaName());
        }
        if (rspbo.getCityName() != null) {
            sb.append(rspbo.getCityName());
        }
        if (rspbo.getCountyName() != null) {
            sb.append(rspbo.getCountyName());
        }
        if (rspbo.getTownName() != null) {
            sb.append(rspbo.getTownName());
        }
        if (rspbo.getAddrDesc() != null) {
            sb.append(rspbo.getAddrDesc());
        }
        return sb.toString();
    }
}

