/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.coordinate;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.umc.model.coordinate.UmcCoordinateModel;
import com.tydic.dyc.umc.model.coordinate.qrybo.UmcCoordinateQryBO;
import com.tydic.dyc.umc.model.coordinate.sub.UmcCoordinate;
import com.tydic.dyc.umc.service.coordinate.UmcHandleCoordinateService;
import com.tydic.dyc.umc.service.coordinate.bo.UmcHandleCoordinateReqBO;
import com.tydic.dyc.umc.service.coordinate.bo.UmcHandleCoordinateRspBO;
import com.tydic.dyc.umc.utils.UmcRu;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.coordinate.UmcHandleCoordinateService"})
public class UmcHandleCoordinateServiceImpl
implements UmcHandleCoordinateService {
    @Autowired
    private UmcCoordinateModel umcCoordinateModel;

    @PostMapping(value={"handleCoordinate"})
    public UmcHandleCoordinateRspBO handleCoordinate(@RequestBody UmcHandleCoordinateReqBO reqBO) {
        this.checkParam(reqBO);
        UmcCoordinate model = this.getModel(reqBO);
        if (model == null) {
            this.insert(reqBO);
        } else {
            this.update(reqBO);
        }
        return UmcRu.success(UmcHandleCoordinateRspBO.class);
    }

    private void insert(UmcHandleCoordinateReqBO reqBO) {
        UmcCoordinate umcCoordinate = UmcRu.js(reqBO, UmcCoordinate.class);
        umcCoordinate.setCreateUserId(reqBO.getUserId());
        umcCoordinate.setCreateUserCode(reqBO.getUserCode());
        this.umcCoordinateModel.insert(umcCoordinate);
    }

    private void update(UmcHandleCoordinateReqBO reqBO) {
        UmcCoordinate set = UmcRu.js(reqBO, UmcCoordinate.class);
        set.setUpdateUserId(reqBO.getUserId());
        set.setUpdateUserCode(reqBO.getUserCode());
        UmcCoordinateQryBO where = new UmcCoordinateQryBO();
        where.setClassCode(reqBO.getClassCode());
        where.setCreateUserId(reqBO.getUserId());
        this.umcCoordinateModel.update(set, where);
    }

    private UmcCoordinate getModel(UmcHandleCoordinateReqBO reqBO) {
        UmcCoordinateQryBO umcCoordinateQryBO = new UmcCoordinateQryBO();
        umcCoordinateQryBO.setCreateUserId(reqBO.getUserId());
        umcCoordinateQryBO.setClassCode(reqBO.getClassCode());
        return this.umcCoordinateModel.getModel(umcCoordinateQryBO);
    }

    private void checkParam(UmcHandleCoordinateReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getXCoordinate())) {
            throw new ZTBusinessException("\u6a2a\u5750\u6807\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getYCoordinate())) {
            throw new ZTBusinessException("\u7eb5\u5750\u6807\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getClassCode())) {
            throw new ZTBusinessException("\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getHigh())) {
            throw new ZTBusinessException("\u9ad8\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getWeight())) {
            throw new ZTBusinessException("\u5bbd\u4e3a\u7a7a");
        }
        if (reqBO.getUserId() == null) {
            throw new ZTBusinessException("\u64cd\u4f5c\u4ebaid\u4e3a\u7a7a");
        }
    }
}

