/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.model.authapplication.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.umc.model.authapplication.AuthApplicationModel;
import com.tydic.dyc.umc.model.authapplication.bo.AuthApplicationDO;
import com.tydic.dyc.umc.model.authapplication.bo.AuthApplicationInfo;
import com.tydic.dyc.umc.model.authapplication.bo.AuthFileInfoDO;
import com.tydic.dyc.umc.model.authapplication.bo.AuthFileInfoInfo;
import com.tydic.dyc.umc.model.authapplication.bo.AuthUserInfoDO;
import com.tydic.dyc.umc.model.authapplication.bo.AuthUserInfoInfo;
import com.tydic.dyc.umc.repository.AuthApplicationRepository;
import com.tydic.dyc.umc.repository.AuthFileInfoRepository;
import com.tydic.dyc.umc.repository.AuthUserInfoRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthApplicationModelImpl
implements AuthApplicationModel {
    @Autowired
    private AuthApplicationRepository authApplicationRepository;
    @Autowired
    private AuthUserInfoRepository authUserInfoRepository;
    @Autowired
    private AuthFileInfoRepository authFileInfoRepository;

    @Override
    public AuthApplicationInfo queryAuthApplicationSingle(AuthApplicationDO reqBO) {
        AuthApplicationInfo rspBO = this.authApplicationRepository.queryAuthApplicationSingle(reqBO);
        if (rspBO != null) {
            AuthFileInfoDO infoDO = new AuthFileInfoDO();
            infoDO.setObjId(rspBO.getAuthId());
            List<AuthFileInfoInfo> fileInfoList = this.authFileInfoRepository.queryAuthFileInfoList(infoDO);
            rspBO.setFileList(fileInfoList);
        }
        return rspBO;
    }

    @Override
    public BasePageRspBo<AuthApplicationInfo> queryAuthApplicationListPage(AuthApplicationDO reqBO) {
        return this.authApplicationRepository.queryAuthApplicationListPage(reqBO);
    }

    @Override
    public AuthApplicationInfo addAuthApplication(AuthApplicationDO reqBO) {
        return this.authApplicationRepository.addAuthApplication(reqBO);
    }

    @Override
    public int updateAuthApplication(AuthApplicationDO reqBO) {
        int i = this.authApplicationRepository.updateAuthApplication(reqBO);
        if (CollectionUtil.isNotEmpty(reqBO.getFileList())) {
            reqBO.getFileList().forEach(fileInfo -> fileInfo.setObjId(reqBO.getAuthId()));
            this.authFileInfoRepository.addBatchAuthFileInfo(reqBO.getFileList());
        }
        return i;
    }

    @Override
    public BasePageRspBo<AuthUserInfoInfo> queryAuthUserInfoListPage(AuthUserInfoDO reqBO) {
        return this.authUserInfoRepository.queryAuthUserInfoListPage(reqBO);
    }

    @Override
    public int addBatchAuthUserInfo(List<AuthUserInfoDO> reqBO) {
        return this.authUserInfoRepository.addBatchAuthUserInfo(reqBO);
    }

    @Override
    public int deleteAuthUserInfo(AuthUserInfoDO reqBO) {
        return this.authUserInfoRepository.deleteAuthUserInfo(reqBO);
    }
}

