/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.config;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcInquiryConfigConstant;
import com.tydic.dyc.umc.model.config.sub.UmcOrgPublicDicConfigExt;
import com.tydic.dyc.umc.model.orgpublicdicConfig.IUmcOrgPublicDicConfigModel;
import com.tydic.dyc.umc.model.orgpublicdicConfig.UmcOrgPublicDicConfigDo;
import com.tydic.dyc.umc.model.orgpublicdicConfig.sub.UmcOrgPublicDicConfigExtBo;
import com.tydic.dyc.umc.service.config.UmcModifyInquiryRuleConfigService;
import com.tydic.dyc.umc.service.config.bo.UmcModifyInquiryRuleConfigReqBO;
import com.tydic.dyc.umc.service.config.bo.UmcModifyInquiryRuleConfigRspBO;
import com.tydic.dyc.umc.service.config.bo.UmcSelectedRuleBO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.config.UmcModifyInquiryRuleConfigService"})
public class UmcModifyInquiryRuleConfigServiceImpl
implements UmcModifyInquiryRuleConfigService {
    @Autowired
    private IUmcOrgPublicDicConfigModel iUmcOrgPublicDicConfigModel;

    @PostMapping(value={"modifyInquiryRuleConfig"})
    public UmcModifyInquiryRuleConfigRspBO modifyInquiryRuleConfig(@RequestBody UmcModifyInquiryRuleConfigReqBO reqBO) {
        this.valData(reqBO);
        this.modifyInquiryConfig(reqBO);
        this.modifySelectedConfig(reqBO);
        return UmcRu.success(UmcModifyInquiryRuleConfigRspBO.class);
    }

    private void modifySelectedConfig(UmcModifyInquiryRuleConfigReqBO reqBO) {
        UmcOrgPublicDicConfigExt delSelectedRuleBO = new UmcOrgPublicDicConfigExt();
        delSelectedRuleBO.setConfigId(reqBO.getSelectedRuleConfigId());
        this.iUmcOrgPublicDicConfigModel.deleteConfExtByConfigId(delSelectedRuleBO);
        UmcOrgPublicDicConfigDo addSelectedRuleBO = new UmcOrgPublicDicConfigDo();
        ArrayList<UmcOrgPublicDicConfigExtBo> dicList = new ArrayList<UmcOrgPublicDicConfigExtBo>();
        for (UmcSelectedRuleBO selectedRuleBO : reqBO.getSelectedRuleBOList()) {
            UmcOrgPublicDicConfigExtBo selectedBO = new UmcOrgPublicDicConfigExtBo();
            selectedBO.setId(IdUtil.nextId());
            selectedBO.setConfigId(reqBO.getSelectedRuleConfigId());
            selectedBO.setDicCode(selectedRuleBO.getValidQuotationNum() + "");
            selectedBO.setDicName(UmcInquiryConfigConstant.ConfigExt.CONFIG_SELECTED.getName());
            selectedBO.setDicValue(selectedRuleBO.getSelectedNum() + "");
            dicList.add(selectedBO);
        }
        addSelectedRuleBO.setDicList(dicList);
        this.iUmcOrgPublicDicConfigModel.addUmcOrgPublicDicConfigExt(addSelectedRuleBO);
    }

    private void modifyInquiryConfig(UmcModifyInquiryRuleConfigReqBO reqBO) {
        UmcOrgPublicDicConfigExt delInquiryRuleBO = new UmcOrgPublicDicConfigExt();
        delInquiryRuleBO.setConfigId(reqBO.getInquiryRuleBO().getConfigId());
        this.iUmcOrgPublicDicConfigModel.deleteConfExtByConfigId(delInquiryRuleBO);
        UmcOrgPublicDicConfigDo addInquiryRuleBO = new UmcOrgPublicDicConfigDo();
        ArrayList<UmcOrgPublicDicConfigExtBo> dicList = new ArrayList<UmcOrgPublicDicConfigExtBo>();
        UmcOrgPublicDicConfigExtBo configTypeBO = new UmcOrgPublicDicConfigExtBo();
        configTypeBO.setId(IdUtil.nextId());
        configTypeBO.setConfigId(reqBO.getInquiryRuleBO().getConfigId());
        configTypeBO.setDicCode(UmcInquiryConfigConstant.ConfigExt.CONFIG_TYPE.getCode());
        configTypeBO.setDicName(UmcInquiryConfigConstant.ConfigExt.CONFIG_TYPE.getName());
        configTypeBO.setDicValue(reqBO.getInquiryRuleBO().getConfigType());
        dicList.add(configTypeBO);
        UmcOrgPublicDicConfigExtBo configTimeBO = new UmcOrgPublicDicConfigExtBo();
        configTimeBO.setId(IdUtil.nextId());
        configTimeBO.setConfigId(reqBO.getInquiryRuleBO().getConfigId());
        configTimeBO.setDicCode(UmcInquiryConfigConstant.ConfigExt.TYPE_TIME.getCode());
        configTimeBO.setDicName(UmcInquiryConfigConstant.ConfigExt.TYPE_TIME.getName());
        configTimeBO.setDicValue(reqBO.getInquiryRuleBO().getConfigTime());
        dicList.add(configTimeBO);
        if ("WEEK".equals(reqBO.getInquiryRuleBO().getConfigType())) {
            UmcOrgPublicDicConfigExtBo configWeekBO = new UmcOrgPublicDicConfigExtBo();
            configWeekBO.setId(IdUtil.nextId());
            configWeekBO.setConfigId(reqBO.getInquiryRuleBO().getConfigId());
            configWeekBO.setDicCode(UmcInquiryConfigConstant.ConfigExt.TYPE_WEEK.getCode());
            configWeekBO.setDicName(UmcInquiryConfigConstant.ConfigExt.TYPE_WEEK.getName());
            configWeekBO.setDicValue(reqBO.getInquiryRuleBO().getConfigWeek());
            dicList.add(configWeekBO);
        }
        if ("MONTH".equals(reqBO.getInquiryRuleBO().getConfigType())) {
            UmcOrgPublicDicConfigExtBo configMonthBO = new UmcOrgPublicDicConfigExtBo();
            configMonthBO.setId(IdUtil.nextId());
            configMonthBO.setConfigId(reqBO.getInquiryRuleBO().getConfigId());
            configMonthBO.setDicCode(UmcInquiryConfigConstant.ConfigExt.TYPE_MONTH.getCode());
            configMonthBO.setDicName(UmcInquiryConfigConstant.ConfigExt.TYPE_MONTH.getName());
            configMonthBO.setDicValue(reqBO.getInquiryRuleBO().getConfigMonth());
            dicList.add(configMonthBO);
        }
        addInquiryRuleBO.setDicList(dicList);
        this.iUmcOrgPublicDicConfigModel.addUmcOrgPublicDicConfigExt(addInquiryRuleBO);
    }

    private void valData(UmcModifyInquiryRuleConfigReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u4fee\u6539\u8be2\u4ef7\u89c4\u5219\u914d\u7f6e\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getInquiryRuleBO())) {
            throw new BaseBusinessException("200001", "\u4fee\u6539\u8be2\u4ef7\u89c4\u5219\u914d\u7f6e\u5165\u53c2\u8be2\u4ef7\u89c4\u5219[inquiryRuleBO]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getInquiryRuleBO().getConfigId())) {
            throw new BaseBusinessException("200001", "\u4fee\u6539\u8be2\u4ef7\u89c4\u5219\u914d\u7f6e\u5165\u53c2\u8be2\u4ef7\u89c4\u5219ID[inquiryRuleBO.configId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getInquiryRuleBO().getConfigType())) {
            throw new BaseBusinessException("200001", "\u4fee\u6539\u8be2\u4ef7\u89c4\u5219\u914d\u7f6e\u5165\u53c2\u8be2\u4ef7\u89c4\u5219\u7c7b\u578b[inquiryRuleBO.configType]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getInquiryRuleBO().getConfigTime())) {
            throw new BaseBusinessException("200001", "\u4fee\u6539\u8be2\u4ef7\u89c4\u5219\u914d\u7f6e\u5165\u53c2\u8be2\u4ef7\u89c4\u5219-\u65f6\u95f4[inquiryRuleBO.configTime]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSelectedRuleConfigId())) {
            throw new BaseBusinessException("200001", "\u4fee\u6539\u8be2\u4ef7\u89c4\u5219\u914d\u7f6e\u5165\u53c2\u4e2d\u9009\u89c4\u5219\u914d\u7f6eID[selectedRuleConfigId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSelectedRuleBOList())) {
            throw new BaseBusinessException("200001", "\u4fee\u6539\u8be2\u4ef7\u89c4\u5219\u914d\u7f6e\u5165\u53c2\u4e2d\u9009\u89c4\u5219\u96c6\u5408[selectedRuleBOList]\u4e3a\u7a7a");
        }
    }
}

