/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.config;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.config.IUmcConfigModel;
import com.tydic.dyc.umc.model.config.qrybo.UmcConfTabOrdStateQryBo;
import com.tydic.dyc.umc.model.config.qrybo.UmcConfTabOrdStateQryRspBo;
import com.tydic.dyc.umc.model.config.qrybo.UmcTacheButtonQryBo;
import com.tydic.dyc.umc.model.config.qrybo.UmcTacheButtonQryRspBo;
import com.tydic.dyc.umc.model.config.sub.UmcTacheButton;
import com.tydic.dyc.umc.service.config.UmcQryTabBtnConfService;
import com.tydic.dyc.umc.service.config.bo.UmcQryTabBtnConfBo;
import com.tydic.dyc.umc.service.config.bo.UmcQryTabBtnConfMapBo;
import com.tydic.dyc.umc.service.config.bo.UmcQryTabBtnConfReqBo;
import com.tydic.dyc.umc.service.config.bo.UmcQryTabBtnConfRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.config.UmcQryTabBtnConfService"})
public class UmcQryTabBtnConfServiceImpl
implements UmcQryTabBtnConfService {
    private static final Logger log = LoggerFactory.getLogger(UmcQryTabBtnConfServiceImpl.class);
    @Autowired
    private IUmcConfigModel iUmcConfigModel;
    private static final String TAB_ORDER_BY = "center, menu_code, sort";

    @PostMapping(value={"qryTabBtnConf"})
    public UmcQryTabBtnConfRspBo qryTabBtnConf(@RequestBody UmcQryTabBtnConfReqBo reqBo) {
        this.val(reqBo);
        UmcQryTabBtnConfRspBo umcQryTabBtnConfRspBo = UmcRu.success(UmcQryTabBtnConfRspBo.class);
        List<String> menuCodeList = reqBo.getMenuCodeList().stream().distinct().collect(Collectors.toList());
        UmcConfTabOrdStateQryBo umcConfTabOrdStateQryBo = new UmcConfTabOrdStateQryBo();
        umcConfTabOrdStateQryBo.setMenuCodeList(menuCodeList);
        umcConfTabOrdStateQryBo.setOrderBy(TAB_ORDER_BY);
        UmcConfTabOrdStateQryRspBo umcConfTabOrdStateQryRspBo = this.iUmcConfigModel.qryConfTabOrdStateList(umcConfTabOrdStateQryBo);
        if (!CollectionUtils.isEmpty(umcConfTabOrdStateQryRspBo.getUmcConfTabOrdStates())) {
            UmcTacheButtonQryBo umcTacheButtonQryBo = new UmcTacheButtonQryBo();
            umcTacheButtonQryBo.setMenuCodeList(menuCodeList);
            UmcTacheButtonQryRspBo umcTacheButtonQryRspBo = this.iUmcConfigModel.qryTacheButtonByMenuCode(umcTacheButtonQryBo);
            if (!CollectionUtils.isEmpty(umcTacheButtonQryRspBo.getUmcTacheButtonList())) {
                HashMap umcTacheButtonMap = new HashMap();
                umcTacheButtonQryRspBo.getUmcTacheButtonList().forEach(umcTacheButton -> {
                    String key = umcTacheButton.getCenter() + umcTacheButton.getTabId();
                    ArrayList<UmcTacheButton> umcTacheButtonList = (ArrayList<UmcTacheButton>)umcTacheButtonMap.get(key);
                    if (CollectionUtils.isEmpty((Collection)umcTacheButtonList)) {
                        umcTacheButtonList = new ArrayList<UmcTacheButton>();
                        umcTacheButtonMap.put(key, umcTacheButtonList);
                    }
                    umcTacheButtonList.add((UmcTacheButton)umcTacheButton);
                });
                umcConfTabOrdStateQryRspBo.getUmcConfTabOrdStates().forEach(umcConfTabOrdState -> umcConfTabOrdState.setUmcTacheButtonList((List)umcTacheButtonMap.get(umcConfTabOrdState.getCenter() + umcConfTabOrdState.getTabId())));
            }
            HashMap<String, List> umcConfTabMap = new HashMap<String, List>();
            umcConfTabOrdStateQryRspBo.getUmcConfTabOrdStates().forEach(umcConfTabOrdState -> {
                ArrayList<UmcQryTabBtnConfBo> umcQryTabBtnConfBos = (ArrayList<UmcQryTabBtnConfBo>)umcConfTabMap.get(umcConfTabOrdState.getMenuCode());
                if (CollectionUtils.isEmpty((Collection)umcQryTabBtnConfBos)) {
                    umcQryTabBtnConfBos = new ArrayList<UmcQryTabBtnConfBo>();
                    umcConfTabMap.put(umcConfTabOrdState.getMenuCode(), umcQryTabBtnConfBos);
                }
                umcQryTabBtnConfBos.add(UmcRu.js(umcConfTabOrdState, UmcQryTabBtnConfBo.class));
            });
            ArrayList umcQryTabBtnConfMapBoList = new ArrayList();
            if (!CollectionUtils.isEmpty(umcConfTabMap)) {
                umcConfTabMap.forEach((menuCode, umcQryTabBtnConfBos) -> {
                    UmcQryTabBtnConfMapBo umcQryTabBtnConfMapBo = new UmcQryTabBtnConfMapBo();
                    umcQryTabBtnConfMapBo.setMenuCode(menuCode);
                    umcQryTabBtnConfMapBo.setUmcQryTabBtnConfBos(umcQryTabBtnConfBos);
                    umcQryTabBtnConfMapBoList.add(umcQryTabBtnConfMapBo);
                });
            }
            umcQryTabBtnConfRspBo.setUmcQryTabBtnConfMapBoList(umcQryTabBtnConfMapBoList);
        }
        return umcQryTabBtnConfRspBo;
    }

    private void val(UmcQryTabBtnConfReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getMenuCodeList())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a");
        }
    }
}

