/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycUocOrderCallFunction;
import com.tydic.dyc.atom.busicommon.bo.DycUocOrderCallFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocOrderCallFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.GeminiReceiverBO;
import com.tydic.dyc.atom.busicommon.bo.GeminiSendFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.GeminiSendFuncRspBo;
import com.tydic.dyc.authority.service.user.AuthGetUserByRoleAndOrgService;
import com.tydic.dyc.authority.service.user.bo.AuthByRoleAndOrgQryUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgRspBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.dyc.umc.service.user.UmcMemberQryListPageService;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycUocOrderCallFunctionImpl
implements DycUocOrderCallFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocOrderCallFunctionImpl.class);
    @Autowired
    private UocGetSaleOrderDetailService uocGetSaleOrderDetailService;
    @Autowired
    private UmcMemberQryListPageService umcMemberQryListPageAbilityService;
    @Autowired
    private AuthGetUserByRoleAndOrgService authGetUserByRoleAndOrgService;
    @Value(value="${geminiSendUrl}")
    private String geminiSendUrl;

    @Override
    public DycUocOrderCallFuncRspBO orderCall(DycUocOrderCallFuncReqBO reqBO) {
        UocGetSaleOrderDetailServiceReqBo saleOrderDetailReqBo = (UocGetSaleOrderDetailServiceReqBo)JUtil.js((Object)((Object)reqBO), UocGetSaleOrderDetailServiceReqBo.class);
        log.info("\u67e5\u8be2\u9500\u552e\u5355\u8be6\u60c5\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderDetailReqBo));
        UocGetSaleOrderDetailServiceRspBo saleOrderDetailRspBo = this.uocGetSaleOrderDetailService.getSaleOrderDetail(saleOrderDetailReqBo);
        log.info("\u67e5\u8be2\u9500\u552e\u5355\u8be6\u60c5\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderDetailRspBo));
        if (!"0000".equals(saleOrderDetailRspBo.getRespCode())) {
            throw new ZTBusinessException("\u5f02\u5e38\u7f16\u7801\u3010" + saleOrderDetailRspBo.getRespCode() + "\u3011," + saleOrderDetailRspBo.getRespDesc());
        }
        if (saleOrderDetailRspBo.getOrderId() == null) {
            throw new ZTBusinessException("\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (saleOrderDetailRspBo.getUocGetSaleOrderDetailServiceRspStakeholderBo() == null) {
            throw new ZTBusinessException("\u4e09\u65b9\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        GeminiSendFuncReqBo geminiSendFuncReqBo = this.combGeminiSendAbilityReqBO(reqBO, saleOrderDetailRspBo);
        String geminiSendFuncReqBoStr = JSON.toJSONString((Object)((Object)geminiSendFuncReqBo));
        log.info("\u50ac\u4ea4\u53c2\u6570{}", (Object)geminiSendFuncReqBo.getData());
        log.info("HTTP\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3-\u5165\u53c2\uff1a{}", (Object)geminiSendFuncReqBoStr);
        String geminiSendFuncRspBoStr = HttpUtil.post((String)this.geminiSendUrl, (String)geminiSendFuncReqBoStr);
        log.info("HTTP\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3-\u51fa\u53c2\uff1a{}", (Object)geminiSendFuncRspBoStr);
        GeminiSendFuncRspBo geminiSendFuncRspBo = (GeminiSendFuncRspBo)((Object)JUtil.jss((String)geminiSendFuncRspBoStr, GeminiSendFuncRspBo.class));
        if (!"0000".equals(geminiSendFuncRspBo.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u5f02\u5e38\uff0c\u5f02\u5e38\u7f16\u7801\u3010" + geminiSendFuncRspBo.getRespCode() + "\u3011," + geminiSendFuncRspBo.getRespDesc());
        }
        return (DycUocOrderCallFuncRspBO)((Object)JUtil.js((Object)((Object)geminiSendFuncRspBo), DycUocOrderCallFuncRspBO.class));
    }

    private GeminiSendFuncReqBo combGeminiSendAbilityReqBO(DycUocOrderCallFuncReqBO reqBo, UocGetSaleOrderDetailServiceRspBo uocRspBo) {
        GeminiSendFuncReqBo geminiSendFuncReqBo = new GeminiSendFuncReqBo();
        if ("EXPEDITE".equals(reqBo.getCallType())) {
            geminiSendFuncReqBo.setTaskCode("uoc_expedite");
        } else if ("REMIND_SUP_TO_CONFIRM".equals(reqBo.getCallType())) {
            geminiSendFuncReqBo.setTaskCode("uoc_remind_sup_to_confirm");
        } else {
            throw new ZTBusinessException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684callType");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("saleOrderNo", (Object)uocRspBo.getSaleOrderNo());
        jsonObject.put("purOrgName", (Object)uocRspBo.getUocGetSaleOrderDetailServiceRspStakeholderBo().getPurOrgName());
        geminiSendFuncReqBo.setData(jsonObject.toJSONString());
        AuthGetUserByRoleAndOrgReqBo roleAndOrgReqBo = new AuthGetUserByRoleAndOrgReqBo();
        roleAndOrgReqBo.setOrgIdWeb(Long.valueOf(uocRspBo.getSupId()));
        roleAndOrgReqBo.setRoleCodes(Arrays.asList("tenant:305775845729763327:gongfangyewuyuan", "tenant:305775845729763327:gongyingshangguanliyuan"));
        log.info("\u89d2\u8272\u673a\u6784\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2:" + JSON.toJSONString((Object)roleAndOrgReqBo));
        AuthGetUserByRoleAndOrgRspBo userByRoleAndOrg = this.authGetUserByRoleAndOrgService.getUserByRoleAndOrg(roleAndOrgReqBo);
        log.info("\u89d2\u8272\u673a\u6784\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u51fa\u53c2:" + JSON.toJSONString((Object)userByRoleAndOrg));
        ArrayList<GeminiReceiverBO> receiverBOList = new ArrayList<GeminiReceiverBO>(userByRoleAndOrg.getRows().size());
        for (AuthByRoleAndOrgQryUserInfoBo bo : userByRoleAndOrg.getRows()) {
            GeminiReceiverBO receiverBO = new GeminiReceiverBO();
            receiverBO.setReceiverId(bo.getUserId().toString());
            receiverBO.setReceiverName(bo.getCustName());
            receiverBO.setMobileNumber(bo.getCellPhone());
            receiverBO.setEMail(bo.getCustEmail());
            receiverBOList.add(receiverBO);
        }
        geminiSendFuncReqBo.setReceivers(receiverBOList);
        geminiSendFuncReqBo.setSendId(reqBo.getUserId().toString());
        return geminiSendFuncReqBo;
    }
}

