/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscMerchantBO;
import com.tydic.fsc.busibase.atom.api.FscMerchantAtomService;
import com.tydic.fsc.busibase.atom.bo.FscMerchantAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantAtomRspBo;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPageQryAtomReqBo;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPageQryAtomRspBo;
import com.tydic.fsc.busibase.external.api.pay.FscPayTransPayInsService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsReqBo;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsRspBo;
import com.tydic.fsc.busibase.external.api.ucc.FscUccCommodityTypeQueryService;
import com.tydic.fsc.busibase.external.api.ucc.bo.FscUccCommodityTypeQueryReqBO;
import com.tydic.fsc.busibase.external.api.ucc.bo.FscUccCommodityTypeQueryRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscMerchantPayeeChannelMapper;
import com.tydic.fsc.dao.FscSkuCategoryMapper;
import com.tydic.fsc.po.FscDicDictionaryPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscMerchantPayeeChannelPO;
import com.tydic.fsc.po.FscSkuCategoryPO;
import com.tydic.fsc.util.FscRspUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscMerchantAtomService")
public class FscMerchantAtomServiceImpl
implements FscMerchantAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantAtomServiceImpl.class);
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;
    @Autowired
    private FscSkuCategoryMapper fscSkuCategoryMapper;
    @Autowired
    private FscUccCommodityTypeQueryService fscUccCommodityTypeQueryService;
    @Autowired
    private FscMerchantPayeeChannelMapper fscMerchantPayeeChannelMapper;
    @Autowired
    private FscPayTransPayInsService fscPayTransPayInsService;

    @Override
    public FscMerchantAtomRspBo isMerchantCanEdit(FscMerchantAtomReqBO reqBO) {
        FscMerchantAtomRspBo retBo = (FscMerchantAtomRspBo)FscRspUtil.getRspBo((String)"194305", (String)"\u5931\u8d25", FscMerchantAtomRspBo.class);
        FscMerchantPO reqPo = new FscMerchantPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)reqPo);
        FscMerchantPO retPo = this.fscMerchantMapper.getModelBy(reqPo);
        if (null == retPo) {
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u6237ID[" + reqBO.getMerchantId() + "]\u7684\u4fe1\u606f");
            return retBo;
        }
        if (!FscConstants.MerchantStatus.DRAFT.equals(retPo.getStatus())) {
            retBo.setRespDesc("\u5546\u6237ID[" + reqBO.getMerchantId() + "]\u975e\u8349\u7a3f\u72b6\u6001\uff0c\u4e0d\u53ef\u7f16\u8f91");
            return retBo;
        }
        if (FscConstants.MerchantDeleteFlag.YES.equals(retPo.getDelFlag())) {
            retBo.setRespDesc("\u5546\u6237ID[" + reqBO.getMerchantId() + "]\u72b6\u6001\u4e3a\u5df2\u5220\u9664\uff0c\u4e0d\u53ef\u7f16\u8f91");
            return retBo;
        }
        retBo.setRespDesc("\u6210\u529f");
        retBo.setRespCode("0000");
        return retBo;
    }

    @Override
    public FscMerchantAtomRspBo updateMerchant(FscMerchantAtomReqBO reqBo) {
        FscMerchantAtomRspBo retBo = (FscMerchantAtomRspBo)FscRspUtil.getSuccessRspBo(FscMerchantAtomRspBo.class);
        Date nowTime = this.fscMerchantMapper.getDBDate();
        FscMerchantPO updatePo = new FscMerchantPO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)updatePo);
        updatePo.setUpdateTime(nowTime);
        updatePo.setUpdateOperId(reqBo.getUserId().toString());
        updatePo.setUpdateOperName(reqBo.getName());
        int result = this.fscMerchantMapper.updateById(updatePo);
        if (result < 1) {
            log.error("\u66f4\u65b0\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            retBo.setRespCode("194305");
            retBo.setRespDesc("\u66f4\u65b0\u5546\u6237\u8868\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        return retBo;
    }

    @Override
    public FscMerchantPageQryAtomRspBo queryPage(FscMerchantPageQryAtomReqBo reqBo) {
        List<FscMerchantPO> merchants;
        FscMerchantPageQryAtomRspBo retBo = (FscMerchantPageQryAtomRspBo)FscRspUtil.getSuccessRspBo(FscMerchantPageQryAtomRspBo.class);
        ArrayList<FscMerchantBO> rows = new ArrayList<FscMerchantBO>();
        retBo.setRows(rows);
        retBo.setPageNo(reqBo.getPageNo());
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBo.getExceptionFlag())) {
            FscMerchantPO mainPo = new FscMerchantPO();
            mainPo.setMerchantId(reqBo.getParentId());
            mainPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
            mainPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
            mainPo = this.fscMerchantMapper.getModelBy(mainPo);
            if (mainPo == null) {
                retBo.setRespDesc("\u6ca1\u6709\u67e5\u8be2\u5230\u6709\u6548\u7684\u4e3b\u5546\u6237\u914d\u7f6e");
                return retBo;
            }
            if (FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_PAY.equals(reqBo.getExceptionCategory()) && FscConstants.MerchantAllowException.NO.equals(mainPo.getPayAllowExceptionFlag())) {
                retBo.setRespDesc("\u5546\u6237\u4e0d\u5141\u8bb8\u652f\u4ed8\u914d\u7f6e\u4f8b\u5916");
                return retBo;
            }
            if (FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MODEL.equals(reqBo.getExceptionCategory()) && FscConstants.MerchantAllowException.NO.equals(mainPo.getModelAllowExceptionFlag())) {
                retBo.setRespDesc("\u5546\u6237\u4e0d\u5141\u8bb8\u6a21\u5f0f\u914d\u7f6e\u4f8b\u5916");
                return retBo;
            }
        }
        Page page = reqBo.getPageNo() > 1 ? new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue()) : new Page(1, 10);
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        FscMerchantPO queryPo = new FscMerchantPO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)queryPo);
        if (!CollectionUtils.isEmpty(reqBo.getMerchantIds())) {
            queryPo.setMerchantIds(reqBo.getMerchantIds().stream().map(Long::valueOf).collect(Collectors.toList()));
        }
        queryPo.setOrderBy("m.create_time desc");
        if (null != reqBo.getCreateTimeBegin()) {
            queryPo.setCreateTimeStart(reqBo.getCreateTimeBegin());
        }
        if (CollectionUtils.isEmpty(merchants = this.fscMerchantMapper.queryPage(queryPo, (Page<FscMerchantPO>)page))) {
            log.error("\u6839\u636e\u5165\u53c2\u672a\u67e5\u8be2\u67e5\u8be2\u6570\u636e\u5217\u8868\u4e3a\u7a7a\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBo)));
            retBo.setRespCode("194305");
            retBo.setRespDesc("\u67e5\u8be2\u5230\u7684\u6570\u636e\u5217\u8868\u4e3a\u7a7a");
            return retBo;
        }
        for (FscMerchantPO merchantPo : merchants) {
            FscMerchantBO bo = new FscMerchantBO();
            BeanUtils.copyProperties((Object)merchantPo, (Object)bo);
            bo.setStatusStr(dicMap.get("MERCHANT_STATUS").get(bo.getStatus().toString()));
            if (FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION.equals(bo.getExceptionFlag())) {
                bo.setMerchantTypeStr(dicMap.get("MERCHANT_TYPE").get(bo.getMerchantType().toString()));
                bo.setMerchantCategoryStr(dicMap.get("MERCHANT_CATEGORY").get(bo.getMerchantCategory().toString()));
            }
            if (!StringUtils.isEmpty((Object)bo.getPayBusiSceneRange())) {
                String[] range = bo.getPayBusiSceneRange().split(",");
                StringBuilder rangeStr = new StringBuilder();
                for (int i = 0; i < range.length; ++i) {
                    rangeStr.append(dicMap.get("MERCHANT_BUSI_SCENE").get(range[i]));
                    if (i == range.length - 1) continue;
                    rangeStr.append(",");
                }
                bo.setPayBusiSceneRangeStr(rangeStr.toString());
                if (null != bo.getPayUserIdentity()) {
                    bo.setPayUserIdentityStr(dicMap.get("MERCHANT_IDENTITY").get(bo.getPayUserIdentity().toString()));
                }
                if (null != bo.getPayAllowExceptionFlag()) {
                    bo.setPayAllowExceptionFlagStr(dicMap.get("MERCHANT_ALLOW_EXCEPTION").get(bo.getPayAllowExceptionFlag().toString()));
                }
                bo.setPayTypeStr(dicMap.get("MERCHANT_PAY_TYPE").get(bo.getPayType().toString()));
                if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(bo.getPayType())) {
                    bo.setPayRuleStr(dicMap.get("MERCHANT_PAY_RULE").get(bo.getPayRule().toString()));
                    if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(bo.getPayRule())) {
                        bo.setPayAccountDayRuleStr(dicMap.get("MERCHANT_DAY_RULE").get(bo.getPayAccountDayRule().toString()));
                    }
                    if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(bo.getPayRule())) {
                        bo.setPayNodeRuleStr(dicMap.get("MERCHANT_NODE_RULE").get(bo.getPayNodeRule().toString()));
                    }
                }
            }
            if (null != bo.getModelSceneRange()) {
                bo.setModelSceneRangeStr(dicMap.get("MERCHANT_SCENE_RANGE").get(bo.getModelSceneRange().toString()));
                if (null != bo.getModelUserIdentity()) {
                    bo.setModelUserIdentityStr(dicMap.get("MERCHANT_MODEL_IDENTITY").get(bo.getModelUserIdentity().toString()));
                }
                bo.setModelSettleStr(dicMap.get("MERCHANT_MODEL_SETTLE").get(bo.getModelSettle().toString()));
            }
            if (null != bo.getModelAllowExceptionFlag()) {
                bo.setModelAllowExceptionFlagStr(dicMap.get("MERCHANT_MODEL_ALLOW_EXCEPTION").get(bo.getModelAllowExceptionFlag().toString()));
            }
            bo.setExceptionFlagStr(dicMap.get("MERCHANT_IS_EXCEPTION").get(bo.getExceptionFlag().toString()));
            if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(bo.getExceptionFlag())) {
                bo.setExceptionCategoryStr(dicMap.get("MERCHANT_EXCEPTION_CATEGORY").get(bo.getExceptionCategory().toString()));
                bo.setExceptionUserLatitudeStr(dicMap.get("MERCHANT_EXCEPTION_LATITUDE").get(bo.getExceptionUserLatitude().toString()));
            }
            rows.add(bo);
        }
        this.queryCommodityType(rows);
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBo.getExceptionFlag()) && FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_PAY.equals(reqBo.getExceptionCategory())) {
            this.queryPayChannel(rows);
        }
        retBo.setPageNo(reqBo.getPageNo());
        retBo.setRows(rows);
        retBo.setTotal(page.getTotalPages());
        retBo.setRecordsTotal(page.getTotalCount());
        return retBo;
    }

    private void queryPayChannel(List<FscMerchantBO> rows) {
        FscPayTransPayInsReqBo transReqBo = new FscPayTransPayInsReqBo();
        FscMerchantPayeeChannelPO relPo = new FscMerchantPayeeChannelPO();
        for (FscMerchantBO merchantBO : rows) {
            relPo.setMerchantId(merchantBO.getMerchantId());
            List<FscMerchantPayeeChannelPO> channels = this.fscMerchantPayeeChannelMapper.getList(relPo);
            if (CollectionUtils.isEmpty(channels)) continue;
            List<Long> paymentInsId = channels.stream().map(item -> Long.valueOf(item.getPayChannel())).collect(Collectors.toList());
            transReqBo.setPaymentInsId(paymentInsId);
            FscPayTransPayInsRspBo transRetBo = this.fscPayTransPayInsService.tranPayIns(transReqBo);
            if (!"0000".equals(transRetBo.getRespCode())) continue;
            Map<String, String> payInsMap = transRetBo.getPayInsMap();
            Map<String, String> payMethodMap = transRetBo.getPayMethodMap();
            StringBuilder payChannelSb = new StringBuilder();
            StringBuilder payMethodSb = new StringBuilder();
            for (FscMerchantPayeeChannelPO po : channels) {
                String[] payMethod;
                payChannelSb.append(payInsMap.get(po.getPayChannel())).append("\uff0c");
                for (String s : payMethod = po.getPayMethod().split(",")) {
                    payMethodSb.append(payMethodMap.get(s));
                    payMethodSb.append("\uff0c");
                }
            }
            merchantBO.setPayChannelStr(payChannelSb.substring(0, payChannelSb.length() - 1));
            merchantBO.setPayMethodStr(payMethodSb.substring(0, payMethodSb.length() - 1));
        }
    }

    private void queryCommodityType(List<FscMerchantBO> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        FscSkuCategoryPO queryPo = new FscSkuCategoryPO();
        FscUccCommodityTypeQueryReqBO uccReqBo = new FscUccCommodityTypeQueryReqBO();
        FscUccCommodityTypeQueryRspBO uccRetBo = this.fscUccCommodityTypeQueryService.getCommondityType(uccReqBo);
        if (CollectionUtils.isEmpty(uccRetBo.getCommodityTypeMap())) {
            log.error("\u8c03\u7528\u5546\u54c1\u7c7b\u578b\u67e5\u8be2\u63a5\u53e3\u83b7\u53d6\u5230\u7684map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u7ffb\u8bd1\u5546\u54c1\u7c7b\u578b");
        }
        Map<Long, String> commodityTypeMap = uccRetBo.getCommodityTypeMap();
        for (FscMerchantBO merchantBo : rows) {
            queryPo.setMerchantId(merchantBo.getMerchantId());
            List<FscSkuCategoryPO> skuCategoryPos = this.fscSkuCategoryMapper.getList(queryPo);
            if (CollectionUtils.isEmpty(skuCategoryPos)) continue;
            List<Long> commodityTypeIds = skuCategoryPos.stream().map(item -> Long.valueOf(item.getCategoryTreePath())).collect(Collectors.toList());
            StringBuilder catalogSb = new StringBuilder();
            commodityTypeIds.forEach(item -> catalogSb.append((String)commodityTypeMap.get((long)item)).append("\uff0c"));
            merchantBo.setCatalogNames(catalogSb.substring(0, catalogSb.lastIndexOf("\uff0c")));
        }
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> dicPCodes = new ArrayList<String>();
        dicPCodes.add("MERCHANT_STATUS");
        dicPCodes.add("MERCHANT_TYPE");
        dicPCodes.add("MERCHANT_CATEGORY");
        dicPCodes.add("MERCHANT_BUSI_SCENE");
        dicPCodes.add("MERCHANT_MODEL_IDENTITY");
        dicPCodes.add("MERCHANT_IDENTITY");
        dicPCodes.add("MERCHANT_ALLOW_EXCEPTION");
        dicPCodes.add("MERCHANT_PAY_TYPE");
        dicPCodes.add("MERCHANT_PAY_RULE");
        dicPCodes.add("MERCHANT_MODEL_SETTLE");
        dicPCodes.add("MERCHANT_DAY_RULE");
        dicPCodes.add("MERCHANT_NODE_RULE");
        dicPCodes.add("MERCHANT_SCENE_RANGE");
        dicPCodes.add("MERCHANT_MODEL_ALLOW_EXCEPTION");
        dicPCodes.add("MERCHANT_EXCEPTION_CATEGORY");
        dicPCodes.add("MERCHANT_IS_EXCEPTION");
        dicPCodes.add("MERCHANT_EXCEPTION_LATITUDE");
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setSysCode("FSC");
        for (String pCode : dicPCodes) {
            queryPo.setPCode(pCode);
            List<FscDicDictionaryPO> dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
            Map<String, String> map = dicDictionaryPos.stream().collect(Collectors.toMap(FscDicDictionaryPO::getCode, FscDicDictionaryPO::getTitle));
            dicMap.put(pCode, map);
        }
        return dicMap;
    }
}

