/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscCreditDeductAtomBO;
import com.tydic.fsc.busibase.atom.api.FscCreditDeductAtomService;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCreditBalanceMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.po.FscCreditBalancePO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayLogPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscCreditDeductAtomServiceImpl
implements FscCreditDeductAtomService {
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscCreditBalanceMapper fscCreditBalanceMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    private static final Integer IS_CREDIT = 1;

    @Override
    public FscCreditDeductAtomRspBO dealAccountDeduct(FscCreditDeductAtomReqBO reqBO) {
        return new FscCreditDeductAtomRspBO();
    }

    private void writeLog(FscMerchantPO fscMerchant, FscCreditBalancePO fscCreditBalance, FscCreditDeductAtomReqBO reqBO) {
        Date now = new Date();
        ArrayList<FscPayLogPO> fscPayLogPos = new ArrayList<FscPayLogPO>();
        reqBO.getFscCreditDeductAtomBOS().forEach(fscCreditDeductAtomBO -> {
            FscPayLogPO fscPayLogPo = new FscPayLogPO();
            long nextId = Sequence.getInstance().nextId();
            fscPayLogPo.setId(nextId);
            fscPayLogPo.setAccountId(fscMerchant.getAccountId());
            fscPayLogPo.setOrgId(reqBO.getCreditOrgId());
            fscPayLogPo.setUserName(fscMerchant.getOrgName());
            fscPayLogPo.setBusiTime(now);
            fscPayLogPo.setPayeeId(reqBO.getSupId());
            fscPayLogPo.setBusiOrderType(fscCreditDeductAtomBO.getOrderType());
            fscPayLogPo.setBusiAmount(fscCreditDeductAtomBO.getAmount());
            if (fscCreditDeductAtomBO.getAmount().compareTo(BigDecimal.ZERO) > 0) {
                fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_PAY);
            } else {
                fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_REFUND);
            }
            if (null != reqBO.getBusiCategory()) {
                fscPayLogPo.setBusiCategory(reqBO.getBusiCategory());
            }
            fscPayLogPo.setBusiOrderNo(fscCreditDeductAtomBO.getOrderNo());
            fscPayLogPo.setBusiOrderId(fscCreditDeductAtomBO.getOrderId());
            if (null == fscCreditBalance) {
                BigDecimal totalAmt = reqBO.getFscCreditDeductAtomBOS().stream().map(FscCreditDeductAtomBO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                fscPayLogPo.setBusiBeforeAmount(fscMerchant.getPayCreditAmount());
                fscPayLogPo.setBusiAfterAmount(fscMerchant.getPayCreditAmount().subtract(totalAmt));
            } else {
                fscPayLogPo.setBusiBeforeAmount(fscCreditBalance.getAvailableAmount());
                fscPayLogPo.setBusiAfterAmount(fscCreditBalance.getAvailableAmount().subtract(fscCreditDeductAtomBO.getAmount()));
            }
            fscPayLogPo.setIsCredit(IS_CREDIT);
            fscPayLogPo.setCreateTime(now);
            if (null != reqBO.getUserName()) {
                fscPayLogPo.setCreateOperId(reqBO.getUserName());
            }
            fscPayLogPos.add(fscPayLogPo);
        });
        this.fscPayLogMapper.insertBatch(fscPayLogPos);
    }
}

