/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.base.utils.http;

import cn.hutool.http.Header;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.http.HttpUtilsGetTokenReqBo;
import com.tydic.uoc.base.utils.http.HttpUtilsGetTokenRspBo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.collections.MapUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class HttpUtilsPool {
    private static final Logger log = LoggerFactory.getLogger(HttpUtilsPool.class);
    private static HttpClientBuilder httpClientBuilder;
    private static HttpUtilsPool httpUtils;
    private static String lianDongApiKey;
    private static String lianDongUrl;
    private static String lianDongSysCode;
    private static String lianDongSecretKey;
    private HttpUtilsGetTokenRspBo httpUtilsBo;

    @Value(value="${LIANDONG_APIKEY:GTq50lqMF4pX8qmy0H4KYFSeBPuMYRtL}")
    public void setApiKey(String apiKeySet) {
        lianDongApiKey = apiKeySet;
    }

    @Value(value="${LIANDONG_URL:http://apim-gateway.test.liando.cn/env-201/por-201/bpm/uc/auth/v1/oauth}")
    public void setUrl(String urlSet) {
        lianDongUrl = urlSet;
    }

    @Value(value="${LIANDONG_SYSCODE:lsugu}")
    public void setSysCode(String sysCodeSet) {
        lianDongSysCode = sysCodeSet;
    }

    @Value(value="${LIANDONG_SECRETKEY:scDR1glfVQNxelCS2lsugu_20220704}")
    public void setSecretKey(String secretKeySet) {
        lianDongSecretKey = secretKeySet;
    }

    public static void initHttpClientBuilder() throws NoSuchAlgorithmException, KeyManagementException {
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String str) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String str) {
            }
        };
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, new TrustManager[]{trustManager}, null);
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard-strict").setExpectContinueEnabled(Boolean.TRUE.booleanValue()).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Collections.singletonList("Basic")).build();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)socketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig);
    }

    @PostConstruct
    public void init() {
        httpUtils = this;
    }

    public static String doGet(String url, Map<String, String> queryMap) {
        CloseableHttpClient httpClient = httpClientBuilder.build();
        try {
            HttpGet request = new HttpGet(HttpUtilsPool.buildUrl(url, queryMap));
            request.addHeader(Header.AUTHORIZATION.getValue(), HttpUtilsPool.getAuthorization());
            request.addHeader("apiKey", lianDongApiKey);
            request.setConfig(HttpUtilsPool.setTimeOutConfig(request.getConfig()));
            return HttpUtilsPool.parseHttpResponseString(httpClient.execute((HttpUriRequest)request));
        }
        catch (Exception e) {
            throw new UocProBusinessException("102111", "HTTP\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    public static String doPost(String url, String body, Map<String, String> queryMap) {
        log.debug("\u8fdb\u5165http_post---------------------------------------------------");
        CloseableHttpClient httpClient = httpClientBuilder.build();
        log.debug("httpClientBuilder.build()--------------------------------------------------");
        HttpPost request = new HttpPost(url);
        if (StringUtils.hasText((String)body)) {
            request.setEntity((HttpEntity)new StringEntity(body, StandardCharsets.UTF_8));
            log.debug("http_post_body---------------------------------------------------" + body);
        }
        try {
            return HttpUtilsPool.parseHttpResponseString(httpClient.execute((HttpUriRequest)request));
        }
        catch (Exception e) {
            throw new UocProBusinessException("102111", "HTTP\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    private static RequestConfig setTimeOutConfig(RequestConfig requestConfig) {
        if (requestConfig == null) {
            requestConfig = RequestConfig.DEFAULT;
        }
        return RequestConfig.copy((RequestConfig)requestConfig).setConnectionRequestTimeout(60000).setConnectTimeout(60000).setSocketTimeout(10000).build();
    }

    private static String buildUrl(String url, Map<String, String> queryMap) {
        log.debug("\u8fdb\u5165buildUrl--------------------------------------------------");
        StringBuilder sbUrl = new StringBuilder();
        if (StringUtils.hasText((String)url)) {
            sbUrl.append(url);
        }
        if (MapUtils.isNotEmpty(queryMap)) {
            StringBuilder sbQuery = new StringBuilder();
            for (Map.Entry<String, String> query : queryMap.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                sbQuery.append(query.getKey());
                if (!StringUtils.hasText((String)query.getValue())) continue;
                sbQuery.append("=");
                try {
                    sbQuery.append(URLEncoder.encode(query.getValue(), String.valueOf(StandardCharsets.UTF_8)));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append((CharSequence)sbQuery);
            }
        }
        log.debug("\u8fdb\u5165buildUrl\u7ed3\u675f--------------------------------------------------");
        return sbUrl.toString();
    }

    public static String parseHttpResponseString(HttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        String httpResponseString = null;
        if (null != entity) {
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (200 != statusCode) {
                throw new UocProBusinessException("102111", "HTTP\u8bf7\u6c42\u72b6\u6001\u5f02\u5e38\u72b6\u6001\u7801\uff1a" + httpResponse.getStatusLine().getStatusCode() + "\uff0c\u539f\u56e0\uff1a" + EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8));
            }
            httpResponseString = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            EntityUtils.consume((HttpEntity)entity);
        }
        EntityUtils.consume((HttpEntity)entity);
        return httpResponseString;
    }

    private static String getAuthorization() {
        log.debug("\u8fdb\u5165\u83b7\u53d6token--------------------------------------------------");
        String tokenStr = HttpUtilsPool.getTokenStr(lianDongUrl);
        HttpUtilsGetTokenRspBo httpUtilsBo = (HttpUtilsGetTokenRspBo)JSONObject.parseObject((String)tokenStr, HttpUtilsGetTokenRspBo.class);
        if (!httpUtilsBo.getState().booleanValue()) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6token\u5931\u8d25\uff1a" + httpUtilsBo.getState() + "\uff0c\u539f\u56e0\uff1a" + httpUtilsBo.getMessage());
        }
        String authorization = "Bearer " + httpUtilsBo.getToken();
        log.debug("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u7528token={}", (Object)authorization);
        log.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u7528token=[{}]", (Object)authorization);
        log.debug("\u8fdb\u5165\u83b7\u53d6token\u7ed3\u675f--------------------------------------------------");
        return authorization;
    }

    private static String getTokenStr(String url) {
        CloseableHttpClient httpClient = httpClientBuilder.build();
        HttpPost request = new HttpPost(url);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.addHeader("apiKey", lianDongApiKey);
        HttpUtilsGetTokenReqBo httpUtilsGetTokenReqBo = new HttpUtilsGetTokenReqBo();
        httpUtilsGetTokenReqBo.setSysCode(lianDongSysCode);
        httpUtilsGetTokenReqBo.setSecretKey(lianDongSecretKey);
        String body = JSONObject.toJSONString((Object)httpUtilsGetTokenReqBo);
        if (!StringUtils.isEmpty((Object)body)) {
            request.setEntity((HttpEntity)new StringEntity(body, StandardCharsets.UTF_8));
        }
        request.setConfig(HttpUtilsPool.setTimeOutConfig(request.getConfig()));
        try {
            return HttpUtilsPool.parseHttpResponseString(httpClient.execute((HttpUriRequest)request));
        }
        catch (Exception e) {
            throw new UocProBusinessException("102111", "HTTP\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
    }
}

