/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtPlanFinishAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPlanBO;
import com.tydic.uoc.common.ability.bo.PebExtPlanDetailQueryQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPlanDetailQueryQueryRspBO;
import com.tydic.uoc.common.ability.bo.PebExtPlanFinishReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPlanFinishRspBO;
import com.tydic.uoc.common.busi.api.PebExtPlanDetailQueryBusiService;
import com.tydic.uoc.common.busi.api.PebExtPlanInfoUpdateBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPlanInfoUpdateReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPlanInfoUpdateRspBO;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtPlanFinishAbilityService"})
public class PebExtPlanFinishAbilityServiceImpl
implements PebExtPlanFinishAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPlanFinishAbilityServiceImpl.class);
    @Autowired
    private PebExtPlanInfoUpdateBusiService pebExtPlanInfoUpdateBusiService;
    @Autowired
    private PebExtPlanDetailQueryBusiService pebExtPlanDetailQueryBusiService;

    @PostMapping(value={"dealPlanFinish"})
    public PebExtPlanFinishRspBO dealPlanFinish(@RequestBody PebExtPlanFinishReqBO reqBO) {
        this.validateArgs(reqBO);
        PebExtPlanFinishRspBO retBo = new PebExtPlanFinishRspBO();
        Boolean checkResult = this.checkStatus(reqBO, retBo);
        if (!checkResult.booleanValue()) {
            return retBo;
        }
        PebExtPlanInfoUpdateReqBO busiReqBo = new PebExtPlanInfoUpdateReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBo));
        busiReqBo.setStatus(PebExtConstant.PlanStatus.FINISH);
        busiReqBo.setJustUpdateStatus(true);
        PebExtPlanInfoUpdateRspBO busiRetBo = this.pebExtPlanInfoUpdateBusiService.updatePlanInfo(busiReqBo);
        BeanUtils.copyProperties((Object)((Object)busiRetBo), (Object)retBo);
        return retBo;
    }

    private Boolean checkStatus(PebExtPlanFinishReqBO reqBO, PebExtPlanFinishRspBO retBo) {
        PebExtPlanDetailQueryQueryReqBO queryReqBo = new PebExtPlanDetailQueryQueryReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryReqBo);
        queryReqBo.setQryItem(Integer.valueOf(0));
        PebExtPlanDetailQueryQueryRspBO queryRetBo = this.pebExtPlanDetailQueryBusiService.getPebExtPlanDetailQuery(queryReqBo);
        PebExtPlanBO planBo = queryRetBo.getOrdPlanRspBO();
        if (null == planBo) {
            log.debug("\u6839\u636e\u5165\u53c2\u6ca1\u6709\u67e5\u8be2\u5230\u4fe1\u606f\uff1a{}" + JSON.toJSONString((Object)reqBO));
            retBo.setRespCode("104012");
            retBo.setRespDesc("\u6839\u636e\u5165\u53c2\u6ca1\u6709\u67e5\u8be2\u5230\u4fe1\u606f");
            return false;
        }
        Integer[] planStatus = new Integer[]{1700, 1701};
        if (!Arrays.asList(planStatus).contains(planBo.getStatus())) {
            log.debug("\u8ba1\u5212\u5355\u72b6\u6001\u975e\u5f85\u6267\u884c\u6216\u6267\u884c\u4e2d\uff0c\u4e0d\u53ef\u6267\u884c\u5b8c\u7ed3\u64cd\u4f5c");
            retBo.setRespCode("104012");
            retBo.setRespDesc("\u8ba1\u5212\u5355\u72b6\u6001\u975e\u5f85\u6267\u884c\u6216\u6267\u884c\u4e2d\uff0c\u4e0d\u53ef\u6267\u884c\u5b8c\u7ed3\u64cd\u4f5c");
            return false;
        }
        return true;
    }

    private void validateArgs(PebExtPlanFinishReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPlanId())) {
            throw new UocProBusinessException("100001", "\u8ba1\u5212\u5355ID(planId)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getUserId())) {
            throw new UocProBusinessException("100001", "userId(userId)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getUsername())) {
            throw new UocProBusinessException("100001", "username(username)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getName())) {
            throw new UocProBusinessException("100001", "name(name)\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

