/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtPrintBatchComparisonOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPrintBatchComparisonOrderAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPrintBatchComparisonOrderAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtQryBatchCompareOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebExtQryBatchCompareOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocComparisonItemBO;
import com.tydic.uoc.common.ability.bo.UocComparisonMaterialBO;
import com.tydic.uoc.common.ability.bo.UocComparisonSupplierBO;
import com.tydic.uoc.common.busi.api.PebExtQryBatchCompareOrderBusiService;
import com.tydic.uoc.common.utils.PdfUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtPrintBatchComparisonOrderAbilityService"})
public class PebExtPrintBatchComparisonOrderAbilityServiceImpl
implements PebExtPrintBatchComparisonOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPrintBatchComparisonOrderAbilityServiceImpl.class);
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final String PATH = "uoc";
    @Autowired
    private PebExtQryBatchCompareOrderBusiService pebExtQryBatchCompareOrderBusiService;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Autowired
    private FileClient fileClient;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @PostMapping(value={"dealPrintBatchComparisonOrder"})
    public PebExtPrintBatchComparisonOrderAbilityRspBO dealPrintBatchComparisonOrder(@RequestBody PebExtPrintBatchComparisonOrderAbilityReqBO reqBO) {
        PebExtPrintBatchComparisonOrderAbilityRspBO rspBO = new PebExtPrintBatchComparisonOrderAbilityRspBO();
        PebExtQryBatchCompareOrderReqBO goodsReqBO = new PebExtQryBatchCompareOrderReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)goodsReqBO);
        PebExtQryBatchCompareOrderRspBO goodsRspBO = this.pebExtQryBatchCompareOrderBusiService.qryBatchCompareOrder(goodsReqBO);
        if (!"0000".equals(goodsRspBO.getRespCode())) {
            throw new UocProBusinessException(goodsRspBO.getRespCode(), goodsRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)goodsRspBO.getMaterialInfo()) || CollectionUtils.isEmpty((Collection)goodsRspBO.getGoodsSupplierInfo())) {
            throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u6bd4\u9009\u5355\u4fe1\u606f");
        }
        this.printBatchComparisonGoodsDetails(rspBO, goodsRspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private PebExtQryBatchCompareOrderRspBO initGoodsRspData() {
        PebExtQryBatchCompareOrderRspBO goodsRspBO = new PebExtQryBatchCompareOrderRspBO();
        ArrayList<UocComparisonMaterialBO> materialInfo = new ArrayList<UocComparisonMaterialBO>();
        ArrayList<UocComparisonSupplierBO> goodsSupplierInfo = new ArrayList<UocComparisonSupplierBO>();
        for (int y = 1; y <= 3; ++y) {
            UocComparisonSupplierBO uocComparisonSupplierBO = new UocComparisonSupplierBO();
            uocComparisonSupplierBO.setGoodsSupplierId(String.valueOf(y));
            uocComparisonSupplierBO.setGoodsSupplierName("\u6d4b\u8bd5\u4f9b\u5e94\u5546" + y + "\u53f7");
            uocComparisonSupplierBO.setTotalSalePrice("00.00");
            uocComparisonSupplierBO.setTotalCount("0");
            uocComparisonSupplierBO.setComparisonNo("PLBJ-20201117351914");
            goodsSupplierInfo.add(uocComparisonSupplierBO);
        }
        goodsRspBO.setGoodsSupplierInfo(goodsSupplierInfo);
        for (int i = 1; i <= 3; ++i) {
            UocComparisonMaterialBO uocComparisonMaterialBO = new UocComparisonMaterialBO();
            uocComparisonMaterialBO.setSkuName("\u5546\u54c1" + i + "\u53f7");
            uocComparisonMaterialBO.setSkuMaterialId(RandomUtil.randomNumbers((int)7));
            uocComparisonMaterialBO.setSkuMaterialDesc("\u5546\u54c1" + i + "\u53f7\u7269\u6599\u63cf\u8ff0");
            uocComparisonMaterialBO.setSkuOrder(Integer.valueOf(i));
            uocComparisonMaterialBO.setPurchaseCount("1");
            ArrayList<UocComparisonItemBO> goodsInfo = new ArrayList<UocComparisonItemBO>();
            for (int j = 1; j <= 3; ++j) {
                UocComparisonItemBO uocComparisonItemBO = new UocComparisonItemBO();
                uocComparisonItemBO.setSkuOrder(Integer.valueOf(i));
                uocComparisonItemBO.setSkuName("\u5546\u54c1" + i + "\u53f7\u5173\u8054\u5546\u54c1\u7b2c" + j + "\u53f7");
                uocComparisonItemBO.setSkuId(RandomUtil.randomNumbers((int)4));
                uocComparisonItemBO.setSkuSalePrice("10.00");
                uocComparisonItemBO.setPurchaseCount("1");
                uocComparisonItemBO.setTotalSalePrice("10.00");
                uocComparisonItemBO.setGoodsSupplierId(String.valueOf(j));
                goodsInfo.add(uocComparisonItemBO);
                for (UocComparisonSupplierBO comparisonSupplierBO : goodsSupplierInfo) {
                    if (!comparisonSupplierBO.getGoodsSupplierId().equals(String.valueOf(j))) continue;
                    String totalCount = String.valueOf(Integer.parseInt(comparisonSupplierBO.getTotalCount()) + Integer.parseInt(uocComparisonItemBO.getPurchaseCount()));
                    comparisonSupplierBO.setTotalCount(totalCount);
                    String totalSalePrice = String.valueOf(new BigDecimal(comparisonSupplierBO.getTotalSalePrice()).add(new BigDecimal(uocComparisonItemBO.getTotalSalePrice())));
                    comparisonSupplierBO.setTotalSalePrice(totalSalePrice);
                }
            }
            uocComparisonMaterialBO.setGoodsInfo(goodsInfo);
            materialInfo.add(uocComparisonMaterialBO);
        }
        goodsRspBO.setMaterialInfo(materialInfo);
        return goodsRspBO;
    }

    private void printBatchComparisonGoodsDetails(PebExtPrintBatchComparisonOrderAbilityRspBO rspBO, PebExtQryBatchCompareOrderRspBO goodsRspBO) {
        String fileUrl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            log.error("\u5bfc\u51faPDF\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            throw new UocProBusinessException("104007", "\u5bfc\u51faPDF\u5f02\u5e38");
        }
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            rspBO.setRespDesc("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519\uff1a" + e);
            rspBO.setRespCode("100001");
            return;
        }
        Font titleFont = new Font(baseFont, 14.0f, 0);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        List goodsSupplierInfo = goodsRspBO.getGoodsSupplierInfo();
        int COLUMNS = goodsRspBO.getGoodsSupplierInfo().size() * 2 + 2;
        document.open();
        String comparisonNo = ((UocComparisonSupplierBO)goodsRspBO.getGoodsSupplierInfo().get(0)).getComparisonNo();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtil.addCellToTable(titleTable, "\u6279\u91cf\u6bd4\u9009\u5355\u8be6\u60c5", titleFont, 0, 5, Float.valueOf(40.0f), 1, 0);
        PdfPTable titleTable1 = new PdfPTable(1);
        tableList.add(titleTable1);
        PdfUtil.addCellToTable(titleTable1, "\u6bd4\u9009\u5355\u53f7\uff1a" + this.convertNullToString(comparisonNo), titleFont, 0, 5, Float.valueOf(40.0f), 1, 0);
        PdfPTable pdfPTable1 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable1);
        PdfUtil.addCellToTable(pdfPTable1, "\u539f\u59cb\u5546\u54c1\u5217", contentFont, 1, 5, Float.valueOf(20.0f), 2, null);
        PdfUtil.addCellToTable(pdfPTable1, "\u5339\u914d\u7ed3\u679c\u5217", contentFont, 1, 5, Float.valueOf(20.0f), COLUMNS - 2, null);
        PdfPTable pdfPTable2 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable2);
        PdfUtil.addCellToTable(pdfPTable2, "", contentFont, 0, 5, Float.valueOf(20.0f), 2, null);
        for (Object supplierInfo : goodsSupplierInfo) {
            PdfUtil.addCellToTable(pdfPTable2, supplierInfo.getGoodsSupplierName() + "(" + supplierInfo.getTotalCount() + ")", contentFont, 0, 5, Float.valueOf(20.0f), 2, null);
        }
        PdfPTable pdfPTable3 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable3);
        PdfUtil.addCellToTable(pdfPTable3, "", contentFont, 0, 5, Float.valueOf(20.0f), 2, null);
        for (UocComparisonSupplierBO uocComparisonSupplierBO : goodsSupplierInfo) {
            PdfUtil.addCellToTable(pdfPTable3, "\u5408\u8ba1\uff1a\u00a5" + uocComparisonSupplierBO.getTotalSalePrice(), contentFont, 0, 5, Float.valueOf(20.0f), 2, null);
        }
        List materialInfo = goodsRspBO.getMaterialInfo();
        List goodsSupplier = goodsRspBO.getGoodsSupplierInfo();
        Float height = Float.valueOf((PageSize.A4.getWidth() - 15.0f - 40.0f - 40.0f - 40.0f - 20.0f - 20.0f - 20.0f) / (float)(materialInfo.size() * 6));
        if (height.compareTo(Float.valueOf("12")) < 0) {
            height = Float.valueOf(12.0f);
        }
        int WIDE = (COLUMNS - 2) / goodsRspBO.getGoodsSupplierInfo().size();
        for (UocComparisonMaterialBO uocComparisonMaterialBO : materialInfo) {
            PdfPTable pdfPTable = new PdfPTable(COLUMNS);
            tableList.add(pdfPTable);
            PdfUtil.addCellToTable(pdfPTable, "\u5546\u54c1\u540d\u79f0\uff1a" + uocComparisonMaterialBO.getSkuName(), contentFont, 0, 5, height, 2, 12);
            PdfPTable skuName = new PdfPTable(COLUMNS);
            tableList.add(skuName);
            PdfUtil.addCellToTable(skuName, "\u7269\u6599\u7f16\u7801\uff1a" + uocComparisonMaterialBO.getSkuMaterialId(), contentFont, 0, 5, height, 2, 12);
            PdfPTable skuMaterialId = new PdfPTable(COLUMNS);
            tableList.add(skuMaterialId);
            PdfUtil.addCellToTable(skuMaterialId, "\u7269\u6599\u63cf\u8ff0\uff1a" + uocComparisonMaterialBO.getSkuMaterialDesc(), contentFont, 0, 5, height, 2, 12);
            PdfPTable skuMaterialDesc = new PdfPTable(COLUMNS);
            tableList.add(skuMaterialDesc);
            PdfUtil.addCellToTable(skuMaterialDesc, "\u6570\u91cf\uff1a" + uocComparisonMaterialBO.getPurchaseCount(), contentFont, 0, 5, height, 2, 12);
            PdfPTable space = new PdfPTable(COLUMNS);
            tableList.add(space);
            PdfUtil.addCellToTable(space, "", contentFont, 0, 5, height, 2, 14);
            for (UocComparisonSupplierBO uocComparisonSupplierBO : goodsSupplier) {
                List goodsInfo = uocComparisonMaterialBO.getGoodsInfo();
                UocComparisonItemBO itemBO = null;
                for (UocComparisonItemBO uocComparisonItemBO : goodsInfo) {
                    if (!uocComparisonSupplierBO.getGoodsSupplierId().equals(uocComparisonItemBO.getGoodsSupplierId())) continue;
                    itemBO = uocComparisonItemBO;
                }
                if (itemBO == null) {
                    PdfUtil.addCellToTable(pdfPTable, "\u6682\u65e0", contentFont, 1, 5, height, WIDE, 8);
                    PdfUtil.addCellToTable(skuName, "", contentFont, 0, 5, height, WIDE, 8);
                    PdfUtil.addCellToTable(skuMaterialId, "", contentFont, 0, 5, height, WIDE, 8);
                    PdfUtil.addCellToTable(skuMaterialDesc, "", contentFont, 0, 5, height, WIDE, 12);
                    PdfUtil.addCellToTable(space, "", contentFont, 0, 5, height, WIDE, 14);
                    continue;
                }
                PdfUtil.addCellToTable(pdfPTable, "\u5546\u54c1\u540d\u79f0\uff1a" + this.convertNullToString(itemBO.getSkuName()), contentFont, 0, 5, height, WIDE, 8);
                PdfUtil.addCellToTable(skuName, "\u5355\u54c1ID\uff1a" + this.convertNullToString(itemBO.getSkuId()), contentFont, 0, 5, height, WIDE, 8);
                PdfUtil.addCellToTable(skuMaterialId, "\u542b\u7a0e\u5355\u4ef7\uff1a" + this.convertNullToString(itemBO.getSkuSalePrice()), contentFont, 0, 5, height, WIDE, 8);
                PdfUtil.addCellToTable(skuMaterialDesc, "\u6570\u91cf\uff1a" + this.convertNullToString(itemBO.getPurchaseCount()), contentFont, 0, 5, height, WIDE, 12);
                PdfUtil.addCellToTable(space, "\u603b\u4ef7\uff1a\u00a5" + this.convertNullToString(itemBO.getTotalSalePrice()), contentFont, 0, 5, height, WIDE, 14);
            }
        }
        PdfUtil.addTableListToDoc(document, tableList);
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = IdUtil.fastSimpleUUID() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            fileUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        rspBO.setFileUrl(fileUrl);
    }

    private String convertNullToString(Object obj) {
        if (obj == null) {
            return "\u6682\u65e0";
        }
        String value = String.valueOf(obj);
        if (StringUtils.isBlank((CharSequence)value)) {
            return "\u6682\u65e0";
        }
        return value;
    }
}

