/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebOrderAllocationAbilityService;
import com.tydic.uoc.common.ability.bo.PebOrderAllocationReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderAllocationRspBO;
import com.tydic.uoc.common.ability.bo.UocPebDealOrderBO;
import com.tydic.uoc.common.busi.api.PebOrderAllocationBusiService;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationReqBO;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebOrderAllocationAbilityService"})
public class PebOrderAllocationAbilityServiceImpl
implements PebOrderAllocationAbilityService {
    @Autowired
    private PebOrderAllocationBusiService pebOrderAllocationBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;
    @Resource(name="dealZoneDealAutomaticTaskMsgProvider")
    private ProxyMessageProducer dealZoneDealAutomaticTaskMsgProvider;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TOPIC}")
    private String taskTopic;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TAG}")
    private String taskTag;

    @PostMapping(value={"dealPebOrderAllocation"})
    public PebOrderAllocationRspBO dealPebOrderAllocation(@RequestBody PebOrderAllocationReqBO reqBO) {
        PebOrderAllocationRspBO rspBO;
        this.val(reqBO);
        if (!StringUtils.isBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        if ("0000".equals((rspBO = this.pebOrderAllocationBusiService.dealPebOrderAllocation(reqBO)).getRespCode())) {
            for (UocPebDealOrderBO pebDealOrderBO : rspBO.getOrderAssignList()) {
                this.syncIndex(pebDealOrderBO);
                this.sendAutoMsg(pebDealOrderBO);
            }
        }
        return rspBO;
    }

    private void syncIndex(UocPebDealOrderBO pebDealOrderBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdIdxSyncReqBO.setOrderId(pebDealOrderBO.getOrderId());
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void sendAutoMsg(UocPebDealOrderBO pebDealOrderBO) {
        if (pebDealOrderBO.getAuto().booleanValue()) {
            UocGeneralCirculationReqBO circulationReqBO = new UocGeneralCirculationReqBO();
            circulationReqBO.setActionCode("ACTPEB020");
            circulationReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
            circulationReqBO.setOrderId(pebDealOrderBO.getOrderId());
            circulationReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            this.dealZoneDealAutomaticTaskMsgProvider.send(new ProxyMessage(this.taskTopic, this.taskTag, JSONObject.toJSONString((Object)((Object)circulationReqBO))));
        }
    }

    private void val(PebOrderAllocationReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderAssignList = reqBO.getOrderAssignList();
        if (CollectionUtils.isEmpty((Collection)orderAssignList)) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDeliveryId() == null) {
            throw new UocProBusinessException("100001", "deliveryId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocPebDealOrderBO bo : orderAssignList) {
            if (ObjectUtil.isEmpty((Object)bo.getOrderId())) {
                throw new UocProBusinessException("100001", "orderId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)bo.getSaleVoucherId())) continue;
            throw new UocProBusinessException("100001", "saleVoucherId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

