/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import com.tydic.uac.dao.ApprovalObjMapper;
import com.tydic.uac.po.ApprovalObjPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.atom.impl.UocProRpcMockAtomService;
import com.tydic.uoc.common.ability.api.UocApprovalprocessListQryAbilityService;
import com.tydic.uoc.common.ability.bo.UocApprovalLogBO;
import com.tydic.uoc.common.ability.bo.UocApprovalprocessListQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocApprovalprocessListQryAbilityRspBO;
import com.tydic.uoc.dao.OrdTaskMapper;
import com.tydic.uoc.po.OrdTaskPO;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocApprovalprocessListQryAbilityService"})
public class UocApprovalprocessListQryAbilityServiceImpl
implements UocApprovalprocessListQryAbilityService {
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private OrdTaskMapper ordTaskMapper;
    @Autowired
    private ApprovalObjMapper approvalObjMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private UocProRpcMockAtomService uocProRpcMockAtomService;

    @PostMapping(value={"getUccSkuApprovalprocessListQry"})
    public UocApprovalprocessListQryAbilityRspBO getUccSkuApprovalprocessListQry(@RequestBody UocApprovalprocessListQryAbilityReqBO reqBO) {
        UocApprovalprocessListQryAbilityRspBO rspBO = new UocApprovalprocessListQryAbilityRspBO();
        ApprovalObjPO approvalObjPO = new ApprovalObjPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)approvalObjPO);
        List list = this.approvalObjMapper.getList(approvalObjPO);
        if (list == null || list.size() < 1) {
            throw new UocProBusinessException("104033", "\u8be5\u8ba2\u5355\u672a\u627e\u5230\u5ba1\u6279\u4fe1\u606f");
        }
        ApprovalObjPO approvalObj = (ApprovalObjPO)list.get(0);
        for (ApprovalObjPO itemPO : list) {
            if (itemPO.getId() < approvalObj.getId()) continue;
            approvalObj = itemPO;
        }
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setObjId(approvalObj.getObjId());
        uacQryAuditLogReqBO.setObjType(reqBO.getObjType());
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
        if (!"0000".equals(uacQryAuditLogRspBO.getRespCode())) {
            throw new UocProBusinessException(uacQryAuditLogRspBO.getRespCode(), uacQryAuditLogRspBO.getRespDesc());
        }
        ArrayList<UocApprovalLogBO> approvalLogBOS = new ArrayList<UocApprovalLogBO>();
        String currentStepId = "";
        String nextStationId = "";
        Long auditOrderId = null;
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List logRspBORows = uacQryAuditLogRspBO.getRows();
        if (logRspBORows != null && logRspBORows.size() > 0) {
            LocalDateTime lastDealTime = null;
            if (((ApprovalLogBO)logRspBORows.get(0)).getDealTime() != null) {
                lastDealTime = ((ApprovalLogBO)logRspBORows.get(0)).getDealTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            for (int i = logRspBORows.size() - 1; i >= 0; --i) {
                ApprovalLogBO approvalLogBO = (ApprovalLogBO)logRspBORows.get(i);
                UocApprovalLogBO uocApprovalLogBO = new UocApprovalLogBO();
                BeanUtils.copyProperties((Object)approvalLogBO, (Object)uocApprovalLogBO);
                if (approvalLogBO.getAuditResult() == null) {
                    uocApprovalLogBO.setAuditAdvice("");
                }
                currentStepId = approvalLogBO.getStepId();
                nextStationId = approvalLogBO.getNextStationId();
                auditOrderId = approvalLogBO.getAuditOrderId();
                uocApprovalLogBO.setUrgingFlag("0");
                LocalDateTime createTime = null;
                LocalDateTime dealTime = null;
                if (uocApprovalLogBO.getCreateTime() != null) {
                    createTime = uocApprovalLogBO.getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    uocApprovalLogBO.setCreateTimeStr(df.format(createTime));
                }
                if (uocApprovalLogBO.getDealTime() != null) {
                    dealTime = uocApprovalLogBO.getDealTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    uocApprovalLogBO.setDealTimeStr(df.format(dealTime));
                }
                if (createTime != null && dealTime != null) {
                    long seconds;
                    long minutes;
                    long hours;
                    Duration duration = Duration.between(createTime, dealTime);
                    StringBuilder durationTime = new StringBuilder();
                    long days = duration.toDays();
                    if (days > 0L) {
                        durationTime.append(days).append("\u5929");
                    }
                    if ((hours = duration.toHours()) > 0L) {
                        durationTime.append(hours).append("\u65f6");
                    }
                    if ((minutes = duration.toMinutes()) > 0L) {
                        durationTime.append(minutes).append("\u5206");
                    }
                    if ((seconds = duration.getSeconds()) > 60L) {
                        seconds /= 60L;
                    }
                    if (seconds > 0L) {
                        durationTime.append(seconds).append("\u79d2");
                    }
                    uocApprovalLogBO.setDurationTime(durationTime.toString());
                }
                approvalLogBOS.add(uocApprovalLogBO);
            }
        }
        if (!StringUtils.isBlank((CharSequence)nextStationId)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(Long.parseLong(nextStationId)));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
                for (UserBO itemBO : dycStationOrgSelectUserNameRspBO.getUserList()) {
                    UocApprovalLogBO uocApprovalLogBO = new UocApprovalLogBO();
                    uocApprovalLogBO.setOperName(itemBO.getName());
                    uocApprovalLogBO.setOperDept(itemBO.getCompanyFullName());
                    uocApprovalLogBO.setUrgingFlag("1");
                    approvalLogBOS.add(uocApprovalLogBO);
                }
            }
        }
        if (auditOrderId != null) {
            OrdTaskPO ordTaskPO = new OrdTaskPO();
            ordTaskPO.setOrderId(reqBO.getOrderId());
            ordTaskPO.setObjId(auditOrderId.toString());
            List ordTaskPOS = this.ordTaskMapper.getList(ordTaskPO);
            if (ordTaskPOS != null && ordTaskPOS.size() > 0) {
                rspBO.setProcDefId(((OrdTaskPO)ordTaskPOS.get(0)).getProcInstId());
            }
        }
        rspBO.setCurrentStepId(currentStepId);
        rspBO.setRows(approvalLogBOS);
        rspBO.setRecordsTotal(uacQryAuditLogRspBO.getTotalRecords().intValue());
        rspBO.setPageNo(uacQryAuditLogRspBO.getPageNo().intValue());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

