/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.UocPebAfterServiceCompleteConfirmAbilityService;
import com.tydic.uoc.common.ability.bo.UocProAfterServiceCompleteConfirmAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProAfterServiceCompleteConfirmAbilityRspBo;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdAsItemMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.OrdAsItemPO;
import com.tydic.uoc.po.OrdShipItemPO;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocPebAfterServiceCompleteConfirmAbilityService"})
public class UocPebAfterServiceCompleteConfirmAbilityServiceImpl
implements UocPebAfterServiceCompleteConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocPebAfterServiceCompleteConfirmAbilityServiceImpl.class);
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdAsItemMapper ordAsItemMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"completePebAfterService"})
    public UocProAfterServiceCompleteConfirmAbilityRspBo completePebAfterService(@RequestBody UocProAfterServiceCompleteConfirmAbilityReqBo reqBo) {
        OrdAfterServicePO ordAfterServicePO = this.ordAfterServiceMapper.getModelById(reqBo.getAfterServId().longValue());
        if (null == ordAfterServicePO) {
            throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u552e\u540e\u5355\u4fe1\u606f\uff1a" + reqBo.getAfterServId());
        }
        if (!UocConstant.AFS_ORDER_STATUS.HANDING_OVER.equals(ordAfterServicePO.getServState())) {
            throw new UocProBusinessException("100001", "\u552e\u540e\u5355id:\u72b6\u6001\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
        }
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setProcDefKey("after_sale_order_status");
        processRunReqBO.setObjId(reqBo.getAfterServId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.AFTER_SERVICE);
        processRunReqBO.setOrderId(reqBo.getOrderId());
        processRunReqBO.setVariables(new HashMap<String, Object>());
        processRunReqBO.setOperId("0");
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("104028", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
        UocOrdIdxSyncReqBO uocOrdAsIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdAsIdxSyncReqBO.setObjId(reqBo.getAfterServId());
        uocOrdAsIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.AFTER_SERVICE);
        uocOrdAsIdxSyncReqBO.setOrderId(reqBo.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdAsIdxSyncReqBO)));
        OrdAsItemPO ordAsItemPO = new OrdAsItemPO();
        ordAsItemPO.setAfterServId(reqBo.getAfterServId());
        List asItemPOList = this.ordAsItemMapper.getList(ordAsItemPO);
        OrdShipItemPO modelById = this.ordShipItemMapper.getModelById(((OrdAsItemPO)asItemPOList.get(0)).getShipItemId().longValue());
        uocOrdAsIdxSyncReqBO.setObjId(reqBo.getAfterServId());
        uocOrdAsIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
        uocOrdAsIdxSyncReqBO.setOrderId(modelById.getShipVoucherId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdAsIdxSyncReqBO)));
        return (UocProAfterServiceCompleteConfirmAbilityRspBo)UocProRspBoUtil.success(UocProAfterServiceCompleteConfirmAbilityRspBo.class);
    }
}

