/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.UocProOrderQuotaAllocationDealAbilityService;
import com.tydic.uoc.common.ability.bo.UocProOrderQuotaAllocationDealReqBo;
import com.tydic.uoc.common.ability.bo.UocProOrderQuotaAllocationDealRspBo;
import com.tydic.uoc.common.busi.api.UocProOrderQuotaAllocationDealBusiService;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocProOrderQuotaAllocationDealAbilityService"})
public class UocProOrderQuotaAllocationDealAbilityServiceImpl
implements UocProOrderQuotaAllocationDealAbilityService {
    @Autowired
    private UocProOrderQuotaAllocationDealBusiService uocProOrderQuotaAllocationDealBusiService;

    @PostMapping(value={"dealOrderQuotaAllocation"})
    public UocProOrderQuotaAllocationDealRspBo dealOrderQuotaAllocation(@RequestBody UocProOrderQuotaAllocationDealReqBo reqBo) {
        this.validateArgs(reqBo);
        UocProOrderQuotaAllocationDealRspBo rspBo = this.uocProOrderQuotaAllocationDealBusiService.dealOrderQuotaAllocation(reqBo);
        if (!"0000".equals(rspBo.getRespCode())) {
            return (UocProOrderQuotaAllocationDealRspBo)UocProRspBoUtil.failed((String)rspBo.getRespDesc(), UocProOrderQuotaAllocationDealRspBo.class);
        }
        return rspBo;
    }

    private void validateArgs(UocProOrderQuotaAllocationDealReqBo reqBo) {
        if (null == reqBo) {
            throw new UocProBusinessException("104041", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOperateType()) {
            throw new UocProBusinessException("104041", "\u5165\u53c2[operateType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (1 == reqBo.getOperateType()) {
            if (ObjectUtil.isEmpty((Object)reqBo.getSupNo())) {
                throw new UocProBusinessException("104041", "\u5165\u53c2[supNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBo.getSupplierName())) {
                throw new UocProBusinessException("104041", "\u5165\u53c2[supplierName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBo.getBusinessTypeCode())) {
                throw new UocProBusinessException("104041", "\u5165\u53c2[businessTypeCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.isPositiveIntegerValue(reqBo.getOrderQuota());
        } else if (2 == reqBo.getOperateType()) {
            if (ObjectUtil.isEmpty((Object)reqBo.getConfId())) {
                throw new UocProBusinessException("104041", "\u5165\u53c2[confId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.isPositiveIntegerValue(reqBo.getOrderQuota());
        } else if (3 == reqBo.getOperateType()) {
            if (ObjectUtil.isEmpty((Object)reqBo.getConfId())) {
                throw new UocProBusinessException("104041", "\u5165\u53c2[confId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            throw new UocProBusinessException("104041", "\u5165\u53c2[operateType]\u4e0d\u5408\u6cd5");
        }
    }

    private void isPositiveIntegerValue(BigDecimal bigDecimal) {
        if (null != bigDecimal) {
            if (BigDecimal.ZERO.compareTo(bigDecimal) >= 0) {
                throw new UocProBusinessException("104041", "\u5165\u53c2[orderQuota]\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
            }
            if (bigDecimal.stripTrailingZeros().scale() > 0) {
                throw new UocProBusinessException("104041", "\u5165\u53c2[orderQuota]\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
            }
        } else {
            throw new UocProBusinessException("104041", "\u5165\u53c2[orderQuota]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

