/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.atom.api.UocCoreAfterServOrderCancelAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreAfterServOrderCancelReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreAfterServOrderCancelRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdAsItemMapper;
import com.tydic.uoc.dao.OrdInspectionItemMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPurchaseItemMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.OrdAsItemPO;
import com.tydic.uoc.po.OrdInspectionItemPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPurchaseItemPO;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreAfterServOrderCancelAtomService")
public class UocCoreAfterServOrderCancelAtomServiceImpl
implements UocCoreAfterServOrderCancelAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocCoreAfterServOrderCancelAtomServiceImpl.class);
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdInspectionItemMapper ordInspectionItemMapper;
    @Autowired
    private OrdAsItemMapper ordAsItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdPurchaseItemMapper ordPurchaseItemMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;

    @Override
    public UocCoreAfterServOrderCancelRspBO dealCoreAfterServOrderCancel(UocCoreAfterServOrderCancelReqBO atomReqBO) {
        UocCoreAfterServOrderCancelRspBO rsp = new UocCoreAfterServOrderCancelRspBO();
        this.validateParam(atomReqBO);
        try {
            OrdAfterServicePO ordAfterServicePO = new OrdAfterServicePO();
            ordAfterServicePO.setAfterServId(atomReqBO.getAfterServId());
            ordAfterServicePO.setOrderId(atomReqBO.getOrderId());
            OrdAfterServicePO ordAfterServicePORsp = this.ordAfterServiceMapper.getModelBy(ordAfterServicePO);
            if (ordAfterServicePORsp == null) {
                rsp.setRespCode("101018");
                rsp.setRespDesc("\u552e\u540e\u670d\u52a1\u5355\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return rsp;
            }
            if (null == atomReqBO.getCancelType()) {
                ordAfterServicePORsp.setCancelType(atomReqBO.getCancelType());
            }
            if (!StringUtils.isBlank((CharSequence)atomReqBO.getCancelReason())) {
                ordAfterServicePORsp.setCancelReason(atomReqBO.getCancelReason());
            }
            ordAfterServicePORsp.setCancelOperId(atomReqBO.getCancelOperId());
            ordAfterServicePORsp.setCancelOperName(atomReqBO.getCancelOperName());
            ordAfterServicePORsp.setCancelTime(new Date());
            int isUpdate = this.ordAfterServiceMapper.updateById(ordAfterServicePORsp);
            if (isUpdate < 1) {
                rsp.setRespCode("101018");
                rsp.setRespDesc("\u8bb0\u5f55\u53d6\u6d88\u7c7b\u578b\uff0c\u53d6\u6d88\u539f\u56e0\uff0c\u53d6\u6d88\u5de5\u53f7\uff0c\u5e76\u4e14\u66f4\u65b0\u552e\u540e\u670d\u52a1\u5355\u72b6\u6001\u5931\u8d25\uff01");
                return rsp;
            }
            OrdAsItemPO queryItemPO = new OrdAsItemPO();
            queryItemPO.setOrderId(atomReqBO.getOrderId());
            queryItemPO.setAfterServId(atomReqBO.getAfterServId());
            List itemPOList = this.ordAsItemMapper.getList(queryItemPO);
            if (itemPOList != null && itemPOList.size() > 0) {
                for (OrdAsItemPO itemPO : itemPOList) {
                    if (null != itemPO.getInspectionItemId()) {
                        OrdInspectionItemPO ordInspectionItemPO = new OrdInspectionItemPO();
                        ordInspectionItemPO.setInspectionItemId(itemPO.getInspectionItemId());
                        ordInspectionItemPO.setOrderId(itemPO.getOrderId());
                        ordInspectionItemPO.setReturnCount(itemPO.getReturnCount());
                        this.ordInspectionItemMapper.updateCounts(ordInspectionItemPO);
                    }
                    OrdItemPO ordItemPO = new OrdItemPO();
                    ordItemPO.setOrderId(itemPO.getOrderId());
                    ordItemPO.setOrdItemId(itemPO.getOrdItemId());
                    ordItemPO.setAfterServingCount(itemPO.getReturnCount().negate());
                    this.ordItemMapper.updateCounts(ordItemPO);
                    if (null != atomReqBO.getIsPurchaseItemCount() && !atomReqBO.getIsPurchaseItemCount().booleanValue()) continue;
                    OrdPurchaseItemPO purchaseItemPO = new OrdPurchaseItemPO();
                    purchaseItemPO.setOrderItemId(ordItemPO.getOrdItemId());
                    purchaseItemPO.setOrderId(ordItemPO.getOrderId());
                    purchaseItemPO = this.ordPurchaseItemMapper.getModelBy(purchaseItemPO);
                    purchaseItemPO.setAfterServingCount(itemPO.getReturnCount().negate());
                    this.ordPurchaseItemMapper.updateById(purchaseItemPO);
                }
            }
            if (atomReqBO.getIsRun().booleanValue()) {
                this.run(ordAfterServicePORsp, atomReqBO);
            }
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u552e\u540e\u670d\u52a1\u53d6\u6d88\u5f02\u5e38", (Throwable)e);
            rsp.setRespCode("101018");
            rsp.setRespDesc("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u552e\u540e\u670d\u52a1\u53d6\u6d88\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff01");
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u552e\u540e\u670d\u52a1\u53d6\u6d88\u539f\u5b50\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private void run(OrdAfterServicePO ordAfterServicePO, UocCoreAfterServOrderCancelReqBO atomReqBO) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setProcDefKey("after_sale_order_status");
        processRunReqBO.setObjId(ordAfterServicePO.getAfterServId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.AFTER_SERVICE);
        processRunReqBO.setOrderId(ordAfterServicePO.getOrderId());
        processRunReqBO.setVariables(atomReqBO.getVariables());
        processRunReqBO.setOperId("0");
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("101018", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void validateParam(UocCoreAfterServOrderCancelReqBO atomReqBO) {
        if (atomReqBO == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u552e\u540e\u670d\u52a1\u53d6\u6d88\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (atomReqBO.getAfterServId() == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u552e\u540e\u670d\u52a1\u53d6\u6d88\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010AfterServId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (atomReqBO.getOrderId() == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u552e\u540e\u670d\u52a1\u53d6\u6d88\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010OrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)atomReqBO.getCancelOperId())) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u552e\u540e\u670d\u52a1\u53d6\u6d88\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010CancelOperId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

