/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.fsc.pay.ability.api.FscShouldPayTerminationAbilityService;
import com.tydic.fsc.pay.ability.bo.FscShouldPayTerminationAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscShouldPayTerminationAbilityRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.http.HttpUtilsPool;
import com.tydic.uoc.busibase.busi.api.PebIntfApplyCancelOrderAbilityService;
import com.tydic.uoc.busibase.busi.bo.PebIntfApplyCancelOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfApplyCancelOrderRspBO;
import com.tydic.uoc.common.ability.bo.AccessoryBO;
import com.tydic.uoc.common.ability.bo.PebExtCancelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtCancelRspBO;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.LianDongDeleteFlowReqBo;
import com.tydic.uoc.common.atom.bo.LianDongDeleteFlowRspBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.common.busi.api.PebExtCancelBusiService;
import com.tydic.uoc.common.busi.api.UocCallPlanCenterBusiService;
import com.tydic.uoc.common.busi.bo.UocCallPlanCenterBusiServiceReqBo;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdCancelMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdFscShouldPayMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdCancelPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdQueryIndexPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdFscShouldPayPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtCancelBusiServiceImpl
implements PebExtCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtCancelBusiServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdCancelMapper ordCancelMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private PebIntfApplyCancelOrderAbilityService pebIntfApplyCancelOrderAbilityService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private UocCallPlanCenterBusiService uocCallPlanCenterBusiService;
    @Autowired
    private UocOrdFscShouldPayMapper ordFscShouldPayMapper;
    @Autowired
    private FscShouldPayTerminationAbilityService fscShouldPayTerminationAbilityService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;
    @Value(value="${LIANDONG_SYSCODE:lsugu}")
    private String sysCode;
    @Value(value="${LIANDONG_DELETE_FLOW_URL:http://59.110.216.211/OSN/api/endFlow/v1}")
    private String delFlowUrl;

    @Override
    public PebExtCancelRspBO dealOrderCancelled(PebExtCancelReqBO reqBO) {
        log.debug("\u6267\u884c\u53d6\u6d88\u8ba2\u5355\u64cd\u4f5c\uff0c\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        this.cancelFscShouldPay(reqBO);
        if (!(UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.PRE_ORDER.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.PAYING.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ZONE_AUDIT.equals(salePO.getSaleState()))) {
            throw new UocProBusinessException("102035", "\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u53d6\u6d88");
        }
        boolean isPush = false;
        if (PecConstant.ORDER_SOURCE.ELEC_AREA.toString().equals(salePO.getOrderSource()) && UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(salePO.getSaleState())) {
            isPush = false;
        }
        OrdCancelPO cancelPo = new OrdCancelPO();
        cancelPo.setId(Long.valueOf(this.idUtil.nextId()));
        if (PecConstant.ORDER_SOURCE.ELEC_AREA.toString().equals(salePO.getOrderSource()) || UocConstant.ORDER_SOURCE.PROTOCOL_GENERATION.toString().equals(salePO.getOrderSource())) {
            this.audit(reqBO, cancelPo);
            isPush = false;
        }
        this.save(salePO, reqBO, isPush, cancelPo);
        this.push(salePO, isPush);
        OrderPO orderPO = new OrderPO();
        orderPO.setCancelReason(reqBO.getCancelReason());
        orderPO.setCancelDesc(reqBO.getCancelReason());
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO.setCancelOperId(reqBO.getUsername());
        orderPO.setCancelTime(new Date());
        this.orderMapper.updateById(orderPO);
        if (!isPush) {
            UocCallPlanCenterBusiServiceReqBo updatePlan = new UocCallPlanCenterBusiServiceReqBo();
            updatePlan.setOrderId(salePO.getOrderId());
            updatePlan.setDirection(false);
            this.uocCallPlanCenterBusiService.updatePlanData(updatePlan);
        }
        this.saveAccessory(reqBO, cancelPo.getId());
        this.run(reqBO);
        PebExtCancelRspBO rspBO = new PebExtCancelRspBO();
        LianDongDeleteFlowReqBo lianDongDeleteFlowReqBo = new LianDongDeleteFlowReqBo();
        lianDongDeleteFlowReqBo.setSysCode(this.sysCode);
        OrdExtMapPO ordExtMapPo = new OrdExtMapPO();
        ordExtMapPo.setOrderId(reqBO.getOrderId());
        ordExtMapPo.setObjType(UocCoreConstant.OBJ_TYPE.ORDER);
        ordExtMapPo.setFieldCode("encryptId");
        OrdExtMapPO modelBy = this.ordExtMapMapper.getModelBy(ordExtMapPo);
        if (modelBy == null) {
            return rspBO;
        }
        lianDongDeleteFlowReqBo.setInstanceId(modelBy.getFieldValue());
        String body = JSONObject.toJSONString((Object)lianDongDeleteFlowReqBo);
        log.debug("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5e9f\u5f03\u8054\u4e1c\u6d41\u7a0b\u5f15\u64ce\u5165\u53c2-------------------------------------------------" + body + "url-----------" + this.delFlowUrl);
        String resultStr = HttpUtilsPool.doPost((String)this.delFlowUrl, (String)body, null);
        log.debug("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5e9f\u5f03\u8054\u4e1c\u6d41\u7a0b\u5f15\u64ce\u51fa\u53c2-------------------------------------------------" + resultStr);
        LianDongDeleteFlowRspBo lianDongDeleteFlowRspBo = (LianDongDeleteFlowRspBo)JSONObject.parseObject((String)resultStr, LianDongDeleteFlowRspBo.class);
        if (!lianDongDeleteFlowRspBo.getState().booleanValue()) {
            log.debug("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5220\u9664\u8054\u4e1c\u6d41\u7a0b\u5f15\u64ce\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + lianDongDeleteFlowRspBo.getMessage());
        }
        rspBO.setPush(Boolean.valueOf(isPush));
        rspBO.setCancelId(cancelPo.getId());
        rspBO.setSaleId(salePO.getSaleVoucherId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveAccessory(PebExtCancelReqBO reqBO, Long cancelId) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            return;
        }
        Long orderId = reqBO.getOrderId();
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (AccessoryBO accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.CANCEL);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(cancelId);
            ordAccessoryPO.setRemark("\u53d6\u6d88\u7533\u8bf7");
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private void run(PebExtCancelReqBO reqBO) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(reqBO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBO.getMemId()));
        HashMap<String, Object> procParam = new HashMap<String, Object>(1);
        procParam.put("approvalResult", "0");
        processRunReqBO.setVariables(procParam);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102035", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void audit(PebExtCancelReqBO reqBO, OrdCancelPO cancelPO) {
        UacNoTaskAuditCreateReqBO noTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        noTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        noTaskAuditCreateReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        noTaskAuditCreateReqBO.setCreateOperName(reqBO.getUsername());
        UacNoTaskAuditCreateInfoReqBO infoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        infoReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        infoReqBO.setUsername(reqBO.getUsername());
        infoReqBO.setRemark("\u8ba2\u5355\u53d6\u6d88\u9700\u8981\u8fdb\u884c\u5ba1\u6279");
        infoReqBO.setOrderId(reqBO.getOrderId());
        infoReqBO.setObjType(UocConstant.OBJ_TYPE.CANCEL);
        infoReqBO.setObjNum("1");
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        noTaskAuditCreateReqBO.setProcDefKey("cancelOrder");
        approvalObjBO.setObjId(String.valueOf(cancelPO.getId()));
        approvalObjBO.setOrderId(cancelPO.getOrderId());
        ArrayList<ApprovalObjBO> objBOS = new ArrayList<ApprovalObjBO>(1);
        objBOS.add(approvalObjBO);
        infoReqBO.setApprovalObjInfo(objBOS);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> infoReqBOS = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
        infoReqBOS.add(infoReqBO);
        noTaskAuditCreateReqBO.setCreateBusiReqBO(infoReqBOS);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(noTaskAuditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new UocProBusinessException("102035", "\u8c03\u7528\u5ba1\u6279\u521b\u5efa\u5931\u8d25" + uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        log.debug("\u5ba1\u6279\u521b\u5efa\u8fd4\u56de" + JSONObject.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        cancelPO.setStepId(uacNoTaskAuditCreateRspBO.getStepId());
    }

    private void push(OrdSalePO salePO, boolean push) {
        PebIntfApplyCancelOrderRspBO rspBO;
        if (!push) {
            return;
        }
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(salePO.getOrderId().longValue());
        OrdQueryIndexPO indexPO = new OrdQueryIndexPO();
        indexPO.setOrderId(salePO.getOrderId());
        indexPO.setObjType(UocConstant.OBJ_TYPE.SALE);
        indexPO.setObjId(salePO.getSaleVoucherId());
        indexPO = this.ordQueryIndexMapper.getModelBy(indexPO);
        PebIntfApplyCancelOrderReqBO reqBO = new PebIntfApplyCancelOrderReqBO();
        reqBO.setOrderId(indexPO.getOutOrderNo());
        reqBO.setSupId(Long.valueOf(stakeholderPO.getSupNo()));
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setOrderId(salePO.getOrderId());
        mapPO.setFieldCode("jdOrgId");
        mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        mapPO = this.ordExtMapMapper.getModelBy(mapPO);
        if (mapPO != null) {
            reqBO.setOrgId(mapPO.getFieldValue());
        }
        if (!"0000".equals((rspBO = this.pebIntfApplyCancelOrderAbilityService.applyCancel(reqBO)).getRespCode())) {
            throw new UocProBusinessException("102035", rspBO.getRespDesc());
        }
    }

    private void save(OrdSalePO salePO, PebExtCancelReqBO reqBO, boolean push, OrdCancelPO cancelPO) {
        cancelPO.setCancelNo(this.biuldNo("", "QXSQ", "ORDER_CANCEL_NO", salePO.getOrderSource()));
        cancelPO.setCancelReason(reqBO.getCancelReason());
        cancelPO.setOrderId(salePO.getOrderId());
        cancelPO.setSaleVoucherId(salePO.getSaleVoucherId());
        cancelPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        cancelPO.setCreateOperName(reqBO.getUsername());
        cancelPO.setCreateTime(new Date());
        cancelPO.setOrderStatus(salePO.getSaleState());
        if (push) {
            cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.CANCEL_APPLY);
        } else if (PecConstant.ORDER_SOURCE.ELEC_AREA.toString().equals(salePO.getOrderSource())) {
            cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.CANCEL_AUDIT);
        } else {
            cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.CANCEL_AUDIT);
        }
        this.ordCancelMapper.insert(cancelPO);
    }

    private String biuldNo(String planNo, String pro, String voucherNoKey, String orderSource) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        getBo.setOrderSource(orderSource);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102035", voucherNoRsp.getRespDesc());
        }
        if (!voucherNoRsp.isVoucherGenerated()) {
            return this.biuldNo(planNo, pro);
        }
        return voucherNoRsp.getVoucherNo();
    }

    private String biuldNo(String planNo, String pro) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        String no = "";
        if (StringUtils.isNotBlank((CharSequence)pro)) {
            no = no + pro;
        }
        if ((no = no + date + time.substring(time.length() - 6)).equals(planNo)) {
            this.biuldNo(no, pro);
        }
        OrdCancelPO cancelPO = new OrdCancelPO();
        cancelPO.setCancelNo(no);
        int count = this.ordCancelMapper.getCheckBy(cancelPO);
        if (count > 0) {
            this.biuldNo(no, pro);
        }
        return no;
    }

    private void cancelFscShouldPay(PebExtCancelReqBO reqBO) {
        UocOrdFscShouldPayPo ordFscShouldPayPo = new UocOrdFscShouldPayPo();
        ordFscShouldPayPo.setOrderId(reqBO.getOrderId());
        List ordFscShouldPayPos = this.ordFscShouldPayMapper.getList(ordFscShouldPayPo);
        if (ObjectUtil.isNotEmpty((Object)ordFscShouldPayPos)) {
            ArrayList<Long> shouldPayIds = null;
            for (UocOrdFscShouldPayPo fscShouldPayPo : ordFscShouldPayPos) {
                if (null != fscShouldPayPo.getIsPayCompleted() && 1 == fscShouldPayPo.getIsPayCompleted()) {
                    log.info("\u90e8\u5206\u5e94\u4ed8\u8bb0\u5f55\u5df2\u7ecf\u652f\u4ed8\u5b8c\u6210\uff1a{}", (Object)JSON.toJSONString((Object)fscShouldPayPo));
                    continue;
                }
                if (null != fscShouldPayPo.getPaidFee() && fscShouldPayPo.getPaidFee() > 0L) {
                    log.info("\u90e8\u5206\u5e94\u4ed8\u8bb0\u5f55\u5df2\u7ecf\u90e8\u5206\u652f\u4ed8\uff1a{}", (Object)JSON.toJSONString((Object)fscShouldPayPo));
                    continue;
                }
                if (null == shouldPayIds) {
                    shouldPayIds = new ArrayList<Long>();
                }
                shouldPayIds.add(fscShouldPayPo.getFscShouldPayId());
            }
            if (ObjectUtil.isNotEmpty(shouldPayIds)) {
                FscShouldPayTerminationAbilityReqBO fscShouldPayTerminationAbilityReqBO = new FscShouldPayTerminationAbilityReqBO();
                fscShouldPayTerminationAbilityReqBO.setShouldPayIds(shouldPayIds);
                FscShouldPayTerminationAbilityRspBO fscShouldPayTerminationAbilityRspBO = this.fscShouldPayTerminationAbilityService.dealShouldPayTermination(fscShouldPayTerminationAbilityReqBO);
                if (!"0000".equals(fscShouldPayTerminationAbilityRspBO.getRespCode())) {
                    throw new UocProBusinessException(fscShouldPayTerminationAbilityRspBO.getRespCode(), fscShouldPayTerminationAbilityRspBO.getRespDesc());
                }
            }
        }
    }
}

