/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.bo.SaleOrderInfoIntfceReqBO;
import com.tydic.uoc.common.ability.bo.SaleOrderYanBaoIntfceReqBo;
import com.tydic.uoc.common.ability.bo.SalePecOrderItemIntfceBO;
import com.tydic.uoc.common.ability.bo.SkuInfoRspBO;
import com.tydic.uoc.common.atom.api.UocPebInsuranceTransAtomService;
import com.tydic.uoc.common.atom.api.UocPebPriceCalculationAtomService;
import com.tydic.uoc.common.atom.api.UocPebQryAccountBalanceAtomService;
import com.tydic.uoc.common.atom.api.UocPebQrySkuExitAtomService;
import com.tydic.uoc.common.atom.api.UocPebQrySkuInfoAndPriceAtomService;
import com.tydic.uoc.common.atom.bo.InsuranceTransFeeInfoBO;
import com.tydic.uoc.common.atom.bo.InsuranceTransSkuInfoBO;
import com.tydic.uoc.common.atom.bo.InsuranceTransYanBaoInfoBO;
import com.tydic.uoc.common.atom.bo.OrderBO;
import com.tydic.uoc.common.atom.bo.OrderItemBO;
import com.tydic.uoc.common.atom.bo.UocPebInsuranceTransReqBO;
import com.tydic.uoc.common.atom.bo.UocPebInsuranceTransRespBO;
import com.tydic.uoc.common.atom.bo.UocPebPriceCalculationReqBO;
import com.tydic.uoc.common.atom.bo.UocPebPriceCalculationRespBO;
import com.tydic.uoc.common.atom.bo.UocPebQryAccountBalanceReqBO;
import com.tydic.uoc.common.atom.bo.UocPebQryAccountBalanceRespBO;
import com.tydic.uoc.common.atom.bo.UocPebQrySkuExitReqBO;
import com.tydic.uoc.common.atom.bo.UocPebQrySkuExitRespBO;
import com.tydic.uoc.common.atom.bo.UocPebQrySkuInfoAndPriceReqBO;
import com.tydic.uoc.common.atom.bo.UocPebQrySkuInfoAndPriceRespBO;
import com.tydic.uoc.common.atom.bo.YanbaoBO;
import com.tydic.uoc.common.busi.api.UocPebCreateOrderCheckBusiService;
import com.tydic.uoc.common.busi.bo.UocPebCreateOrderCheckReqBO;
import com.tydic.uoc.common.busi.bo.UocPebCreateOrderCheckRspBO;
import com.tydic.uoc.dao.ConfSupplierMapper;
import com.tydic.uoc.po.ConfSupplierPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocPebCreateOrderCheckBusiService")
public class UocPebCreateOrderCheckBusiServiceImpl
implements UocPebCreateOrderCheckBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebCreateOrderCheckBusiServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private UocPebPriceCalculationAtomService uocPebPriceCalculationAtomService;
    @Autowired
    private UocPebQrySkuExitAtomService uocPebQrySkuExitAtomService;
    @Autowired
    private UocPebQrySkuInfoAndPriceAtomService uocPebQrySkuInfoAndPriceAtomService;
    @Autowired
    private UocPebInsuranceTransAtomService uocPebInsuranceTransAtomService;
    @Autowired
    private UocPebQryAccountBalanceAtomService uocPebQryAccountBalanceAtomService;
    @Autowired
    private ConfSupplierMapper confSupplierMapper;

    @Override
    public UocPebCreateOrderCheckRspBO dealPebCreateOrderCheck(UocPebCreateOrderCheckReqBO uocPebCreateOrderCheckReqBO) {
        UocPebPriceCalculationReqBO uocPebPriceCalculationReqBO;
        UocPebPriceCalculationRespBO uocPebPriceCalculationRespBO;
        UocPebCreateOrderCheckRspBO uocPebCreateOrderCheckRspBO = new UocPebCreateOrderCheckRspBO();
        if (uocPebCreateOrderCheckReqBO.getPreOrder() != null && uocPebCreateOrderCheckReqBO.getPreOrder() == 1 && CollectionUtils.isNotEmpty(uocPebCreateOrderCheckReqBO.getSaleOrderInfoList())) {
            for (SaleOrderInfoIntfceReqBO infoIntfceReqBO : uocPebCreateOrderCheckReqBO.getSaleOrderInfoList()) {
                ConfSupplierPO confSupplierPO = new ConfSupplierPO();
                confSupplierPO.setSupNo(infoIntfceReqBO.getGoodsSupplierId());
                try {
                    confSupplierPO = this.confSupplierMapper.getModelBy(confSupplierPO);
                }
                catch (Exception e) {
                    throw new UocProBusinessException("102068", "\u67e5\u8be2\u9650\u989d\u914d\u7f6e\u5f02\u5e38");
                }
                if (confSupplierPO == null || !CollectionUtils.isNotEmpty((Collection)infoIntfceReqBO.getSaleOrderItemList())) continue;
                Long total = 0L;
                for (SalePecOrderItemIntfceBO itemIntfceBO : infoIntfceReqBO.getSaleOrderItemList()) {
                    try {
                        total = total + UocMoneyUtil.bigDecimal2Long((BigDecimal)itemIntfceBO.getSkuSalePrice()) * itemIntfceBO.getPurchaseCount().longValue();
                    }
                    catch (Exception e) {
                        throw new UocProBusinessException("102068", "\u6570\u636e\u8f6c\u6362\u9519\u8bef");
                    }
                }
                if (confSupplierPO.getOrderQuota() >= total) continue;
                throw new UocProBusinessException("102068", "\u5f53\u524d\u8ba2\u5355\u5df2\u8d85\u51fa\u91c7\u8d2d\u9650\u989d\uff0c\u8bf7\u76f4\u63a5\u70b9\u51fb\u201c\u751f\u6210\u8ba2\u5355\u201d\u8d70\u5ba1\u6279\u6d41\u7a0b\u201d");
            }
        }
        if (!"0000".equals((uocPebPriceCalculationRespBO = this.uocPebPriceCalculationAtomService.dealUocPebPriceCalculation(uocPebPriceCalculationReqBO = this.buildUocPebPriceCalculationParm(uocPebCreateOrderCheckReqBO))).getRespCode())) {
            throw new UocProBusinessException("102068", this.buildExceptionMsg("\u8ba2\u5355\u603b\u4ef7\u6821\u9a8c\u5931\u8d25!", uocPebPriceCalculationRespBO.getRespDesc()));
        }
        UocPebQrySkuExitReqBO uocPebQrySkuExitReqBO = this.buildQrySkuParm(uocPebCreateOrderCheckReqBO);
        UocPebQrySkuExitRespBO uocPebQrySkuExitRespBO = this.uocPebQrySkuExitAtomService.qrySkuExit(uocPebQrySkuExitReqBO);
        if (!"0000".equals(uocPebQrySkuExitRespBO.getRespCode())) {
            throw new UocProBusinessException("102068", this.buildExceptionMsg("\u67e5\u8be2\u5546\u54c1\u5728\u8d2d\u7269\u8f66\u4e2d\u662f\u5426\u5b58\u5728\u5931\u8d25!", uocPebQrySkuExitRespBO.getRespDesc()));
        }
        UocPebQrySkuInfoAndPriceReqBO uocPebQrySkuInfoAndPriceReqBO = this.buildQrySkuInfoAndPriceParm(uocPebCreateOrderCheckReqBO);
        UocPebQrySkuInfoAndPriceRespBO uocPebQrySkuInfoAndPriceRespBO = this.uocPebQrySkuInfoAndPriceAtomService.qrySkuInfoAndPrice(uocPebQrySkuInfoAndPriceReqBO);
        if (!"0000".equals(uocPebQrySkuInfoAndPriceRespBO.getRespCode())) {
            throw new UocProBusinessException("102068", this.buildExceptionMsg("\u5546\u54c1\u7684\u5ef6\u4fdd\u4fe1\u606f\u548c\u4ef7\u683c\u6821\u9a8c\u5931\u8d25!", uocPebQrySkuInfoAndPriceRespBO.getRespDesc()));
        }
        List<Map<Long, Object>> skuInfoMapList = uocPebQrySkuInfoAndPriceRespBO.getSkuInfoMapList();
        UocPebQryAccountBalanceReqBO uocPebQryAccountBalanceReqBO = this.buildQryAccountBalanceParm(uocPebCreateOrderCheckReqBO);
        UocPebQryAccountBalanceRespBO uocPebQryAccountBalanceRespBO = this.uocPebQryAccountBalanceAtomService.qryAccountBalance(uocPebQryAccountBalanceReqBO);
        if (!"0000".equals(uocPebQryAccountBalanceRespBO.getRespCode())) {
            throw new UocProBusinessException("102068", this.buildExceptionMsg("\u8d26\u6237\u4f59\u989d\u6821\u9a8c\u5931\u8d25!", uocPebQryAccountBalanceRespBO.getRespDesc()));
        }
        UocPebInsuranceTransReqBO uocPebInsuranceTransReqBO = this.buildQryInsuranceTransParm(skuInfoMapList, uocPebCreateOrderCheckReqBO);
        UocPebInsuranceTransRespBO uocPebInsuranceTransRespBO = this.uocPebInsuranceTransAtomService.qrynsuranceTrans(uocPebInsuranceTransReqBO);
        if (!"0000".equals(uocPebInsuranceTransRespBO.getRespCode())) {
            throw new UocProBusinessException("102068", this.buildExceptionMsg("\u5ef6\u4fdd\u4fe1\u606f\u67e5\u8be2\u548c\u8fd0\u8d39\u8ba1\u7b97\u5931\u8d25!", uocPebInsuranceTransRespBO.getRespDesc()));
        }
        uocPebCreateOrderCheckRspBO.setUocPebPriceCalculationRespBO(uocPebPriceCalculationRespBO);
        uocPebCreateOrderCheckRspBO.setSkuInfoMapList(skuInfoMapList);
        uocPebCreateOrderCheckRspBO.setUocPebInsuranceTransRespBO(uocPebInsuranceTransRespBO);
        uocPebCreateOrderCheckRspBO.setRespCode("0000");
        uocPebCreateOrderCheckRspBO.setRespDesc("\u6821\u9a8c\u6210\u529f");
        return uocPebCreateOrderCheckRspBO;
    }

    private UocPebPriceCalculationReqBO buildUocPebPriceCalculationParm(UocPebCreateOrderCheckReqBO uocPebCreateOrderCheckReqBO) {
        UocPebPriceCalculationReqBO uocPebPriceCalculationReqBO = new UocPebPriceCalculationReqBO();
        LinkedList<OrderBO> orders = new LinkedList<OrderBO>();
        List<SaleOrderInfoIntfceReqBO> saleOrderInfoList = uocPebCreateOrderCheckReqBO.getSaleOrderInfoList();
        for (SaleOrderInfoIntfceReqBO saleOrderInfoIntfceReqBO : saleOrderInfoList) {
            OrderBO order = new OrderBO();
            order.setGoodsSupplierId(saleOrderInfoIntfceReqBO.getGoodsSupplierId());
            order.setTatleTransportationFee(saleOrderInfoIntfceReqBO.getTatleTransportationFee());
            LinkedList<OrderItemBO> orderItems = new LinkedList<OrderItemBO>();
            List saleOrderItemList = saleOrderInfoIntfceReqBO.getSaleOrderItemList();
            for (SalePecOrderItemIntfceBO saleOrderItemIntfceBO : saleOrderItemList) {
                OrderItemBO orderItem = new OrderItemBO();
                orderItem.setPurchaseCount(saleOrderItemIntfceBO.getPurchaseCount());
                orderItem.setSkuId(saleOrderItemIntfceBO.getSkuId());
                orderItem.setSpuId(saleOrderItemIntfceBO.getSpuId());
                orderItem.setSkuSalePrice(saleOrderItemIntfceBO.getSkuSalePrice());
                List saleOrderYanBaoList = saleOrderItemIntfceBO.getSaleOrderYanBaoList();
                if (null != saleOrderYanBaoList && !saleOrderYanBaoList.isEmpty()) {
                    LinkedList<YanbaoBO> yanbaos = new LinkedList<YanbaoBO>();
                    for (SaleOrderYanBaoIntfceReqBo saleOrderYanBaoIntfceReqBo : saleOrderYanBaoList) {
                        YanbaoBO yanbao = new YanbaoBO();
                        yanbao.setBindSkuId(Long.valueOf(saleOrderYanBaoIntfceReqBo.getBindSkuId()));
                        yanbao.setBindSkuCount(saleOrderYanBaoIntfceReqBo.getBindSkuCount());
                        yanbao.setPrice(saleOrderYanBaoIntfceReqBo.getPrice());
                        yanbaos.add(yanbao);
                    }
                    orderItem.setYanbaos(yanbaos);
                }
                orderItems.add(orderItem);
            }
            order.setOrderItems(orderItems);
            orders.add(order);
        }
        uocPebPriceCalculationReqBO.setTotalAmount(uocPebCreateOrderCheckReqBO.getTotalAmount());
        uocPebPriceCalculationReqBO.setOrders(orders);
        return uocPebPriceCalculationReqBO;
    }

    private UocPebQrySkuExitReqBO buildQrySkuParm(UocPebCreateOrderCheckReqBO uocPebCreateOrderCheckReqBO) {
        UocPebQrySkuExitReqBO uocPebQrySkuExitReqBO = new UocPebQrySkuExitReqBO();
        uocPebQrySkuExitReqBO.setUserId(uocPebCreateOrderCheckReqBO.getUserId());
        ArrayList<Long> skuIds = new ArrayList<Long>();
        List<SaleOrderInfoIntfceReqBO> saleOrderInfoList = uocPebCreateOrderCheckReqBO.getSaleOrderInfoList();
        for (int i = 0; i < saleOrderInfoList.size(); ++i) {
            List saleOrderItemList = saleOrderInfoList.get(i).getSaleOrderItemList();
            for (int j = 0; j < saleOrderItemList.size(); ++j) {
                skuIds.add(Long.valueOf(((SalePecOrderItemIntfceBO)saleOrderItemList.get(j)).getSkuId()));
            }
        }
        uocPebQrySkuExitReqBO.setSkuIds(skuIds);
        uocPebQrySkuExitReqBO.setUserId(uocPebCreateOrderCheckReqBO.getUserId());
        return uocPebQrySkuExitReqBO;
    }

    private UocPebQrySkuInfoAndPriceReqBO buildQrySkuInfoAndPriceParm(UocPebCreateOrderCheckReqBO uocPebCreateOrderCheckReqBO) {
        UocPebQrySkuInfoAndPriceReqBO uocPebQrySkuInfoAndPriceReqBO = new UocPebQrySkuInfoAndPriceReqBO();
        uocPebQrySkuInfoAndPriceReqBO.setUserId(uocPebCreateOrderCheckReqBO.getUserId());
        uocPebQrySkuInfoAndPriceReqBO.setPurchaseAccountId(uocPebCreateOrderCheckReqBO.getUserId());
        uocPebQrySkuInfoAndPriceReqBO.setSaleOrderInfoList(uocPebCreateOrderCheckReqBO.getSaleOrderInfoList());
        uocPebQrySkuInfoAndPriceReqBO.setReceiverProvinceId(uocPebCreateOrderCheckReqBO.getAddressInfo().getReceiverProvinceId());
        uocPebQrySkuInfoAndPriceReqBO.setReceiverCityId(uocPebCreateOrderCheckReqBO.getAddressInfo().getReceiverCityId());
        return uocPebQrySkuInfoAndPriceReqBO;
    }

    private UocPebInsuranceTransReqBO buildQryInsuranceTransParm(List<Map<Long, Object>> mapList, UocPebCreateOrderCheckReqBO uocPebCreateOrderCheckReqBO) {
        UocPebInsuranceTransReqBO uocPebInsuranceTransReqBO = new UocPebInsuranceTransReqBO();
        ArrayList<InsuranceTransFeeInfoBO> insuranceTransFeeInfoList = new ArrayList<InsuranceTransFeeInfoBO>();
        List<SaleOrderInfoIntfceReqBO> saleOrderInfoList = uocPebCreateOrderCheckReqBO.getSaleOrderInfoList();
        for (int i = 0; i < saleOrderInfoList.size(); ++i) {
            InsuranceTransFeeInfoBO insuranceTransFeeInfo = new InsuranceTransFeeInfoBO();
            insuranceTransFeeInfo.setProvince(Integer.valueOf(uocPebCreateOrderCheckReqBO.getAddressInfo().getReceiverProvinceId()));
            insuranceTransFeeInfo.setCity(Integer.valueOf(uocPebCreateOrderCheckReqBO.getAddressInfo().getReceiverCityId()));
            insuranceTransFeeInfo.setCounty(Integer.valueOf(uocPebCreateOrderCheckReqBO.getAddressInfo().getReceiverCountyId()));
            if (StringUtils.isNotBlank((CharSequence)uocPebCreateOrderCheckReqBO.getAddressInfo().getReceiverTownId())) {
                insuranceTransFeeInfo.setTown(Integer.valueOf(uocPebCreateOrderCheckReqBO.getAddressInfo().getReceiverTownId()));
            } else {
                insuranceTransFeeInfo.setTown(0);
            }
            insuranceTransFeeInfo.setSupplierId(saleOrderInfoList.get(i).getGoodsSupplierId());
            insuranceTransFeeInfo.setTransportFee(saleOrderInfoList.get(i).getTatleTransportationFee());
            insuranceTransFeeInfo.setPaymentType(uocPebCreateOrderCheckReqBO.getPayType());
            ArrayList<InsuranceTransSkuInfoBO> insuranceTransSkuInfoList = new ArrayList<InsuranceTransSkuInfoBO>();
            List saleOrderItemList = saleOrderInfoList.get(i).getSaleOrderItemList();
            for (int j = 0; j < saleOrderItemList.size(); ++j) {
                for (int n = 0; n < mapList.size(); ++n) {
                    Map<Long, Object> map = mapList.get(n);
                    if (null == map || !map.containsKey(((SalePecOrderItemIntfceBO)saleOrderItemList.get(j)).getSkuId())) continue;
                    InsuranceTransSkuInfoBO insuranceTransSkuInfo = new InsuranceTransSkuInfoBO();
                    SkuInfoRspBO skuInfoRspBO = (SkuInfoRspBO)map.get(((SalePecOrderItemIntfceBO)saleOrderItemList.get(j)).getSkuId());
                    insuranceTransSkuInfo.setExtSkuId(skuInfoRspBO.getSkuExtSkuId());
                    insuranceTransSkuInfo.setSkuId(skuInfoRspBO.getSkuId());
                    insuranceTransSkuInfo.setSkuNum(((SalePecOrderItemIntfceBO)saleOrderItemList.get(j)).getPurchaseCount());
                    ArrayList<InsuranceTransYanBaoInfoBO> insuranceTransYanBaoInfoList = new ArrayList<InsuranceTransYanBaoInfoBO>();
                    List saleOrderYanBaoList = ((SalePecOrderItemIntfceBO)saleOrderItemList.get(j)).getSaleOrderYanBaoList();
                    if (null != saleOrderYanBaoList && !saleOrderYanBaoList.isEmpty()) {
                        for (int k = 0; k < saleOrderYanBaoList.size(); ++k) {
                            InsuranceTransYanBaoInfoBO insuranceTransYanBaoInfo = new InsuranceTransYanBaoInfoBO();
                            insuranceTransYanBaoInfo.setInsuranceCode(((SaleOrderYanBaoIntfceReqBo)saleOrderYanBaoList.get(k)).getInsuranceCode());
                            insuranceTransYanBaoInfo.setBindSkuId(((SaleOrderYanBaoIntfceReqBo)saleOrderYanBaoList.get(k)).getBindSkuId().toString());
                            insuranceTransYanBaoInfo.setPrice(((SaleOrderYanBaoIntfceReqBo)saleOrderYanBaoList.get(k)).getPrice());
                            insuranceTransYanBaoInfoList.add(insuranceTransYanBaoInfo);
                        }
                    }
                    insuranceTransSkuInfo.setInsuranceTransYanBaoInfoList(insuranceTransYanBaoInfoList);
                    insuranceTransSkuInfoList.add(insuranceTransSkuInfo);
                }
            }
            insuranceTransFeeInfo.setInsuranceTransSkuInfoList(insuranceTransSkuInfoList);
            insuranceTransFeeInfoList.add(insuranceTransFeeInfo);
        }
        uocPebInsuranceTransReqBO.setInsuranceTransFeeInfoList(insuranceTransFeeInfoList);
        return uocPebInsuranceTransReqBO;
    }

    private UocPebQryAccountBalanceReqBO buildQryAccountBalanceParm(UocPebCreateOrderCheckReqBO uocPebCreateOrderCheckReqBO) {
        UocPebQryAccountBalanceReqBO uocPebQryAccountBalanceReqBO = new UocPebQryAccountBalanceReqBO();
        uocPebQryAccountBalanceReqBO.setOperatingUnitNo(uocPebCreateOrderCheckReqBO.getProfessionalOrganizationId());
        uocPebQryAccountBalanceReqBO.setPurchaseBookNo(uocPebCreateOrderCheckReqBO.getPurchaserAccount());
        uocPebQryAccountBalanceReqBO.setPurchaseUnitNo(uocPebCreateOrderCheckReqBO.getPurchaserAccountOrgId());
        uocPebQryAccountBalanceReqBO.setTxnAmount(uocPebCreateOrderCheckReqBO.getTotalAmount());
        return uocPebQryAccountBalanceReqBO;
    }

    private String buildExceptionMsg(String msg, String desc) {
        StringBuilder builder = new StringBuilder(msg);
        return builder.append(desc).toString();
    }
}

