/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONArray;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.busi.api.UocProSaveOutInterfaceLogBusiService;
import com.tydic.uoc.common.busi.bo.UocProSaveOutInterfaceLogBusiReqBo;
import com.tydic.uoc.common.busi.bo.UocProSaveOutInterfaceLogBusiRspBo;
import com.tydic.uoc.dao.OrdInterLogMapper;
import com.tydic.uoc.po.OrdInterLogPO;
import java.util.Date;
import java.util.Iterator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UocProSaveOutInterfaceLogBusiServiceImpl
implements UocProSaveOutInterfaceLogBusiService {
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private OrdInterLogMapper ordInterLogMapper;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={UocProBusinessException.class})
    public UocProSaveOutInterfaceLogBusiRspBo keepOutInterfaceLog(UocProSaveOutInterfaceLogBusiReqBo reqBo) {
        OrdInterLogPO ordInterLogPo = new OrdInterLogPO();
        ordInterLogPo.setOrderId(reqBo.getOrderId());
        ordInterLogPo.setObjId(reqBo.getObjId());
        ordInterLogPo.setObjType(reqBo.getObjType());
        ordInterLogPo.setInterSn(reqBo.getInterSn());
        ordInterLogPo.setInterCode(reqBo.getInterCode());
        ordInterLogPo.setFlowFlag(reqBo.getFlowFlag());
        reqBo.setInContent(this.dealSuperLongContent(reqBo.getInContent()));
        reqBo.setOutContent(this.dealSuperLongContent(reqBo.getOutContent()));
        ordInterLogPo.setInContent(reqBo.getInContent());
        ordInterLogPo.setOutContent(reqBo.getOutContent());
        ordInterLogPo = this.ordInterLogMapper.getordInterLogPOBy(ordInterLogPo);
        if (null == ordInterLogPo) {
            ordInterLogPo = new OrdInterLogPO();
            BeanUtil.copyProperties((Object)reqBo, (Object)ordInterLogPo);
            ordInterLogPo.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
            ordInterLogPo.setCreateTime(new Date());
            ordInterLogPo.setCallCount(Integer.valueOf(1));
            this.ordInterLogMapper.insert(ordInterLogPo);
        } else {
            ordInterLogPo.setCallTime(reqBo.getCallTime());
            ordInterLogPo.setRetTime(reqBo.getRetTime());
            ordInterLogPo.setCallState(reqBo.getCallState());
            ordInterLogPo.setErrCode(reqBo.getErrCode());
            ordInterLogPo.setErrDetail(reqBo.getErrDetail());
            this.ordInterLogMapper.updateCallCount(ordInterLogPo);
        }
        UocProSaveOutInterfaceLogBusiRspBo rspBo = new UocProSaveOutInterfaceLogBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String dealSuperLongContent(String content) {
        if (content.length() > UocConstant.CreateOrder.CONTENT_LENGTH) {
            JSONObject jsonObject = JSON.parseObject((String)content);
            Iterator jsonIterator = jsonObject.keySet().iterator();
            while (jsonIterator.hasNext()) {
                Object jsonObjectItem = jsonObject.get(jsonIterator.next());
                if (!(jsonObjectItem instanceof com.alibaba.fastjson.JSONArray) && !(jsonObjectItem instanceof JSONArray)) continue;
                jsonIterator.remove();
                if (JSON.toJSONString((Object)jsonObject).length() > UocConstant.CreateOrder.CONTENT_LENGTH) continue;
                break;
            }
            if ((content = JSON.toJSONString((Object)jsonObject)).length() > UocConstant.CreateOrder.CONTENT_LENGTH) {
                content = content.substring(UocConstant.CreateOrder.CONTENT_LENGTH);
            }
        }
        return content;
    }
}

