/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.AfterServBO;
import com.tydic.uoc.common.ability.bo.OrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.OrdShipItemRspBO;
import com.tydic.uoc.common.ability.bo.OrdStakeholderRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdShipItemRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdShipRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdStakeholderRspBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsQueryRspBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocCoreShipDetailsQueryAtomService;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreShipDetailsQueryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreShipDetailsQueryRspBO;
import com.tydic.uoc.common.busi.api.UocShipDetailsListQueryBusiService;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocShipDetailsQueryBusiService")
public class UocShipDetailsListQueryBusiServiceImpl
implements UocShipDetailsListQueryBusiService {
    @Autowired
    private UocCoreShipDetailsQueryAtomService uocCoreShipDetailsQueryAtomService;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public UocShipDetailsListQueryRspBO getShipDetailsQuery(UocShipDetailsListQueryReqBO reqBO) {
        UocShipDetailsListQueryRspBO rspBO = new UocShipDetailsListQueryRspBO();
        this.validateParams(reqBO);
        if (null != reqBO.getShipVoucherId()) {
            ArrayList<UocShipDetailsQueryRspBO> shipDetailsQueryRspBOList = new ArrayList<UocShipDetailsQueryRspBO>();
            OrdShipPO ordShipPO = this.ordShipMapper.getModelById(reqBO.getShipVoucherId().longValue());
            UocCoreShipDetailsQueryRspBO atomRspBO = this.transferAtomService(reqBO, false);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                rspBO.setRespCode(atomRspBO.getRespCode());
                rspBO.setRespDesc(atomRspBO.getRespDesc());
                return rspBO;
            }
            UocShipDetailsQueryRspBO uocShipDetailsQueryRspBO = this.buildAtomRspBO(atomRspBO, ordShipPO, true, reqBO);
            this.transOrdShip(uocShipDetailsQueryRspBO.getOrdShipRspBO());
            this.buildOrdStakeholderRspBO(uocShipDetailsQueryRspBO.getOrdShipRspBO());
            shipDetailsQueryRspBOList.add(uocShipDetailsQueryRspBO);
            rspBO.setShipDetailsQueryRspBOList(shipDetailsQueryRspBOList);
        } else {
            OrdShipPO shipPO = new OrdShipPO();
            shipPO.setOrderId(reqBO.getOrderId());
            if (null != reqBO.getShipStatus()) {
                shipPO.setShipStatus(String.valueOf(reqBO.getShipStatus()));
            }
            if (Integer.valueOf(1).equals(reqBO.getAbnormalDimension())) {
                shipPO.setShipStatusList(Arrays.asList("1203", "1205"));
            } else if (Integer.valueOf(2).equals(reqBO.getAbnormalDimension())) {
                shipPO.setShipStatusList(Arrays.asList("1204", "2205"));
            }
            List ordShipPOList = this.ordShipMapper.getList(shipPO);
            if (!CollectionUtils.isNotEmpty((Collection)ordShipPOList)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u53d1\u8d27\u5355\u4fe1\u606f:" + reqBO.getOrderId());
                return rspBO;
            }
            ArrayList<UocShipDetailsQueryRspBO> shipDetailsQueryRspBOList = new ArrayList<UocShipDetailsQueryRspBO>();
            for (OrdShipPO ordShipPO : ordShipPOList) {
                reqBO.setShipVoucherId(ordShipPO.getShipVoucherId());
                UocCoreShipDetailsQueryRspBO atomRspBO = new UocCoreShipDetailsQueryRspBO();
                if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) && !"0000".equals((atomRspBO = this.transferAtomService(reqBO, true)).getRespCode())) {
                    rspBO.setRespCode(atomRspBO.getRespCode());
                    rspBO.setRespDesc(atomRspBO.getRespDesc());
                    return rspBO;
                }
                UocShipDetailsQueryRspBO uocShipDetailsQueryRspBO = this.buildAtomRspBO(atomRspBO, ordShipPO, true, reqBO);
                this.transOrdShip(uocShipDetailsQueryRspBO.getOrdShipRspBO());
                this.buildOrdStakeholderRspBO(uocShipDetailsQueryRspBO.getOrdShipRspBO());
                shipDetailsQueryRspBOList.add(uocShipDetailsQueryRspBO);
            }
            rspBO.setShipDetailsQueryRspBOList(shipDetailsQueryRspBOList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParams(UocShipDetailsListQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
    }

    private UocOrdShipRspBO buildOrdShipRspBO(OrdShipPO ordShipPO) {
        UocOrdShipRspBO ordShipRspBO = new UocOrdShipRspBO();
        BeanUtils.copyProperties((Object)ordShipPO, (Object)ordShipRspBO);
        ordShipRspBO.setShipExtraMap(this.buildShipExtraInfoMap(ordShipPO));
        AfterServBO afterServBO = new AfterServBO();
        afterServBO.setShipVoucherId(ordShipPO.getShipVoucherId());
        afterServBO.setOrderId(ordShipPO.getOrderId());
        ArrayList<Integer> notStatus = new ArrayList<Integer>(7);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.SUCCESS);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.CONFIRM);
        notStatus.add(UocConstant.ZONE_AFS_STATUS.PUR_COMPLETE);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.APPROVAL_FAILURE);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.CANCEL);
        notStatus.add(UocConstant.ZONE_AFS_STATUS.REFUSE);
        notStatus.add(UocConstant.ZONE_AFS_STATUS.CANCEL);
        afterServBO.setNotStatus(notStatus);
        int notEndCount = this.ordAfterServiceMapper.getNotEndCount(afterServBO);
        if (0 < notEndCount) {
            ordShipRspBO.setIsUndoneAfter(Integer.valueOf(0));
        } else {
            ordShipRspBO.setIsUndoneAfter(Integer.valueOf(1));
        }
        return ordShipRspBO;
    }

    private Map<String, String> buildShipExtraInfoMap(OrdShipPO ordShipPO) {
        HashMap<String, String> orderExtraMap = new HashMap<String, String>(16);
        OrdExtMapPO ordExtMapCondition = new OrdExtMapPO();
        ordExtMapCondition.setOrderId(ordShipPO.getOrderId());
        ordExtMapCondition.setObjId(ordShipPO.getShipVoucherId());
        ordExtMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
        List ordExtMapList = this.ordExtMapMapper.getList(ordExtMapCondition);
        if (!CollectionUtils.isEmpty((Collection)ordExtMapList)) {
            for (OrdExtMapPO ordExtMap : ordExtMapList) {
                orderExtraMap.put(ordExtMap.getFieldCode(), ordExtMap.getFieldValue());
            }
        }
        return orderExtraMap;
    }

    private UocCoreShipDetailsQueryRspBO transferAtomService(UocShipDetailsListQueryReqBO reqBO, Boolean isQueryLevel) {
        UocCoreShipDetailsQueryReqBO atomReqBO = new UocCoreShipDetailsQueryReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)atomReqBO);
        atomReqBO.setOrderId(reqBO.getOrderId());
        atomReqBO.setShipVoucherId(reqBO.getShipVoucherId());
        if (isQueryLevel.booleanValue()) {
            atomReqBO.setQueryLevel(UocCoreConstant.QUERY_LEVEL.QUERY_ITEM);
        }
        return this.uocCoreShipDetailsQueryAtomService.getShipDetailsQuery(atomReqBO);
    }

    private UocShipDetailsQueryRspBO buildAtomRspBO(UocCoreShipDetailsQueryRspBO atomRspBO, OrdShipPO ordShipPO, Boolean isBuildPrimary, UocShipDetailsListQueryReqBO reqBO) {
        UocOrdShipRspBO uocOrdShipRspBO;
        UocShipDetailsQueryRspBO uocShipDetailsQueryRspBO = new UocShipDetailsQueryRspBO();
        if (isBuildPrimary.booleanValue()) {
            uocOrdShipRspBO = this.buildOrdShipRspBO(ordShipPO);
            if (uocOrdShipRspBO.getEstimateArrivalTime() == null) {
                OrdSalePO ordSalePO = new OrdSalePO();
                ordSalePO.setOrderId(reqBO.getOrderId());
                ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    uocOrdShipRspBO.setEstimateArrivalTime(df.parse(ordSalePO.getGiveTime()));
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            if (uocOrdShipRspBO.getShipTime() == null) {
                uocOrdShipRspBO.setShipTime(uocOrdShipRspBO.getCreateTime());
            }
            uocShipDetailsQueryRspBO.setOrdShipRspBO(uocOrdShipRspBO);
        } else {
            uocOrdShipRspBO = new UocOrdShipRspBO();
            BeanUtils.copyProperties((Object)atomRspBO.getOrdShipRspBO(), (Object)uocOrdShipRspBO);
            uocShipDetailsQueryRspBO.setOrdShipRspBO(uocOrdShipRspBO);
        }
        if (CollectionUtils.isNotEmpty(atomRspBO.getShipAccessoryRspList())) {
            ArrayList<UocOrdAccessoryRspBO> ordAccessoryRspBOList = new ArrayList<UocOrdAccessoryRspBO>();
            for (OrdAccessoryRspBO ordAccessoryRspBO : atomRspBO.getShipAccessoryRspList()) {
                UocOrdAccessoryRspBO uocOrdAccessoryRspBO = new UocOrdAccessoryRspBO();
                BeanUtils.copyProperties((Object)ordAccessoryRspBO, (Object)uocOrdAccessoryRspBO);
                ordAccessoryRspBOList.add(uocOrdAccessoryRspBO);
            }
            uocShipDetailsQueryRspBO.setShipAccessoryRspList(ordAccessoryRspBOList);
        }
        if (CollectionUtils.isNotEmpty(atomRspBO.getOrdShipItemRspBOList())) {
            ArrayList<UocOrdShipItemRspBO> ordShipItemRspBOList = new ArrayList<UocOrdShipItemRspBO>();
            for (OrdShipItemRspBO ordShipItemRspBO : atomRspBO.getOrdShipItemRspBOList()) {
                UocOrdShipItemRspBO uocOrdShipItemRspBO = new UocOrdShipItemRspBO();
                BeanUtils.copyProperties((Object)ordShipItemRspBO, (Object)uocOrdShipItemRspBO);
                if (null != reqBO.getAfterDimension()) {
                    if (UocCoreConstant.shipAfterDimension.SHIPPING.equals(reqBO.getAfterDimension())) {
                        if (null != ordShipItemRspBO.getReturnCount() && BigDecimal.ZERO.compareTo(ordShipItemRspBO.getReturnCount()) < 0) {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getSendCount().subtract(ordShipItemRspBO.getReturnCount()));
                        } else {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getSendCount());
                        }
                    } else if (UocCoreConstant.shipAfterDimension.ARRIVED.equals(reqBO.getAfterDimension())) {
                        if (null != ordShipItemRspBO.getReturnCount() && BigDecimal.ZERO.compareTo(ordShipItemRspBO.getReturnCount()) < 0) {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getArriveCount().subtract(ordShipItemRspBO.getReturnCount()));
                        } else {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getArriveCount());
                        }
                    } else if (UocCoreConstant.shipAfterDimension.ACCEPTED.equals(reqBO.getAfterDimension())) {
                        if (null != ordShipItemRspBO.getReturnCount() && BigDecimal.ZERO.compareTo(ordShipItemRspBO.getReturnCount()) < 0) {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getAcceptanceCount().subtract(ordShipItemRspBO.getReturnCount()));
                        } else {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getAcceptanceCount());
                        }
                    }
                }
                ordShipItemRspBOList.add(uocOrdShipItemRspBO);
            }
            uocShipDetailsQueryRspBO.setOrdShipItemRspBOList(ordShipItemRspBOList);
        }
        uocShipDetailsQueryRspBO.setRespCode("0000");
        uocShipDetailsQueryRspBO.setRespDesc("\u6210\u529f");
        return uocShipDetailsQueryRspBO;
    }

    public void transOrdShip(UocOrdShipRspBO ordShipRspBO) {
        String vendorOrderType;
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(ordShipRspBO.getShipStatus() + "");
        dictReqBO.setPcode("SHIP_ORDER_STATUS");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordShipRspBO.setShipStatusStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        if (MapUtils.isNotEmpty((Map)ordShipRspBO.getShipExtraMap()) && (vendorOrderType = (String)ordShipRspBO.getShipExtraMap().get("vendorOrderType")) != null) {
            dictReqBO.setCode(vendorOrderType);
            dictReqBO.setPcode("VENDOR_ORDER_TYPE");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                ordShipRspBO.setVendorOrderTypeStr(dictRspBO.getDicDictionarys().getDescrip());
            }
        }
    }

    private void buildOrdStakeholderRspBO(UocOrdShipRspBO ordShipRspBO) {
        OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(ordShipRspBO.getOrderId().longValue());
        OrdLogisticsRelaPO ordLogisticsRelaPO = new OrdLogisticsRelaPO();
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(ordShipRspBO.getOrderId());
        OrdSalePO salePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (null != salePO) {
            ordLogisticsRelaPO.setOrderId(ordShipRspBO.getOrderId());
            ordLogisticsRelaPO.setContactId(salePO.getContactId());
            OrdLogisticsRelaPO relaPO = this.ordLogisticsRelaMapper.getModelBy(ordLogisticsRelaPO);
            OrdStakeholderRspBO ordStakeholderRspBO = new OrdStakeholderRspBO();
            if (null != ordStakeholderPO) {
                BeanUtils.copyProperties((Object)ordStakeholderPO, (Object)ordStakeholderRspBO);
            }
            if (null != relaPO) {
                ordStakeholderRspBO.setPurAddress(relaPO.getContactAddress());
            }
            UocOrdStakeholderRspBO uocOrdStakeholderRspBO = new UocOrdStakeholderRspBO();
            BeanUtils.copyProperties((Object)ordStakeholderRspBO, (Object)uocOrdStakeholderRspBO);
            ordShipRspBO.setOrdStakeholderRspBO(uocOrdStakeholderRspBO);
            ordShipRspBO.setSaleVoucherNo(salePO.getSaleVoucherNo());
        }
    }
}

