/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.UocPebApproveReqBO;
import com.tydic.uoc.common.ability.bo.UocPebApproveRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelRspBO;
import com.tydic.uoc.common.ability.bo.UocPebPreOrderSubmitReqBO;
import com.tydic.uoc.common.ability.bo.UocPebPreOrderSubmitRspBO;
import com.tydic.uoc.common.busi.api.UocPebApproveBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderCancelBusiService;
import com.tydic.uoc.common.busi.api.UocPebPreOrderSubmitBsuiService;
import com.tydic.uoc.common.busi.bo.UocPebApproveBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocPebApproveBusiRspBO;
import com.tydic.uoc.common.comb.api.UocPebApproveCombService;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.po.OrdExtMapPO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebApproveCombService")
public class UocPebApproveCombServiceImpl
implements UocPebApproveCombService {
    private static final Logger log = LoggerFactory.getLogger(UocPebApproveCombServiceImpl.class);
    @Autowired
    private UocPebApproveBusiService uocPebApproveBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UocPebOrderCancelBusiService uocPebOrderCancelBusiService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private UocPebPreOrderSubmitBsuiService uocPebPreOrderSubmitBsuiService;

    @Override
    public UocPebApproveRspBO dealPebApprove(UocPebApproveReqBO reqBO) {
        UocPebApproveRspBO rsp = new UocPebApproveRspBO();
        this.validateParam(reqBO);
        UocPebApproveBusiReqBO approveBusiReqBO = new UocPebApproveBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)approveBusiReqBO));
        UocPebApproveBusiRspBO busiRspBO = this.uocPebApproveBusiService.dealPebApprove(approveBusiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new UocProBusinessException("103008", busiRspBO.getRespDesc());
        }
        if (busiRspBO.getFinish().booleanValue()) {
            if ("1".equals(reqBO.getFlag())) {
                if (busiRspBO.getPay() == null) {
                    rsp.setPass(Boolean.valueOf(true));
                } else {
                    rsp.setPass(Boolean.valueOf(true));
                }
            } else {
                this.cancel(reqBO, "\u8ba2\u5355\u5ba1\u6279\u4e0d\u901a\u8fc7", null);
            }
        }
        this.uocPebOrdIdxSync(busiRspBO.getOrderId(), busiRspBO.getSaleId());
        rsp.setRespCode("0000");
        if ("1".equals(reqBO.getFlag())) {
            rsp.setRespDesc("\u5ba1\u6279\u901a\u8fc7\u6210\u529f\uff01");
        } else {
            rsp.setRespDesc("\u5ba1\u6279\u9a73\u56de\u6210\u529f\uff01");
        }
        return rsp;
    }

    private String submit(UocPebApproveReqBO busiReqBO) {
        OrdExtMapPO reqBO = new OrdExtMapPO();
        reqBO.setOrderId(busiReqBO.getOrderId());
        reqBO.setObjId(busiReqBO.getOrderId());
        reqBO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        reqBO.setFieldCode("preOrder");
        try {
            List list = this.ordExtMapMapper.getList(reqBO);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                UocPebPreOrderSubmitReqBO submitReqBO = new UocPebPreOrderSubmitReqBO();
                submitReqBO.setSaleVoucherId(busiReqBO.getSaleVoucherId());
                submitReqBO.setOrderId(busiReqBO.getOrderId());
                submitReqBO.setUserId(busiReqBO.getUserId());
                submitReqBO.setUsername(busiReqBO.getUsername());
                UocPebPreOrderSubmitRspBO submitRspBO = this.uocPebPreOrderSubmitBsuiService.submit(submitReqBO);
                if (!"0000".equals(submitRspBO.getRespCode())) {
                    this.cancel(busiReqBO, "\u7535\u5546\u8ba2\u5355\u5931\u8d25" + submitRspBO.getRespDesc(), "103008");
                    return submitRspBO.getRespDesc();
                }
            }
        }
        catch (Exception e) {
            throw new UocProBusinessException("103008", "\u5ba1\u6279\u65f6\u67e5\u8be2\u662f\u5426\u662f\u9884\u5b9a\u5355\u5931\u8d25" + e.getMessage());
        }
        return null;
    }

    private void cancel(UocPebApproveReqBO reqBO, String desc, String fail) {
        UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
        cancelReqBO.setOrderId(reqBO.getOrderId());
        cancelReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        cancelReqBO.setCancelOperId(String.valueOf(reqBO.getUserId()));
        cancelReqBO.setCancelDesc(desc);
        cancelReqBO.setCancelReason(desc);
        cancelReqBO.setFailCode(fail);
        cancelReqBO.setIsCancelWF(Boolean.valueOf(false));
        cancelReqBO.setNotInterface(Boolean.valueOf(true));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("approvalResult", "0");
        cancelReqBO.setVariables(map);
        UocPebOrderCancelRspBO rspBO = this.uocPebOrderCancelBusiService.dealOrderCancel(cancelReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("103008", "\u8ba2\u5355\u53d6\u6d88\u5931\u8d25" + rspBO.getRespDesc());
        }
    }

    private void validateParam(UocPebApproveReqBO combReqBO) {
        if (null == combReqBO) {
            throw new UocProBusinessException("100002", "\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (combReqBO.getSaleVoucherId() == null) {
            throw new UocProBusinessException("100002", "\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010SaleVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (combReqBO.getOrderId() == null) {
            throw new UocProBusinessException("100002", "\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010OrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)combReqBO.getFlag())) {
            throw new UocProBusinessException("100002", "\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010Flag\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (combReqBO.getUserId() == null) {
            throw new UocProBusinessException("100002", "\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010UserId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)combReqBO.getDealDesc())) {
            throw new UocProBusinessException("100002", "\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u5ba1\u6279\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void uocPebOrdIdxSync(Long orderId, Long saleId) {
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setObjId(saleId);
        reqBO.setOrderId(orderId);
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
    }
}

