/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.uoc.base.bo.UocProBaseRspBo;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.busibase.busi.api.PebIntfCancelPurchaseOrderAbilityService;
import com.tydic.uoc.busibase.busi.bo.PebIntfCancelPurchaseOrderAbilityReqBo;
import com.tydic.uoc.busibase.busi.bo.PebIntfCancelPurchaseOrderAbilityRspBo;
import com.tydic.uoc.common.busi.bo.UocReverseReqBO;
import com.tydic.uoc.common.comb.api.PebReverseCombService;
import com.tydic.uoc.common.comb.api.UocSyncStatisticsInfoCombService;
import com.tydic.uoc.common.comb.bo.UocSyncStatisticsInfoCombReqBO;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdSalePO;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class PebReverseConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(PebReverseConsumer.class);
    @Autowired
    private PebReverseCombService pebReverseCombService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private PebIntfCancelPurchaseOrderAbilityService pebIntfCancelPurchaseOrderAbilityService;
    @Autowired
    private UocSyncStatisticsInfoCombService uocSyncStatisticsInfoCombService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u8ba2\u5355\u53d6\u6d88\uff0c\u552e\u540e\uff0c\u5f02\u5e38\u53d8\u66f4");
            }
            UocReverseReqBO reqBO = (UocReverseReqBO)JSON.parseObject((String)proxyMessage.getContent(), UocReverseReqBO.class);
            log.info("\u8ba2\u5355\u9006\u5411\u6d88\u8d39" + JSON.toJSONString((Object)reqBO));
            UocProBaseRspBo rspBO = this.pebReverseCombService.reverse(reqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                return ProxyConsumerStatus.RECONSUME_LATER;
            }
            if (!reqBO.getObjType().equals(UocCoreConstant.OBJ_TYPE.SALE)) {
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            Object ecp = new OrdExtMapPO();
            ecp.setFieldCode("isSuccess");
            ecp.setOrderId(reqBO.getOrderId());
            ecp.setObjId(reqBO.getOrderId());
            ecp.setObjType(UocCoreConstant.OBJ_TYPE.ORDER);
            List ordExtMapPOS = this.ordExtMapMapper.getList(ecp);
            ecp = !CollectionUtils.isEmpty((Collection)ordExtMapPOS) ? (OrdExtMapPO)ordExtMapPOS.get(0) : null;
            if (UocCoreConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
                UocSyncStatisticsInfoCombReqBO syncStatisticsInfoCombReqBO = new UocSyncStatisticsInfoCombReqBO();
                syncStatisticsInfoCombReqBO.setOrderId(reqBO.getOrderId());
                syncStatisticsInfoCombReqBO.setSaleVoucherId(reqBO.getObjId());
                syncStatisticsInfoCombReqBO.setIsLess(true);
                this.uocSyncStatisticsInfoCombService.syncStatisticsInfo(syncStatisticsInfoCombReqBO);
            }
            if (ecp == null) {
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            this.pushEcp(reqBO);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }

    private void pushEcp(UocReverseReqBO reqBO) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        PebIntfCancelPurchaseOrderAbilityReqBo reqBo = new PebIntfCancelPurchaseOrderAbilityReqBo();
        reqBo.setXTBS("DZSC");
        reqBo.setJKBS("DZSC_DDJK");
        reqBo.setYWBH(ordSalePO.getSaleVoucherNo());
        reqBo.setCZBS("ZZ");
        PebIntfCancelPurchaseOrderAbilityRspBo rspBo = this.pebIntfCancelPurchaseOrderAbilityService.cancelPurchaseOrder(reqBo);
        if (!"0000".equals(rspBo.getRespCode())) {
            // empty if block
        }
    }
}

