/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.PebExtApprovalOrderAbilityService;
import com.tydic.uoc.common.ability.api.UocProOrderPaymentAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtApprovalOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebExtApprovalOrderRspBO;
import com.tydic.uoc.common.ability.bo.PebExtDealOrderBO;
import com.tydic.uoc.common.ability.bo.UocProOrderPaymentAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProOrderPaymentAbilityRspBo;
import com.tydic.uoc.common.atom.bo.KafkaConsumerRspBo;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.config.KafKaListener;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdInterLogMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdInterLogPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.util.StringUtils;

@Configuration
@EnableKafka
public class KafKaComsumer {
    private static final Logger log = LoggerFactory.getLogger(KafKaComsumer.class);
    @Value(value="${KAFKA_GROUP_ID:lsugu.to.bpm.approval}")
    private String KAFKA_GROUP_ID;
    @Value(value="${KAFKA_TOPIC:lsugu.to.bpm.approval}")
    private String KAFKA_TOPIC;
    @Value(value="${KAFKA_BOOTSTRAP_SERVERS:kafka-test.liando.cn:31090,kafka-test.liando.cn:31091,kafka-test.liando.cn:31092}")
    private String KAFKA_BOOTSTRAP_SERVERS;
    @Value(value="${KAFKA_ENABLE_AUTO_COMMIT:true}")
    private String KAFKA_ENABLE_AUTO_COMMIT;
    @Value(value="${KAFKA_AUTO_COMMIT_INTERVAL_MS:1000}")
    private String KAFKA_AUTO_COMMIT_INTERVAL_MS;
    @Value(value="${KAFKA_AUTO_OFFSET_RESET:earliest}")
    private String KAFKA_AUTO_OFFSET_RESET;
    @Value(value="${KAFKA_SESSION_TIMEOUT_MS:3000}")
    private String KAFKA_SESSION_TIMEOUT_MS;
    @Value(value="${KAFKA_KEY_DESERIALIZER:org.apache.kafka.common.serialization.StringDeserializer}")
    private String KAFKA_KEY_DESERIALIZER;
    @Value(value="${KAFKA_VALUE_DESERIALIZER:org.apache.kafka.common.serialization.StringDeserializer}")
    private String KAFKA_VALUE_DESERIALIZER;
    private ConsumerRecords<String, String> msgList;
    private KafkaConsumer<String, String> stringStringKafkaConsumer;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private PebExtApprovalOrderAbilityService pebExtApprovalOrderAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdInterLogMapper ordInterLogMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocProOrderPaymentAbilityService uocProOrderPaymentAbilityService;

    @Bean
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, String>> socketKafkaListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.getContainerProperties().setPollTimeout(1500L);
        return factory;
    }

    public ConsumerFactory<String, String> consumerFactory() {
        return new DefaultKafkaConsumerFactory(this.consumerConfigs());
    }

    public Map<String, Object> consumerConfigs() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.KAFKA_BOOTSTRAP_SERVERS);
        props.put("group.id", this.KAFKA_GROUP_ID);
        props.put("enable.auto.commit", this.KAFKA_ENABLE_AUTO_COMMIT);
        props.put("auto.commit.interval.ms", this.KAFKA_AUTO_COMMIT_INTERVAL_MS);
        props.put("auto.offset.reset", this.KAFKA_AUTO_OFFSET_RESET);
        props.put("session.timeout.ms", this.KAFKA_SESSION_TIMEOUT_MS);
        props.put("key.deserializer", this.KAFKA_KEY_DESERIALIZER);
        props.put("value.deserializer", this.KAFKA_VALUE_DESERIALIZER);
        this.stringStringKafkaConsumer = new KafkaConsumer(props);
        this.stringStringKafkaConsumer.subscribe(Collections.singletonList(this.KAFKA_TOPIC));
        this.run();
        log.debug("\u6d41\u7a0b\u5f15\u64ce\u6536\u5230kafka\u6d88\u606f\u7ed3\u675f---------------------------------------------");
        return props;
    }

    public void run() {
        log.debug("\u6d41\u7a0b\u5f15\u64ce\u6536\u5230kafka\u6d88\u606f\u5f00\u59cb---------------------------------\uff1a" + this.msgList);
        this.msgList = this.stringStringKafkaConsumer.poll(Duration.ofMillis(1000L));
        log.debug("\u6d41\u7a0b\u5f15\u64ce\u6536\u5230kafka\u6d88\u606f\u6570---------------------------------\uff1a" + this.msgList);
        for (ConsumerRecord record : this.msgList) {
            log.debug("\u6d41\u7a0b\u5f15\u64ce\u6536\u5230kafka\u6d88\u606f------------------------------------\uff1a" + record.toString());
            log.debug("kafka\u6d88\u606fvalue--------------------------------------\uff1a" + (String)record.value());
            KafkaConsumerRspBo kafkaConsumerRspBo = (KafkaConsumerRspBo)JSON.parseObject((String)((String)record.value()), KafkaConsumerRspBo.class);
            log.debug("kafka\u6d88\u606fvalue\u8f6c\u6362\u540e\u53c2\u6570--------------------------------------\uff1a" + kafkaConsumerRspBo);
            if (UocConstant.EventType.PROCESS_STARTED.equals(kafkaConsumerRspBo.getEventType())) {
                log.debug("kafka\u6d88\u606f\u8fdb\u5165\u53d1\u8d77\u5ba1\u6279\u6a21\u5757--------------------------------------\uff1a" + kafkaConsumerRspBo);
                if (!this.updateFlowState(kafkaConsumerRspBo)) continue;
                this.insertFailLog((ConsumerRecord<String, String>)record, kafkaConsumerRspBo);
                continue;
            }
            if (!UocConstant.EventType.APPROVED.equals(kafkaConsumerRspBo.getEventType()) && !UocConstant.EventType.DISMISS_THE_ORIGINATOR.equals(kafkaConsumerRspBo.getEventType())) continue;
            log.debug("kafka\u6d88\u606f\u8fdb\u5165\u5ba1\u6279\u6a21\u5757--------------------------------------\uff1a" + kafkaConsumerRspBo);
            if (!this.doApproval(kafkaConsumerRspBo)) continue;
            this.insertFailLog((ConsumerRecord<String, String>)record, kafkaConsumerRspBo);
        }
    }

    private void insertFailLog(ConsumerRecord<String, String> record, KafkaConsumerRspBo kafkaConsumerRspBo) {
        log.debug("kafka\u5931\u8d25\u65e5\u5fd7\u8bb0\u5f55\u5f00\u59cb---------------------------------");
        OrdInterLogPO interLogPo = new OrdInterLogPO();
        interLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        interLogPo.setObjType(UocConstant.OBJ_TYPE.ORDER);
        interLogPo.setOutContent(record.toString());
        interLogPo.setInContent(record.toString());
        interLogPo.setObjId(Long.valueOf(kafkaConsumerRspBo.getInstanceId()));
        interLogPo.setOrderId(Long.valueOf(kafkaConsumerRspBo.getInstanceId()));
        interLogPo.setInterSn("kafka\u6d41\u7a0b\u5f15\u64ce\u63a5\u53e3");
        interLogPo.setInterCode("flowKey");
        interLogPo.setCreateTime(new Date());
        interLogPo.setRetTime(new Date());
        interLogPo.setCreateTime(new Date());
        interLogPo.setErrDetail("kafka\u6d41\u7a0b\u5f15\u64ce\u63a5\u53e3\u6d88\u8d39\u5f02\u5e38");
        try {
            this.ordInterLogMapper.insert(interLogPo);
        }
        catch (Exception ignored) {
            log.debug("kafka\u6d41\u7a0b\u5f15\u64ce\u63a5\u53e3\u6d88\u8d39\u5f02\u5e38\u5931\u8d25\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25---------------------------------------------" + kafkaConsumerRspBo.getInstanceId());
        }
    }

    private boolean doApproval(KafkaConsumerRspBo kafkaConsumerRspBo) {
        OrdExtMapPO ordExtMapPo = new OrdExtMapPO();
        ordExtMapPo.setFieldCode("encryptId");
        ordExtMapPo.setFieldValue(kafkaConsumerRspBo.getInstanceId());
        OrdExtMapPO modelByExt = this.ordExtMapMapper.getModelBy(ordExtMapPo);
        if (modelByExt == null) {
            log.debug("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5b9e\u4f8b\u5bf9\u5e94\u7684\u8ba2\u5355-----------------------------------" + kafkaConsumerRspBo.getInstanceId());
            return true;
        }
        OrdSalePO ordSalePo = new OrdSalePO();
        ordSalePo.setOrderId(modelByExt.getOrderId());
        OrdSalePO modelBy = this.ordSaleMapper.getModelBy(ordSalePo);
        if (modelBy == null) {
            log.debug("kafka\u56de\u4f20\u6d88\u606f\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u4e3a\u7a7a-------------------------------------");
            return true;
        }
        OrdStakeholderPO ordStakeholderPo = new OrdStakeholderPO();
        ordStakeholderPo.setOrderId(modelByExt.getOrderId());
        OrdStakeholderPO modelByShd = this.ordStakeholderMapper.getModelBy(ordStakeholderPo);
        if (modelByShd == null) {
            log.debug("kafka\u56de\u4f20\u6d88\u606f\u67e5\u8be2\u9500\u552e\u5355\u4e0b\u5355\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a-------------------------------------");
            return true;
        }
        log.debug("kafka\u6d88\u606f\u8fdb\u5165\u8ba2\u5355\u5ba1\u6279\u5f00\u59cb----------------------------------------------------------" + kafkaConsumerRspBo);
        PebExtApprovalOrderReqBO pebExtApprovalOrderReqBO = new PebExtApprovalOrderReqBO();
        pebExtApprovalOrderReqBO.setDealDesc(null);
        boolean isSkipPendingPayment = false;
        if (UocConstant.EventType.APPROVED.equals(kafkaConsumerRspBo.getEventType())) {
            pebExtApprovalOrderReqBO.setFlag(UocConstant.ACTION_RESULT.PASS.toString());
            if ("2".equals(this.orderMapper.getModelById(modelBy.getOrderId().longValue()).getPayType())) {
                isSkipPendingPayment = true;
            }
        } else {
            pebExtApprovalOrderReqBO.setFlag(UocConstant.ACTION_RESULT.NO_PASS.toString());
        }
        pebExtApprovalOrderReqBO.setPageType(Integer.valueOf(1));
        ArrayList<PebExtDealOrderBO> pebExtDealOrderBoS = new ArrayList<PebExtDealOrderBO>();
        PebExtDealOrderBO pebExtDealOrderBo = new PebExtDealOrderBO();
        pebExtDealOrderBo.setOrderId(modelBy.getOrderId());
        pebExtDealOrderBo.setSaleVoucherId(modelBy.getSaleVoucherId());
        pebExtDealOrderBoS.add(pebExtDealOrderBo);
        pebExtApprovalOrderReqBO.setOrderInfo(pebExtDealOrderBoS);
        pebExtApprovalOrderReqBO.setUsername(modelByShd.getPurPlaceOrderName());
        if (!StringUtils.isEmpty((Object)modelByShd.getPurPlaceOrderId())) {
            pebExtApprovalOrderReqBO.setUserId(Long.valueOf(modelByShd.getPurPlaceOrderId()));
        }
        pebExtApprovalOrderReqBO.setOrgName(modelByShd.getPurName());
        pebExtApprovalOrderReqBO.setOrgId(Long.valueOf(modelByShd.getPurNo()));
        PebExtApprovalOrderRspBO pebExtApprovalOrderRspBO = this.pebExtApprovalOrderAbilityService.dealApprovalOrder(pebExtApprovalOrderReqBO);
        if (isSkipPendingPayment) {
            UocProOrderPaymentAbilityReqBo paymentAbilityReqBo = new UocProOrderPaymentAbilityReqBo();
            paymentAbilityReqBo.setOrderId(modelBy.getOrderId());
            paymentAbilityReqBo.setUserId(UocConstant.SystemInputBaseClass.USER_ID);
            paymentAbilityReqBo.setUserIdIn(UocConstant.SystemInputBaseClass.USER_ID);
            paymentAbilityReqBo.setMemId(UocConstant.SystemInputBaseClass.USER_ID);
            paymentAbilityReqBo.setMemIdIn(UocConstant.SystemInputBaseClass.USER_ID);
            paymentAbilityReqBo.setMemIdExt(UocConstant.SystemInputBaseClass.USER_ID);
            paymentAbilityReqBo.setUsername("\u7cfb\u7edf");
            UocProOrderPaymentAbilityRspBo paymentAbilityRspBo = this.uocProOrderPaymentAbilityService.dealPay(paymentAbilityReqBo);
            if (!"0000".equals(paymentAbilityRspBo.getRespCode())) {
                log.info("\u662f\u5426\u8df3\u8fc7\u5f85\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSON.toJSONString((Object)paymentAbilityRspBo));
            }
        }
        return !"0000".equals(pebExtApprovalOrderRspBO.getRespCode());
    }

    private boolean updateFlowState(KafkaConsumerRspBo kafkaConsumerRspBo) {
        OrdExtMapPO ordExtMapPo = new OrdExtMapPO();
        ordExtMapPo.setFieldCode("encryptId");
        ordExtMapPo.setFieldValue(kafkaConsumerRspBo.getInstanceId());
        OrdExtMapPO modelBy = this.ordExtMapMapper.getModelBy(ordExtMapPo);
        if (modelBy == null) {
            log.debug("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5b9e\u4f8b\u5bf9\u5e94\u7684\u8ba2\u5355-----------------------------------" + kafkaConsumerRspBo.getInstanceId());
            return true;
        }
        OrdExtMapPO ordExtMapPoWhere = new OrdExtMapPO();
        ordExtMapPoWhere.setOrderId(modelBy.getOrderId());
        ordExtMapPoWhere.setFieldCode("isStartFlowState");
        OrdExtMapPO ordExtMapPoSet = new OrdExtMapPO();
        ordExtMapPoSet.setFieldValue(UocConstant.IsStartFlowState.SEND.toString());
        int update = this.ordExtMapMapper.updateBy(ordExtMapPoSet, ordExtMapPoWhere);
        if (update < 1) {
            log.debug("\u8ba2\u5355\u6269\u5c55\uff0c\u65b0\u589e\u6d41\u7a0b\u5b9e\u4f8b\u52a0\u5bc6\u6620\u5c04\u5931\u8d25----------------------------------------" + kafkaConsumerRspBo.getInstanceId());
        }
        OrdSalePO ordSalePo = new OrdSalePO();
        ordSalePo.setOrderId(modelBy.getOrderId());
        OrdSalePO modelByOrd = this.ordSaleMapper.getModelBy(ordSalePo);
        if (modelByOrd == null) {
            log.debug("kafka\u56de\u4f20\u6d88\u606f\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u4e3a\u7a7a-------------------------------------");
            return true;
        }
        this.idxSync(modelByOrd.getOrderId(), modelByOrd.getSaleVoucherId());
        return false;
    }

    private void idxSync(Long orderId, Long saleVoucherId) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(saleVoucherId);
        uocOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdIdxSyncReqBO.setOrderId(orderId);
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    @Bean
    public KafKaListener listener() {
        return new KafKaListener();
    }
}

